/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.cofh;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.ai.DroneAIBlockCondition;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICondition;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetArea;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.progwidgets.ProgWidgetCondition;
import pneumaticCraft.common.progwidgets.ProgWidgetString;
import pneumaticCraft.lib.Textures;

public class ProgWidgetRFCondition
extends ProgWidgetCondition {
    @Override
    public String getWidgetString() {
        return "conditionRF";
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class, ProgWidgetString.class};
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(ChunkPosition pos) {
                TileEntity te = this.drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                int energy = 0;
                if (te instanceof IEnergyReceiver) {
                    for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                        if (!ProgWidgetRFCondition.this.getSides()[d.ordinal()]) continue;
                        energy = Math.max(((IEnergyReceiver)te).getEnergyStored(d), energy);
                    }
                }
                if (te instanceof IEnergyProvider) {
                    for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                        if (!ProgWidgetRFCondition.this.getSides()[d.ordinal()]) continue;
                        energy = Math.max(((IEnergyProvider)te).getEnergyStored(d), energy);
                    }
                }
                return ((ICondition)((Object)this.widget)).getOperator() == ICondition.Operator.EQUALS ? energy == ((ICondition)((Object)this.widget)).getRequiredCount() : energy >= ((ICondition)((Object)this.widget)).getRequiredCount();
            }
        };
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_RF;
    }
}

