/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.cofh;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.tileentity.IEnergyInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.thirdparty.cofh.CoFHCore;
import pneumaticCraft.common.thirdparty.cofh.IRFConverter;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityAdvancedAirCompressor;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;

public class TileEntityPneumaticDynamo
extends TileEntityPneumaticBase
implements IEnergyHandler,
IEnergyInfo,
IInventory,
IRedstoneControlled,
IRFConverter,
IMinWorkingPressure,
IHeatExchanger {
    private final EnergyStorage energy = new EnergyStorage(100000);
    @GuiSynced
    private int rfPerTick;
    @GuiSynced
    private int airPerTick;
    @DescSynced
    public boolean isEnabled;
    private final ItemStack[] inventory = new ItemStack[4];
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();

    public TileEntityPneumaticDynamo() {
        super(20.0f, 25.0f, 10000);
        this.setUpgradeSlots(0, 1, 2, 3);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    public int getEfficiency() {
        return TileEntityAdvancedAirCompressor.getEfficiency(this.heatExchanger.getTemperature());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            IEnergyReceiver recv;
            TileEntity receiver;
            boolean newEnabled;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                int efficiency = Config.pneumaticDynamoEfficiency;
                if (efficiency < 1) {
                    efficiency = 1;
                }
                this.airPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * 100.0f / (float)efficiency);
                this.rfPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * (float)this.getEfficiency() / 100.0f);
            }
            if (this.redstoneAllows() && this.getPressure(ForgeDirection.UNKNOWN) > 15.0f && this.getMaxEnergyStored(ForgeDirection.UNKNOWN) - this.getEnergyStored(ForgeDirection.UNKNOWN) >= this.rfPerTick) {
                this.addAir(-this.airPerTick, ForgeDirection.UNKNOWN);
                this.heatExchanger.addHeat((double)this.airPerTick / 100.0);
                this.energy.receiveEnergy(this.rfPerTick, false);
                newEnabled = true;
            } else {
                newEnabled = false;
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L && newEnabled != this.isEnabled) {
                this.isEnabled = newEnabled;
                this.sendDescriptionPacket();
            }
            if ((receiver = this.getTileCache()[this.getRotation().getOpposite().ordinal()].getTileEntity()) instanceof IEnergyReceiver && (recv = (IEnergyReceiver)receiver).canConnectEnergy(this.getRotation())) {
                int extracted = this.energy.extractEnergy(this.rfPerTick * 2, true);
                int energyPushed = recv.receiveEnergy(this.getRotation(), extracted, true);
                if (energyPushed > 0) {
                    recv.receiveEnergy(this.getRotation(), this.energy.extractEnergy(energyPushed, false), false);
                }
            }
        }
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.getRotation().getOpposite();
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        return side == this.getRotation();
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        maxExtract = Math.min(maxExtract, this.getRFRate() * 2);
        return this.energy.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energy.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energy.getMaxEnergyStored();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    public int getInfoEnergyPerTick() {
        return this.rfPerTick;
    }

    public int getInfoMaxEnergyPerTick() {
        return this.energy.getMaxExtract();
    }

    public int getInfoEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getInfoMaxEnergyStored() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.energy.writeToNBT(tag);
        TileEntityPneumaticDynamo.writeInventoryToNBT(tag, this.inventory);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74757_a("isEnabled", this.isEnabled);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
        TileEntityPneumaticDynamo.readInventoryFromNBT(tag, this.inventory);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.isEnabled = tag.func_74767_n("isEnabled");
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return CoFHCore.pneumaticDynamo.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack itemstack) {
        return itemstack != null && itemstack.func_77973_b() == Itemss.machineUpgrade;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0 && ++this.redstoneMode > 2) {
            this.redstoneMode = 0;
        }
    }

    @Override
    public int getRFRate() {
        return this.rfPerTick;
    }

    @Override
    public int getAirRate() {
        return this.airPerTick;
    }

    @Override
    public float getMinWorkingPressure() {
        return 15.0f;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.energy;
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(ForgeDirection side) {
        return this.heatExchanger;
    }
}

