/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.enderio;

import cpw.mods.fml.common.event.FMLInterModComms;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.common.PneumaticCraftAPIHandler;
import pneumaticCraft.common.fluid.Fluids;
import pneumaticCraft.common.thirdparty.IThirdParty;
import pneumaticCraft.lib.Log;

public class EnderIO
implements IThirdParty {
    @Override
    public void preInit() {
        this.registerFuel(Fluids.diesel);
        this.registerFuel(Fluids.kerosene);
        this.registerFuel(Fluids.gasoline);
        this.registerFuel(Fluids.lpg);
    }

    private void registerFuel(Fluid fluid) {
        this.registerFuel(fluid, 60, PneumaticCraftAPIHandler.getInstance().liquidFuels.get(fluid.getName()) / 60);
    }

    private void registerFuel(Fluid fluid, int powerPerCycle, int burnTime) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("fluidName", fluid.getName());
        tag.func_74768_a("powerPerCycle", powerPerCycle);
        tag.func_74768_a("totalBurnTime", burnTime);
        FMLInterModComms.sendMessage((String)"EnderIO", (String)"fluidFuel:add", (NBTTagCompound)tag);
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        Fluid hootch = FluidRegistry.getFluid((String)"hootch");
        Fluid rocketFuel = FluidRegistry.getFluid((String)"rocket_fuel");
        Fluid fireWater = FluidRegistry.getFluid((String)"fire_water");
        if (hootch != null) {
            PneumaticRegistry.getInstance().registerFuel(hootch, 360000);
        } else {
            Log.warning("Couldn't find a fluid with name 'hootch' even though EnderIO is in the instance. It hasn't been registered as fuel!");
        }
        if (rocketFuel != null) {
            PneumaticRegistry.getInstance().registerFuel(rocketFuel, 0x111700);
        } else {
            Log.warning("Couldn't find a fluid with name 'rocket_fuel' even though EnderIO is in the instance. It hasn't been registered as fuel!");
        }
        if (fireWater != null) {
            PneumaticRegistry.getInstance().registerFuel(fireWater, 1200000);
        } else {
            Log.warning("Couldn't find a fluid with name 'fire_water' even though EnderIO is in the instance. It hasn't been registered as fuel!");
        }
    }

    @Override
    public void clientSide() {
    }

    @Override
    public void clientInit() {
    }
}

