/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.fmp;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.PartMap;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.block.IPneumaticWrenchable;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.client.model.ModelPressureTube;
import pneumaticCraft.common.block.BlockPressureTube;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.block.tubes.IPneumaticPosProvider;
import pneumaticCraft.common.block.tubes.TubeModule;
import pneumaticCraft.common.block.tubes.TubeModuleRedstoneEmitting;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.tileentity.TileEntityPressureTube;
import pneumaticCraft.lib.Log;

public class PartPressureTube
extends TMultiPart
implements IPneumaticPosProvider,
IPneumaticWrenchable,
TSlottedPart,
JNormalOcclusion,
ISidedHollowConnect,
IRedstonePart {
    private TileEntityPressureTube tube = this.getNewTube().setPart(this);
    private static final Cuboid6[] boundingBoxes = new Cuboid6[7];
    @SideOnly(value=Side.CLIENT)
    private static ModelPressureTube tubeModel;

    public PartPressureTube() {
    }

    public PartPressureTube(TileEntityPressureTube tube) {
        this.tube = tube.setPart(this);
    }

    @Override
    public IAirHandler getAirHandler() {
        return this.tube.getAirHandler();
    }

    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("tube")) {
            nbt = nbt.func_74775_l("tube");
        }
        this.tube.readFromNBTI(nbt);
    }

    public void save(NBTTagCompound nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        this.tube.writeToNBTI(tag);
        nbt.func_74782_a("tube", (NBTBase)tag);
    }

    protected TileEntityPressureTube getNewTube() {
        return new TileEntityPressureTube();
    }

    public void update() {
        if (Config.convertMultipartsToBlocks && !this.world().field_72995_K) {
            Log.info("Converting Pressure Tube part to Pressure Tube block at " + this.x() + ", " + this.y() + ", " + this.z());
            Block pressureTube = Block.func_149634_a((Item)this.getItem().func_77973_b());
            this.world().func_147449_b(this.x(), this.y(), this.z(), pressureTube);
            TileEntityPressureTube t = (TileEntityPressureTube)this.world().func_147438_o(this.x(), this.y(), this.z());
            NBTTagCompound tag = new NBTTagCompound();
            this.tube.writeToNBTI(tag);
            t.func_145839_a(tag);
            this.world().func_147459_d(this.x(), this.y(), this.z(), pressureTube);
            return;
        }
        this.tube.updateEntityI();
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        return this.tube.isConnectedTo(side);
    }

    public boolean passesOcclusionTest(ForgeDirection side) {
        TubeModule[] modules = this.tube.modules;
        this.tube.modules = new TubeModule[6];
        boolean result = this.tile() != null && this.tile().canAddPart((TMultiPart)new NormallyOccludedPart(boundingBoxes[side.ordinal()]));
        this.tube.modules = modules;
        return result;
    }

    public TileEntityPressureTube getTube() {
        return this.tube;
    }

    public void onWorldJoin() {
        this.tube.func_145834_a(this.world());
        this.tube.field_145851_c = this.x();
        this.tube.field_145848_d = this.y();
        this.tube.field_145849_e = this.z();
    }

    public void onPartChanged(TMultiPart part) {
        this.onNeighborChanged();
    }

    public void onNeighborChanged() {
        if (!this.world().field_72995_K) {
            this.tube.onNeighborTileUpdate();
            this.tube.onNeighborChange();
            this.tube.onNeighborBlockUpdate();
            this.sendDescriptionPacket();
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        boolean result = Blockss.pressureTube.func_149727_a(player.field_70170_p, this.x(), this.y(), this.z(), player, hit.field_72310_e, (float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c);
        if (result) {
            this.onNeighborChanged();
        }
        return result ? true : super.activate(player, hit, item);
    }

    public Cuboid6 getRenderBounds() {
        return Cuboid6.full;
    }

    public String getType() {
        return "tile.pressureTube";
    }

    public int getHollowSize(int side) {
        if (this.tube.modules[side] != null) {
            return Math.min(12, (int)(this.tube.modules[side].getWidth() * 16.0));
        }
        return 4;
    }

    public Iterable<ItemStack> getDrops() {
        List<ItemStack> drops = BlockPressureTube.getModuleDrops(this.getTube());
        drops.add(this.getItem());
        return drops;
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    public ItemStack getItem() {
        return new ItemStack(Blockss.pressureTube);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        ArrayList<Cuboid6> boxes = new ArrayList<Cuboid6>();
        boxes.add(boundingBoxes[6]);
        for (int i = 0; i < 6; ++i) {
            if (this.tube.modules[i] == null) continue;
            boxes.add(boundingBoxes[i]);
        }
        return boxes;
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> boxes = new ArrayList<Cuboid6>();
        boxes.add(boundingBoxes[6]);
        for (int i = 0; i < 6; ++i) {
            if (this.tube.sidesConnected[i]) {
                boxes.add(boundingBoxes[i]);
            }
            if (this.tube.modules[i] == null) continue;
            boxes.add(new Cuboid6(this.tube.modules[i].boundingBoxes[i]));
        }
        return boxes;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        Iterable<Cuboid6> boxList = this.getCollisionBoxes();
        LinkedList<IndexedCuboid6> partList = new LinkedList<IndexedCuboid6>();
        for (Cuboid6 c : boxList) {
            partList.add(new IndexedCuboid6((Object)0, c));
        }
        return partList;
    }

    public int getSlotMask() {
        return PartMap.CENTER.mask;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float partialTicks, int renderPass) {
        if (renderPass == 0) {
            TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)this.tube).func_147500_a((TileEntity)this.tube, pos.x, pos.y, pos.z, partialTicks);
        }
    }

    private void sendDescriptionPacket() {
        this.sendDescUpdate();
    }

    public void writeDesc(MCDataOutput packet) {
        for (int i = 0; i < 6; ++i) {
            packet.writeBoolean(this.tube.sidesConnected[i]);
        }
        NBTTagCompound tag = new NBTTagCompound();
        this.tube.func_145841_b(tag);
        packet.writeNBTTagCompound(tag);
    }

    public void readDesc(MCDataInput packet) {
        for (int i = 0; i < 6; ++i) {
            this.tube.sidesConnected[i] = packet.readBoolean();
        }
        this.tube.func_145839_a(packet.readNBTTagCompound());
    }

    public boolean canConnectRedstone(int side) {
        side ^= 1;
        for (int i = 0; i < 6; ++i) {
            if (this.tube.modules[i] == null || (side ^ 1) != i && (i == side || !this.tube.modules[i].isInline()) || !(this.tube.modules[i] instanceof TubeModuleRedstoneEmitting)) continue;
            return true;
        }
        return false;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        side ^= 1;
        int redstoneLevel = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.tube.modules[i] == null || (side ^ 1) != i && (i == side || !this.tube.modules[i].isInline())) continue;
            redstoneLevel = Math.max(redstoneLevel, this.tube.modules[i].getRedstoneLevel());
        }
        return redstoneLevel;
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, int x, int y, int z, ForgeDirection side) {
        return ((IPneumaticWrenchable)Blockss.pressureTube).rotateBlock(world, player, x, y, z, side);
    }

    static {
        PartPressureTube.boundingBoxes[0] = new Cuboid6(0.375, 0.0, 0.375, 0.625, 0.375, 0.625);
        PartPressureTube.boundingBoxes[1] = new Cuboid6(0.375, 0.625, 0.375, 0.625, 1.0, 0.625);
        PartPressureTube.boundingBoxes[2] = new Cuboid6(0.375, 0.375, 0.0, 0.625, 0.625, 0.375);
        PartPressureTube.boundingBoxes[3] = new Cuboid6(0.375, 0.375, 0.625, 0.625, 0.625, 1.0);
        PartPressureTube.boundingBoxes[4] = new Cuboid6(0.0, 0.375, 0.375, 0.375, 0.625, 0.625);
        PartPressureTube.boundingBoxes[5] = new Cuboid6(0.625, 0.375, 0.375, 1.0, 0.625, 0.625);
        PartPressureTube.boundingBoxes[6] = new Cuboid6(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    }
}

