/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.fluid.Fluids;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityKeroseneLamp
extends TileEntityBase
implements IFluidHandler,
IRedstoneControlled,
ISidedInventory {
    private final Set<ChunkPosition> managingLights = new HashSet<ChunkPosition>();
    @DescSynced
    private boolean isOn;
    @GuiSynced
    private int range;
    @GuiSynced
    private int targetRange = 10;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    private int fuel;
    private static final int LIGHT_SPACING = 3;
    public static final int FUEL_PER_MB = 10000;
    private int checkingX;
    private int checkingY;
    private int checkingZ;
    @DescSynced
    private ForgeDirection sideConnected = ForgeDirection.DOWN;
    @DescSynced
    private final FluidTank tank = new FluidTank(1000);
    private final ItemStack[] inventory = new ItemStack[2];

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.processFluidItem(0, 1);
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                int realTargetRange;
                int n = realTargetRange = this.redstoneAllows() ? this.targetRange : 0;
                if (this.redstoneMode == 3) {
                    realTargetRange = (int)((double)this.poweredRedstone / 15.0 * (double)this.targetRange);
                }
                this.updateRange(Math.min(realTargetRange, this.tank.getFluidAmount()));
                this.updateLights();
                this.useFuel();
            }
        } else if (this.isOn && this.field_145850_b.func_82737_E() % 5L == 0L) {
            this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.4 + 0.2 * this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_145848_d + 0.2 + (double)this.tank.getFluidAmount() / 1000.0 * 3.0 / 16.0, (double)this.field_145849_e + 0.4 + 0.2 * this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    private void useFuel() {
        this.fuel = (int)((double)this.fuel - Math.pow(this.range, 3.0));
        if (this.fuel < 0 && this.tank.drain(1, true) != null) {
            this.fuel += 10000;
        }
        if (this.fuel < 0) {
            this.fuel = 0;
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.checkingX = this.field_145851_c;
        this.checkingY = this.field_145848_d;
        this.checkingZ = this.field_145849_e;
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (ChunkPosition pos : this.managingLights) {
            if (!this.isLampLight(pos)) continue;
            this.field_145850_b.func_147468_f(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        }
    }

    private boolean isLampLight(ChunkPosition pos) {
        return this.field_145850_b.func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c) == Blockss.keroseneLampLight;
    }

    private void updateLights() {
        int roundedRange = this.range / 3 * 3;
        this.checkingX += 3;
        if (this.checkingX > this.field_145851_c + roundedRange) {
            this.checkingX = this.field_145851_c - roundedRange;
            this.checkingY += 3;
            if (this.checkingY > this.field_145848_d + roundedRange) {
                this.checkingY = this.field_145848_d - roundedRange;
                this.checkingZ += 3;
                if (this.checkingZ > this.field_145849_e + roundedRange) {
                    this.checkingZ = this.field_145849_e - roundedRange;
                }
            }
        }
        ChunkPosition pos = new ChunkPosition(this.checkingX, this.checkingY, this.checkingZ);
        ChunkPosition lampPos = new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.managingLights.contains(pos)) {
            if (this.isLampLight(pos)) {
                if (!this.passesRaytraceTest(pos, lampPos)) {
                    this.field_145850_b.func_147468_f(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                    this.managingLights.remove(pos);
                }
            } else {
                this.managingLights.remove(pos);
            }
        } else {
            this.tryAddLight(pos, lampPos);
        }
    }

    private void updateRange(int targetRange) {
        if (targetRange > this.range) {
            ++this.range;
            ChunkPosition lampPos = new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int roundedRange = this.range / 3 * 3;
            for (int x = -roundedRange; x <= roundedRange; x += 3) {
                for (int y = -roundedRange; y <= roundedRange; y += 3) {
                    for (int z = -roundedRange; z <= roundedRange; z += 3) {
                        ChunkPosition pos = new ChunkPosition(x + this.field_145851_c, y + this.field_145848_d, z + this.field_145849_e);
                        if (this.managingLights.contains(pos)) continue;
                        this.tryAddLight(pos, lampPos);
                    }
                }
            }
        } else if (targetRange < this.range) {
            --this.range;
            Iterator<ChunkPosition> iterator = this.managingLights.iterator();
            ChunkPosition lampPos = new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            while (iterator.hasNext()) {
                ChunkPosition pos = iterator.next();
                if (!this.isLampLight(pos)) {
                    iterator.remove();
                    continue;
                }
                if (!(PneumaticCraftUtils.distBetween(pos, lampPos) > (double)this.range)) continue;
                this.field_145850_b.func_147468_f(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                iterator.remove();
            }
        }
        this.isOn = this.range > 0;
    }

    private boolean passesRaytraceTest(ChunkPosition pos, ChunkPosition lampPos) {
        MovingObjectPosition mop = this.field_145850_b.func_72933_a(Vec3.func_72443_a((double)((double)pos.field_151329_a + 0.5), (double)((double)pos.field_151327_b + 0.5), (double)((double)pos.field_151328_c + 0.5)), Vec3.func_72443_a((double)((double)lampPos.field_151329_a + 0.5), (double)((double)lampPos.field_151327_b + 0.5), (double)((double)lampPos.field_151328_c + 0.5)));
        return mop != null && lampPos.equals((Object)new ChunkPosition(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d));
    }

    private boolean tryAddLight(ChunkPosition pos, ChunkPosition lampPos) {
        if (PneumaticCraftUtils.distBetween(pos, lampPos) <= (double)this.range && this.field_145850_b.func_147437_c(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c) && !this.isLampLight(pos) && this.passesRaytraceTest(pos, lampPos)) {
            this.field_145850_b.func_147449_b(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, Blockss.keroseneLampLight);
            this.managingLights.add(pos);
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.sideConnected = ForgeDirection.DOWN;
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            int x = this.field_145851_c + d.offsetX;
            int y = this.field_145848_d + d.offsetY;
            int z = this.field_145849_e + d.offsetZ;
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (!block.isSideSolid((IBlockAccess)this.field_145850_b, x, y, z, d.getOpposite())) continue;
            this.sideConnected = d;
            break;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(resource) ? this.drain(ForgeDirection.UNKNOWN, resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return Fluids.areFluidsEqual(fluid, Fluids.kerosene);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList lights = new NBTTagList();
        for (ChunkPosition pos : this.managingLights) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74768_a("x", pos.field_151329_a);
            t.func_74768_a("y", pos.field_151327_b);
            t.func_74768_a("z", pos.field_151328_c);
            lights.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("lights", (NBTBase)lights);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74774_a("targetRange", (byte)this.targetRange);
        tag.func_74774_a("range", (byte)this.range);
        tag.func_74774_a("sideConnected", (byte)this.sideConnected.ordinal());
        TileEntityKeroseneLamp.writeInventoryToNBT(tag, this.inventory);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.managingLights.clear();
        NBTTagList lights = tag.func_150295_c("lights", 10);
        for (int i = 0; i < lights.func_74745_c(); ++i) {
            NBTTagCompound t = lights.func_150305_b(i);
            this.managingLights.add(new ChunkPosition(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z")));
        }
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.targetRange = tag.func_74771_c("targetRange");
        this.range = tag.func_74771_c("range");
        this.sideConnected = ForgeDirection.getOrientation((int)tag.func_74771_c("sideConnected"));
        TileEntityKeroseneLamp.readInventoryFromNBT(tag, this.inventory);
    }

    @Override
    public boolean redstoneAllows() {
        if (this.redstoneMode == 3) {
            return true;
        }
        return super.redstoneAllows();
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 3) {
                this.redstoneMode = 0;
            }
        } else if (buttonID > 0 && buttonID <= 30) {
            this.targetRange = buttonID;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IFluidTank getTank() {
        return this.tank;
    }

    public int getRange() {
        return this.range;
    }

    public int getTargetRange() {
        return this.targetRange;
    }

    public int getFuel() {
        return this.fuel;
    }

    public ForgeDirection getSideConnected() {
        return this.sideConnected;
    }

    public String func_145825_b() {
        return Blockss.keroseneLamp.func_149739_a();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 1 ? false : stack != null && (FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack) != null || stack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack) != null);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.isGuiUseableByPlayer(p_70300_1_);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }
}

