/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.block.BlockPneumaticDoor;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.network.LazySynced;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IRedstoneControl;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.tileentity.TileEntityPneumaticDoor;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityPneumaticDoorBase
extends TileEntityPneumaticBase
implements IInventory,
IRedstoneControl,
IMinWorkingPressure {
    private TileEntityPneumaticDoor door;
    private TileEntityPneumaticDoorBase doubleDoor;
    @DescSynced
    public boolean rightGoing;
    public float oldProgress;
    @DescSynced
    @LazySynced
    public float progress;
    @DescSynced
    private boolean opening;
    public boolean wasPowered;
    @DescSynced
    private ItemStack[] inventory = new ItemStack[5];
    @GuiSynced
    public int redstoneMode;
    @DescSynced
    public ForgeDirection orientation = ForgeDirection.UNKNOWN;
    public static final int UPGRADE_SLOT_1 = 0;
    public static final int UPGRADE_SLOT_4 = 3;
    public static final int CAMO_SLOT = 4;
    private ItemStack oldCamo;

    public TileEntityPneumaticDoorBase() {
        super(5.0f, 7.0f, 2000);
        this.setUpgradeSlots(0, 1, 2, 3);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.oldProgress = this.progress;
        if (!this.field_145850_b.field_72995_K) {
            if (this.getPressure(ForgeDirection.UNKNOWN) >= 2.0f) {
                if (this.field_145850_b.func_82737_E() % 60L == 0L) {
                    TileEntity te = this.field_145850_b.func_147438_o(this.orientation.offsetX * 3 + this.field_145851_c, this.field_145848_d, this.orientation.offsetZ * 3 + this.field_145849_e);
                    this.doubleDoor = te instanceof TileEntityPneumaticDoorBase ? (TileEntityPneumaticDoorBase)te : null;
                }
                this.setOpening(this.shouldOpen() || this.isNeighborOpening());
                this.setNeighborOpening(this.isOpening());
            } else {
                this.setOpening(true);
            }
        }
        float targetProgress = this.opening ? 1.0f : 0.0f;
        float speedMultiplier = this.getSpeedMultiplierFromUpgrades(this.getUpgradeSlots());
        if (this.progress < targetProgress) {
            this.progress = this.progress < targetProgress - 0.2f ? (this.progress += 0.04f * speedMultiplier) : (this.progress += 0.01f * speedMultiplier);
            if (this.progress > targetProgress) {
                this.progress = targetProgress;
            }
        }
        if (this.progress > targetProgress) {
            this.progress = this.progress > targetProgress + 0.2f ? (this.progress -= 0.04f * speedMultiplier) : (this.progress -= 0.01f * speedMultiplier);
            if (this.progress < targetProgress) {
                this.progress = targetProgress;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.addAir((int)(-Math.abs(this.oldProgress - this.progress) * 300.0f * (this.getSpeedUsageMultiplierFromUpgrades(this.getUpgradeSlots()) / speedMultiplier)), ForgeDirection.UNKNOWN);
        }
        this.door = this.getDoor();
        if (this.door != null) {
            this.door.setRotation(this.progress * 90.0f);
            if (!this.field_145850_b.field_72995_K) {
                this.rightGoing = this.door.rightGoing;
            }
        }
        if (this.oldCamo != this.inventory[4]) {
            this.oldCamo = this.inventory[4];
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.inventory[4] != null ? this.inventory[4].func_77960_j() % 16 : 0, 2);
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private boolean shouldOpen() {
        switch (this.redstoneMode) {
            case 0: 
            case 1: {
                int range = 2 + this.getUpgrades(8);
                AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + range + 1), (double)(this.field_145848_d + range + 1), (double)(this.field_145849_e + range + 1));
                List players = this.field_145850_b.func_72872_a(EntityPlayer.class, aabb);
                for (EntityPlayer player : players) {
                    if (PneumaticCraftUtils.getProtectingSecurityStations(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, player, false, false) != 0) continue;
                    if (this.redstoneMode == 0) {
                        return true;
                    }
                    ((BlockPneumaticDoor)Blockss.pneumaticDoor).isTrackingPlayerEye = true;
                    ChunkPosition lookedPosition = PneumaticCraftUtils.getEntityLookedBlock((EntityLivingBase)player, (float)range * 1.41f);
                    ((BlockPneumaticDoor)Blockss.pneumaticDoor).isTrackingPlayerEye = false;
                    if (lookedPosition == null) continue;
                    if (lookedPosition.equals((Object)new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
                        return true;
                    }
                    if (this.door == null) continue;
                    if (lookedPosition.equals((Object)new ChunkPosition(this.door.field_145851_c, this.door.field_145848_d, this.door.field_145849_e))) {
                        return true;
                    }
                    if (!lookedPosition.equals((Object)new ChunkPosition(this.door.field_145851_c, this.door.field_145848_d + (this.door.func_145832_p() < 6 ? 1 : -1), this.door.field_145849_e))) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                return this.opening;
            }
        }
        return false;
    }

    public void setOpening(boolean opening) {
        this.opening = opening;
    }

    public boolean isOpening() {
        return this.opening;
    }

    private boolean isNeighborOpening() {
        return this.doubleDoor != null ? this.doubleDoor.shouldOpen() : false;
    }

    public void setNeighborOpening(boolean opening) {
        if (this.doubleDoor != null && this.doubleDoor.getPressure(ForgeDirection.UNKNOWN) >= 2.0f) {
            this.doubleDoor.setOpening(opening);
        }
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    private TileEntityPneumaticDoor getDoor() {
        TileEntity te = this.field_145850_b.func_147438_o(this.orientation.offsetX + this.field_145851_c, this.field_145848_d - 1, this.orientation.offsetZ + this.field_145849_e);
        if (te instanceof TileEntityPneumaticDoor) {
            if (this.orientation.getRotation(ForgeDirection.UP) == ForgeDirection.getOrientation((int)te.func_145832_p()) && !((TileEntityPneumaticDoor)te).rightGoing) {
                return (TileEntityPneumaticDoor)te;
            }
            if (this.orientation.getRotation(ForgeDirection.DOWN) == ForgeDirection.getOrientation((int)te.func_145832_p()) && ((TileEntityPneumaticDoor)te).rightGoing) {
                return (TileEntityPneumaticDoor)te;
            }
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.progress = tag.func_74760_g("extension");
        this.opening = tag.func_74767_n("opening");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.orientation = ForgeDirection.getOrientation((int)tag.func_74762_e("orientation"));
        this.rightGoing = tag.func_74767_n("rightGoing");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74776_a("extension", this.progress);
        tag.func_74757_a("opening", this.opening);
        tag.func_74768_a("orientation", this.orientation.ordinal());
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74757_a("rightGoing", this.rightGoing);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return Blockss.pneumaticDoorBase.func_149739_a();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 4 || itemstack.func_77973_b() == Itemss.machineUpgrade;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    @Override
    public float getMinWorkingPressure() {
        return 2.0f;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }
}

