/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.api.tileentity.ISidedPneumaticMachine;
import pneumaticCraft.common.block.tubes.IInfluenceDispersing;
import pneumaticCraft.common.block.tubes.ModuleAirGrate;
import pneumaticCraft.common.block.tubes.ModuleFlowDetector;
import pneumaticCraft.common.block.tubes.ModulePressureGauge;
import pneumaticCraft.common.block.tubes.ModuleRegistrator;
import pneumaticCraft.common.block.tubes.ModuleRegulatorTube;
import pneumaticCraft.common.block.tubes.ModuleSafetyValve;
import pneumaticCraft.common.block.tubes.TubeModule;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.thirdparty.fmp.PartPressureTube;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;

public class TileEntityPressureTube
extends TileEntityPneumaticBase {
    @DescSynced
    public boolean[] sidesConnected = new boolean[6];
    public TubeModule[] modules = new TubeModule[6];
    private Object part;

    public TileEntityPressureTube() {
        super(5.0f, 7.0f, 1000);
    }

    public TileEntityPressureTube(float dangerPressurePressureTube, float maxPressurePressureTube, int volumePressureTube) {
        super(dangerPressurePressureTube, maxPressurePressureTube, volumePressureTube);
    }

    public TileEntityPressureTube setPart(Object part) {
        this.part = part;
        for (TubeModule module : this.modules) {
            if (module == null) continue;
            module.shouldDrop = false;
        }
        return this;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 6; ++i) {
            this.sidesConnected[i] = nbt.func_74767_n("sideConnected" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < 6; ++i) {
            nbt.func_74757_a("sideConnected" + i, this.sidesConnected[i]);
        }
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        this.writeModulesToNBT(tag);
    }

    public void writeModulesToNBT(NBTTagCompound tag) {
        NBTTagList moduleList = new NBTTagList();
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null) continue;
            NBTTagCompound moduleTag = new NBTTagCompound();
            moduleTag.func_74778_a("type", this.modules[i].getType());
            this.modules[i].writeToNBT(moduleTag);
            moduleTag.func_74768_a("side", i);
            moduleList.func_74742_a((NBTBase)moduleTag);
        }
        tag.func_74782_a("modules", (NBTBase)moduleList);
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        this.modules = new TubeModule[6];
        NBTTagList moduleList = tag.func_150295_c("modules", 10);
        for (int i = 0; i < moduleList.func_74745_c(); ++i) {
            NBTTagCompound moduleTag = moduleList.func_150305_b(i);
            TubeModule module = ModuleRegistrator.getModule(moduleTag.func_74779_i("type"));
            module.readFromNBT(moduleTag);
            this.setModule(module, ForgeDirection.getOrientation((int)moduleTag.func_74762_e("side")));
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.rerenderChunk();
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        for (TubeModule tubeModule : this.modules) {
            if (tubeModule == null) continue;
            tubeModule.shouldDrop = true;
            tubeModule.update();
        }
        List<Pair<ForgeDirection, IAirHandler>> teList = this.getConnectedPneumatics();
        boolean hasModules = false;
        for (TubeModule module : this.modules) {
            if (module == null) continue;
            hasModules = true;
            break;
        }
        if (!hasModules && teList.size() - this.specialConnectedHandlers.size() == 1 && !this.field_145850_b.field_72995_K) {
            for (Pair pair : teList) {
                if (pair.getKey() == ForgeDirection.UNKNOWN || this.modules[((ForgeDirection)pair.getKey()).getOpposite().ordinal()] != null || !this.isConnectedTo(((ForgeDirection)pair.getKey()).getOpposite())) continue;
                this.airLeak(((ForgeDirection)pair.getKey()).getOpposite());
            }
        }
    }

    @Override
    protected void onAirDispersion(int amount, ForgeDirection side) {
        int intSide;
        if (side != ForgeDirection.UNKNOWN && this.modules[intSide = side.ordinal()] instanceof IInfluenceDispersing) {
            ((IInfluenceDispersing)((Object)this.modules[intSide])).onAirDispersion(amount);
        }
    }

    @Override
    protected int getMaxDispersion(ForgeDirection side) {
        int intSide;
        if (side != ForgeDirection.UNKNOWN && this.modules[intSide = side.ordinal()] instanceof IInfluenceDispersing) {
            return ((IInfluenceDispersing)((Object)this.modules[intSide])).getMaxDispersion();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    protected void onFirstServerUpdate() {
        this.legacyHelper();
    }

    private void legacyHelper() {
        if (this.func_145832_p() > 0) {
            switch (this.func_145832_p()) {
                case 1: {
                    this.legacyAddModule(new ModuleFlowDetector());
                    break;
                }
                case 2: {
                    this.legacyAddModule(new ModuleSafetyValve());
                    break;
                }
                case 3: {
                    this.legacyAddModule(new ModuleRegulatorTube());
                    break;
                }
                case 4: {
                    this.legacyAddModule(new ModuleAirGrate());
                    break;
                }
                case 5: {
                    this.legacyAddModule(new ModulePressureGauge());
                }
            }
            NBTTagCompound tag = new NBTTagCompound();
            this.func_145841_b(tag);
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            ((TileEntityPressureTube)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e)).func_145839_a(tag);
        }
    }

    private void legacyAddModule(TubeModule module) {
        for (int i = 0; i < 6; ++i) {
            if (this.sidesConnected[i] != module.isInline()) continue;
            Log.info("Converting legacy Pressure Tube to tube with module: " + module.getType() + " at " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e);
            this.setModule(module, ForgeDirection.getOrientation((int)i));
            return;
        }
        Log.warning("Converting legacy Pressure Tube. TUBES ARE ALL CONNECTED, force connecting! Module: " + module.getType() + " at " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e);
        this.setModule(module, ForgeDirection.getOrientation((int)0));
    }

    public void setModule(TubeModule module, ForgeDirection side) {
        if (module != null) {
            module.setDirection(side);
            module.setTube(this);
        }
        this.modules[side.ordinal()] = module;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.part != null) {
                this.updatePart();
            }
            this.sendDescriptionPacket();
        }
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        return !(this.modules[side.ordinal()] != null && !this.modules[side.ordinal()].isInline() || this.part != null && !ModInteractionUtils.getInstance().isMultipartWiseConnected(this.part, side));
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.updateConnections(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (TubeModule module : this.modules) {
            if (module == null) continue;
            module.onNeighborTileUpdate();
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.updateConnections(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (TubeModule module : this.modules) {
            if (module == null) continue;
            module.onNeighborBlockUpdate();
        }
    }

    public void updateConnections(World world, int x, int y, int z) {
        this.sidesConnected = new boolean[6];
        boolean hasModule = false;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.getTileCache()[direction.ordinal()].getTileEntity();
            IPneumaticMachine machine = ModInteractionUtils.getInstance().getMachine(te);
            if (machine != null) {
                this.sidesConnected[direction.ordinal()] = this.isConnectedTo(direction) && machine.isConnectedTo(direction.getOpposite());
            } else if (te instanceof ISidedPneumaticMachine) {
                boolean bl = this.sidesConnected[direction.ordinal()] = ((ISidedPneumaticMachine)te).getAirHandler(direction.getOpposite()) != null;
            }
            if (this.modules[direction.ordinal()] == null) continue;
            hasModule = true;
        }
        int sidesCount = 0;
        for (boolean bool : this.sidesConnected) {
            if (!bool) continue;
            ++sidesCount;
        }
        if (sidesCount == 1 && !hasModule) {
            for (int i = 0; i < 6; ++i) {
                if (!this.sidesConnected[i]) continue;
                if (!this.isConnectedTo(ForgeDirection.getOrientation((int)i).getOpposite())) break;
                this.sidesConnected[i ^ 1] = true;
                break;
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (this.modules[i] == null || !this.modules[i].isInline()) continue;
            this.sidesConnected[i] = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public void printManometerMessage(EntityPlayer player, List<String> text) {
        ForgeDirection dir;
        super.printManometerMessage(player, text);
        MovingObjectPosition mop = PneumaticCraftUtils.getEntityLookedObject((EntityLivingBase)player);
        if (mop != null && mop.hitInfo instanceof ForgeDirection && (dir = (ForgeDirection)mop.hitInfo) != ForgeDirection.UNKNOWN && this.modules[dir.ordinal()] != null) {
            this.modules[dir.ordinal()].addInfo(text);
        }
    }

    @Override
    @Optional.Method(modid="ForgeMultipart")
    public void sendDescriptionPacket() {
        if (this.part != null && !this.field_145850_b.field_72995_K) {
            ((PartPressureTube)this.part).sendDescUpdate();
        }
        super.sendDescriptionPacket();
    }

    @Optional.Method(modid="ForgeMultipart")
    public void updatePart() {
        ((PartPressureTube)this.part).onNeighborChanged();
    }
}

