/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.fluid.Fluids;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.network.LazySynced;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketSpawnParticle;
import pneumaticCraft.common.tileentity.IComparatorSupport;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityBase;

public class TileEntityRefinery
extends TileEntityBase
implements IFluidHandler,
IHeatExchanger,
IRedstoneControlled,
IComparatorSupport {
    @GuiSynced
    @DescSynced
    @LazySynced
    private final FluidTank oilTank = new FluidTank(16000);
    @GuiSynced
    @DescSynced
    @LazySynced
    private final FluidTank outputTank = new FluidTank(16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();
    @DescSynced
    private int oilTankAmount;
    @DescSynced
    private int outputTankAmount;
    @GuiSynced
    private int redstoneMode;
    private int workTimer = 0;
    private int comparatorValue;
    public static final int[][] REFINING_TABLE = new int[][]{{4, 0, 0, 2}, {2, 3, 0, 2}, {2, 3, 3, 2}};
    private final Fluid[] refiningFluids = TileEntityRefinery.getRefiningFluids();

    public static Fluid[] getRefiningFluids() {
        return new Fluid[]{Fluids.diesel, Fluids.kerosene, Fluids.gasoline, Fluids.lpg};
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.oilTankAmount = this.oilTank.getFluidAmount() / 100;
            this.outputTankAmount = this.outputTank.getFluidAmount() / 100;
            if (this.isMaster()) {
                List<TileEntityRefinery> refineries = this.getRefineries();
                if (this.redstoneAllows() && this.oilTank.getFluidAmount() >= 10) {
                    if (refineries.size() > 1 && refineries.size() <= this.refiningFluids.length && this.refine(refineries, true)) {
                        int progress = Math.max(0, ((int)this.heatExchanger.getTemperature() - 343) / 30);
                        progress = Math.min(5, progress);
                        this.heatExchanger.addHeat(-progress * 1);
                        this.workTimer += progress;
                        while (this.workTimer >= 20 && this.oilTank.getFluidAmount() >= 10) {
                            this.workTimer -= 20;
                            this.refine(refineries, false);
                            this.oilTank.drain(10, true);
                            for (int i = 0; i < 5; ++i) {
                                NetworkHandler.sendToAllAround(new PacketSpawnParticle("largesmoke", (double)this.field_145851_c + this.field_145850_b.field_73012_v.nextDouble(), this.field_145848_d + refineries.size(), (double)this.field_145849_e + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0), this.field_145850_b);
                            }
                        }
                    } else {
                        this.workTimer = 0;
                    }
                }
                this.updateComparatorValue(refineries);
            }
        }
    }

    private List<TileEntityRefinery> getRefineries() {
        ArrayList<TileEntityRefinery> refineries = new ArrayList<TileEntityRefinery>();
        refineries.add(this);
        TileEntityRefinery refinery = this;
        while (refinery.getTileCache()[ForgeDirection.UP.ordinal()].getTileEntity() instanceof TileEntityRefinery) {
            refinery = (TileEntityRefinery)refinery.getTileCache()[ForgeDirection.UP.ordinal()].getTileEntity();
            refineries.add(refinery);
        }
        return refineries;
    }

    public boolean refine(List<TileEntityRefinery> refineries, boolean simulate) {
        int[] outputTable = REFINING_TABLE[refineries.size() - 2];
        int i = 0;
        for (TileEntityRefinery refinery : refineries) {
            while (outputTable[i] == 0) {
                ++i;
            }
            if (outputTable[i] != refinery.outputTank.fill(new FluidStack(this.refiningFluids[i], outputTable[i]), !simulate)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TileEntityRefinery getMasterRefinery() {
        TileEntityRefinery master = this;
        while (master.getTileCache()[ForgeDirection.DOWN.ordinal()].getTileEntity() instanceof TileEntityRefinery) {
            master = (TileEntityRefinery)master.getTileCache()[ForgeDirection.DOWN.ordinal()].getTileEntity();
        }
        return master;
    }

    private boolean isMaster() {
        return this.getMasterRefinery() == this;
    }

    @Override
    public boolean redstoneAllows() {
        if (this.field_145850_b.field_72995_K) {
            this.onNeighborBlockUpdate();
        }
        boolean isPoweredByRedstone = this.poweredRedstone > 0;
        TileEntityRefinery refinery = this;
        while (this.poweredRedstone == 0 && refinery.getTileCache()[ForgeDirection.UP.ordinal()].getTileEntity() instanceof TileEntityRefinery) {
            refinery = (TileEntityRefinery)refinery.getTileCache()[ForgeDirection.UP.ordinal()].getTileEntity();
            refinery.onNeighborBlockUpdate();
            isPoweredByRedstone = refinery.poweredRedstone > 0;
        }
        switch (this.getRedstoneMode()) {
            case 0: {
                return true;
            }
            case 1: {
                return isPoweredByRedstone;
            }
            case 2: {
                return !isPoweredByRedstone;
            }
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource != null ? resource.getFluid() : null)) {
            if (this.isMaster()) {
                return this.oilTank.fill(resource, doFill);
            }
            return this.getMasterRefinery().fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.outputTank.getFluid() != null && this.outputTank.getFluid().isFluidEqual(resource) ? this.outputTank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.outputTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return Fluids.areFluidsEqual(fluid, Fluids.oil);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.getMasterRefinery().oilTank), new FluidTankInfo((IFluidTank)this.outputTank)};
    }

    @SideOnly(value=Side.CLIENT)
    public FluidTank getOilTank() {
        return this.oilTank;
    }

    @SideOnly(value=Side.CLIENT)
    public FluidTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.oilTank.writeToNBT(tankTag);
        tag.func_74782_a("oilTank", (NBTBase)tankTag);
        tankTag = new NBTTagCompound();
        this.outputTank.writeToNBT(tankTag);
        tag.func_74782_a("outputTank", (NBTBase)tankTag);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.oilTank.readFromNBT(tag.func_74775_l("oilTank"));
        this.outputTank.readFromNBT(tag.func_74775_l("outputTank"));
        this.redstoneMode = tag.func_74771_c("redstoneMode");
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(ForgeDirection side) {
        return this.heatExchanger;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    public void updateComparatorValue(List<TileEntityRefinery> refineries) {
        int value;
        if (this.oilTank.getFluidAmount() < 10 || refineries.size() < 2 || refineries.size() > this.refiningFluids.length) {
            value = 0;
        } else {
            int n = value = this.refine(refineries, true) ? 15 : 0;
        }
        if (value != this.comparatorValue) {
            this.comparatorValue = value;
            this.updateNeighbours();
        }
    }

    @Override
    public int getComparatorValue(ForgeDirection side) {
        return this.getMasterRefinery().comparatorValue;
    }
}

