/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.client.render.RenderRangeLines;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketRenderRangeLines;
import pneumaticCraft.common.tileentity.IGUITextFieldSensitive;
import pneumaticCraft.common.tileentity.IRangeLineShower;
import pneumaticCraft.common.tileentity.IRedstoneControl;
import pneumaticCraft.common.tileentity.TileEntityBase;
import pneumaticCraft.lib.Log;
import pneumaticCraft.proxy.CommonProxy;

public class TileEntitySecurityStation
extends TileEntityBase
implements ISidedInventory,
IGUITextFieldSensitive,
IRangeLineShower,
IRedstoneControl {
    private ItemStack[] inventory;
    private final int INVENTORY_SIZE = 39;
    public static final int UPGRADE_SLOT_START = 35;
    public static final int UPGRADE_SLOT_END = 38;
    public final List<GameProfile> hackedUsers = new ArrayList<GameProfile>();
    public final List<GameProfile> sharedUsers = new ArrayList<GameProfile>();
    @GuiSynced
    private int rebootTimer;
    @GuiSynced
    public String textFieldText = "";
    private int securityRange;
    private int oldSecurityRange;
    private final RenderRangeLines rangeLineRenderer = new RenderRangeLines(0x33FF0000);
    @GuiSynced
    public int redstoneMode;
    public boolean oldRedstoneStatus;
    private boolean validNetwork;

    public TileEntitySecurityStation() {
        this.inventory = new ItemStack[39];
        this.setUpgradeSlots(35, 36, 37, 38);
    }

    @Override
    public void func_145845_h() {
        if (this.rebootTimer > 0) {
            --this.rebootTimer;
            if (!this.field_145850_b.field_72995_K && this.rebootTimer == 0) {
                this.hackedUsers.clear();
            }
        }
        if (this.field_145850_b.field_72995_K && !this.firstRun) {
            if (this.oldSecurityRange != this.getSecurityRange() || this.oldSecurityRange == 0) {
                this.rangeLineRenderer.resetRendering(this.getSecurityRange());
                this.oldSecurityRange = this.getSecurityRange();
            }
            this.rangeLineRenderer.update();
        }
        if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
            this.oldRedstoneStatus = this.shouldEmitRedstone();
            this.updateNeighbours();
        }
        this.securityRange = Math.min(2 + this.getUpgrades(8, this.getUpgradeSlots()), 16);
        super.func_145845_h();
    }

    public void rebootStation() {
        this.rebootTimer = 1200;
    }

    public int getRebootTime() {
        return this.rebootTimer;
    }

    @Override
    public void showRangeLines() {
        if (this.field_145850_b.field_72995_K) {
            this.rangeLineRenderer.resetRendering(this.getSecurityRange());
        } else {
            NetworkHandler.sendToAllAround(new PacketRenderRangeLines(this), this.field_145850_b, 64.0 + (double)this.getSecurityRange());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRangeLines() {
        this.rangeLineRenderer.render();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
            this.updateNeighbours();
        } else if (buttonID == 2) {
            this.rebootStation();
        } else if (buttonID == 3) {
            if (!this.hasValidNetwork()) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation(EnumChatFormatting.GREEN + "This Security Station is out of order: Its network hasn't been properly configured.", new Object[0]));
            } else {
                player.openGui((Object)PneumaticCraft.instance, CommonProxy.EnumGuiId.HACKING.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else if (buttonID > 3 && buttonID - 4 < this.sharedUsers.size()) {
            this.sharedUsers.remove(buttonID - 4);
        }
        this.sendDescriptionPacket();
    }

    public void addSharedUser(GameProfile user) {
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.sharedUsers.add(user);
        this.sendDescriptionPacket();
    }

    public void addHacker(GameProfile user) {
        for (GameProfile hackedUser : this.hackedUsers) {
            if (!this.gameProfileEquals(hackedUser, user)) continue;
            return;
        }
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.hackedUsers.add(user);
        this.sendDescriptionPacket();
    }

    private boolean gameProfileEquals(GameProfile profile1, GameProfile profile2) {
        return profile1.getId() != null && profile2.getId() != null ? profile1.getId().equals(profile2.getId()) : profile1.getName().equals(profile2.getName());
    }

    public boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isHacked();
            }
            case 2: {
                return this.getRebootTime() <= 0;
            }
        }
        return false;
    }

    public boolean isHacked() {
        return this.hackedUsers.size() > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.rangeLineRenderer.isCurrentlyRendering()) {
            return super.getRenderBoundingBox();
        }
        int range = this.getSecurityRange();
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + 1 + range), (double)(this.field_145848_d + 1 + range), (double)(this.field_145849_e + 1 + range));
    }

    public int getSecurityRange() {
        return this.securityRange;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.checkForNetworkValidity();
    }

    public String func_145825_b() {
        return Blockss.securityStation.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.rebootTimer = tag.func_74762_e("startupTimer");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.checkForNetworkValidity();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("startupTimer", this.rebootTimer);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        NBTTagList sharedList = new NBTTagList();
        for (int i = 0; i < this.sharedUsers.size(); ++i) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74778_a("name", this.sharedUsers.get(i).getName());
            if (this.sharedUsers.get(i).getId() != null) {
                tagCompound.func_74778_a("uuid", this.sharedUsers.get(i).getId().toString());
            }
            sharedList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("SharedUsers", (NBTBase)sharedList);
        NBTTagList hackedList = new NBTTagList();
        for (int i = 0; i < this.hackedUsers.size(); ++i) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74778_a("name", this.hackedUsers.get(i).getName());
            if (this.hackedUsers.get(i).getId() != null) {
                tagCompound.func_74778_a("uuid", this.hackedUsers.get(i).getId().toString());
            }
            hackedList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("HackedUsers", (NBTBase)hackedList);
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        this.sharedUsers.clear();
        NBTTagList sharedList = tag.func_150295_c("SharedUsers", 10);
        for (int i = 0; i < sharedList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = sharedList.func_150305_b(i);
            this.sharedUsers.add(new GameProfile(tagCompound.func_74764_b("uuid") ? UUID.fromString(tagCompound.func_74779_i("uuid")) : null, tagCompound.func_74779_i("name")));
        }
        this.hackedUsers.clear();
        NBTTagList hackedList = tag.func_150295_c("HackedUsers", 10);
        for (int i = 0; i < hackedList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = hackedList.func_150305_b(i);
            this.hackedUsers.add(new GameProfile(tagCompound.func_74764_b("uuid") ? UUID.fromString(tagCompound.func_74779_i("uuid")) : null, tagCompound.func_74779_i("name")));
        }
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public int[] func_94128_d(int var1) {
        return new int[0];
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.textFieldText = text;
    }

    @Override
    public String getText(int textFieldID) {
        return this.textFieldText;
    }

    public boolean doesAllowPlayer(EntityPlayer player) {
        return this.rebootTimer > 0 || this.isPlayerOnWhiteList(player) || this.hasPlayerHacked(player);
    }

    public boolean isPlayerOnWhiteList(EntityPlayer player) {
        for (int i = 0; i < this.sharedUsers.size(); ++i) {
            GameProfile user = this.sharedUsers.get(i);
            if (!this.gameProfileEquals(user, player.func_146103_bH())) continue;
            if (user.getId() == null && player.func_146103_bH().getId() != null) {
                this.sharedUsers.set(i, player.func_146103_bH());
                Log.info("Legacy conversion: Security Station shared username '" + player.func_70005_c_() + "' is now using UUID '" + player.func_146103_bH().getId() + "'.");
            }
            return true;
        }
        return false;
    }

    public boolean hasPlayerHacked(EntityPlayer player) {
        for (int i = 0; i < this.hackedUsers.size(); ++i) {
            GameProfile user = this.hackedUsers.get(i);
            if (!this.gameProfileEquals(user, player.func_146103_bH())) continue;
            if (user.getId() == null && player.func_146103_bH().getId() != null) {
                this.hackedUsers.set(i, player.func_146103_bH());
                Log.info("Legacy conversion: Security Station hacked username '" + player.func_70005_c_() + "' is now using UUID '" + player.func_146103_bH().getId() + "'.");
            }
            return true;
        }
        return false;
    }

    public boolean connects(int firstSlot, int secondSlot) {
        if (firstSlot < 0 || secondSlot < 0 || firstSlot >= 35 || secondSlot >= 35 || firstSlot == secondSlot || this.func_70301_a(firstSlot) == null || this.func_70301_a(secondSlot) == null) {
            return false;
        }
        for (int column = -1; column <= 1; ++column) {
            for (int row = -1; row <= 1; ++row) {
                if (firstSlot + row * 5 + column != secondSlot || !(firstSlot % 5 > 0 && firstSlot % 5 < 4 || secondSlot % 5 > 0 && secondSlot % 5 < 4) && secondSlot % 5 != firstSlot % 5) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasValidNetwork() {
        return this.validNetwork;
    }

    public EnumNetworkValidityProblem checkForNetworkValidity() {
        this.validNetwork = false;
        int ioPortSlot = -1;
        int registrySlot = -1;
        int subroutineSlot = -1;
        block5: for (int i = 0; i < 35; ++i) {
            if (this.func_70301_a(i) == null) continue;
            switch (this.func_70301_a(i).func_77960_j()) {
                case 0: {
                    if (subroutineSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_SUBROUTINES;
                    }
                    subroutineSlot = i;
                    continue block5;
                }
                case 3: {
                    if (ioPortSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_IO_PORTS;
                    }
                    ioPortSlot = i;
                    continue block5;
                }
                case 4: {
                    if (registrySlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_REGISTRIES;
                    }
                    registrySlot = i;
                }
            }
        }
        if (subroutineSlot == -1) {
            return EnumNetworkValidityProblem.NO_SUBROUTINE;
        }
        if (ioPortSlot == -1) {
            return EnumNetworkValidityProblem.NO_IO_PORT;
        }
        if (registrySlot == -1) {
            return EnumNetworkValidityProblem.NO_REGISTRY;
        }
        if (!this.traceComponent(subroutineSlot, ioPortSlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_SUB_AND_IO_PORT;
        }
        if (!this.traceComponent(ioPortSlot, registrySlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_IO_PORT_AND_REGISTRY;
        }
        this.validNetwork = true;
        return EnumNetworkValidityProblem.NONE;
    }

    private boolean traceComponent(int startSlot, int targetSlot, boolean[] slotsDone) {
        for (int i = 0; i < 35; ++i) {
            if (slotsDone[i] || !this.connects(startSlot, i)) continue;
            if (i == targetSlot) {
                return true;
            }
            slotsDone[i] = true;
            if (!this.traceComponent(i, targetSlot, slotsDone)) continue;
            return true;
        }
        return false;
    }

    public int getDetectionChance() {
        return Math.min(100, 20 + 20 * this.getUpgrades(3, this.getUpgradeSlots()));
    }

    public int getSecurityLevel() {
        return 1 + this.getUpgrades(9, this.getUpgradeSlots());
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    @Override
    public boolean isGuiUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public static enum EnumNetworkValidityProblem {
        NONE,
        NO_SUBROUTINE,
        NO_IO_PORT,
        NO_REGISTRY,
        TOO_MANY_SUBROUTINES,
        TOO_MANY_IO_PORTS,
        TOO_MANY_REGISTRIES,
        NO_CONNECTION_SUB_AND_IO_PORT,
        NO_CONNECTION_IO_PORT_AND_REGISTRY;

    }
}

