/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.api.tileentity.ISidedPneumaticMachine;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityVacuumPump
extends TileEntityPneumaticBase
implements IInventory,
IRedstoneControlled {
    @GuiSynced
    private final TileEntityPneumaticBase vacuumHandler = new TileEntityPneumaticBase(5.0f, 7.0f, 2000){

        @Override
        public List<Pair<ForgeDirection, IAirHandler>> getConnectedPneumatics() {
            IAirHandler handler;
            ArrayList<Pair<ForgeDirection, IAirHandler>> teList = new ArrayList<Pair<ForgeDirection, IAirHandler>>();
            ForgeDirection direction = TileEntityVacuumPump.this.getVacuumSide();
            TileEntity te = this.getTileCache()[direction.ordinal()].getTileEntity();
            IPneumaticMachine machine = ModInteractionUtils.getInstance().getMachine(te);
            if (machine != null && this.isConnectedTo(direction) && machine.isConnectedTo(direction.getOpposite())) {
                teList.add((Pair<ForgeDirection, IAirHandler>)new ImmutablePair((Object)direction, (Object)machine.getAirHandler()));
            } else if (te instanceof ISidedPneumaticMachine && (handler = ((ISidedPneumaticMachine)te).getAirHandler(direction)) != null) {
                teList.add((Pair<ForgeDirection, IAirHandler>)new ImmutablePair((Object)direction, (Object)handler));
            }
            return teList;
        }

        @Override
        protected boolean saveTeInternals() {
            return false;
        }
    };
    public int rotation;
    public int oldRotation;
    public int turnTimer = -1;
    @DescSynced
    public boolean turning = false;
    public int rotationSpeed;
    @GuiSynced
    public int redstoneMode;
    private ItemStack[] inventory = new ItemStack[4];
    public static final int UPGRADE_SLOT_1 = 0;
    public static final int UPGRADE_SLOT_4 = 3;
    public static final int INVENTORY_SIZE = 4;

    public TileEntityVacuumPump() {
        super(5.0f, 7.0f, 2000);
        this.setUpgradeSlots(0, 1, 2, 3);
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        switch (ForgeDirection.getOrientation((int)meta)) {
            case NORTH: 
            case SOUTH: {
                return side == ForgeDirection.NORTH || side == ForgeDirection.SOUTH;
            }
            case EAST: 
            case WEST: {
                return side == ForgeDirection.EAST || side == ForgeDirection.WEST;
            }
        }
        return false;
    }

    @Override
    public List<Pair<ForgeDirection, IAirHandler>> getConnectedPneumatics() {
        IAirHandler handler;
        ArrayList<Pair<ForgeDirection, IAirHandler>> teList = new ArrayList<Pair<ForgeDirection, IAirHandler>>();
        ForgeDirection direction = this.getInputSide();
        TileEntity te = this.getTileCache()[direction.ordinal()].getTileEntity();
        IPneumaticMachine machine = ModInteractionUtils.getInstance().getMachine(te);
        if (machine != null && this.isConnectedTo(direction) && machine.isConnectedTo(direction.getOpposite())) {
            teList.add((Pair<ForgeDirection, IAirHandler>)new ImmutablePair((Object)direction, (Object)machine.getAirHandler()));
        } else if (te instanceof ISidedPneumaticMachine && (handler = ((ISidedPneumaticMachine)te).getAirHandler(direction)) != null) {
            teList.add((Pair<ForgeDirection, IAirHandler>)new ImmutablePair((Object)direction, (Object)handler));
        }
        return teList;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.vacuumHandler.validateI(this);
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.vacuumHandler.onNeighborTileUpdate();
    }

    @Override
    public void setVolume(int newVolume) {
        this.vacuumHandler.setVolume(newVolume);
        super.setVolume(newVolume);
    }

    public ForgeDirection getInputSide() {
        return this.getVacuumSide().getOpposite();
    }

    public ForgeDirection getVacuumSide() {
        return ForgeDirection.getOrientation((int)this.func_145832_p());
    }

    @Override
    public float getPressure(ForgeDirection sideRequested) {
        if (sideRequested == this.getVacuumSide()) {
            return this.vacuumHandler.getPressure(sideRequested);
        }
        return super.getPressure(sideRequested);
    }

    @Override
    public int getCurrentAir(ForgeDirection sideRequested) {
        return sideRequested == this.getInputSide() ? this.currentAir : this.vacuumHandler.getCurrentAir(sideRequested);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.turnTimer >= 0) {
            --this.turnTimer;
        }
        if (!this.field_145850_b.field_72995_K && this.getPressure(this.getInputSide()) > 2.0f && this.getPressure(this.getVacuumSide()) > -1.0f && this.redstoneAllows()) {
            if (!this.field_145850_b.field_72995_K && this.turnTimer == -1) {
                this.turning = true;
            }
            this.addAir((int)(-2.0f * this.getSpeedMultiplierFromUpgrades(this.getUpgradeSlots())), this.getVacuumSide());
            this.addAir((int)(-10.0f * this.getSpeedUsageMultiplierFromUpgrades(this.getUpgradeSlots())), this.getInputSide());
            this.turnTimer = 40;
        }
        if (this.turnTimer == 0) {
            this.turning = false;
        }
        this.oldRotation = this.rotation;
        if (this.field_145850_b.field_72995_K) {
            this.rotationSpeed = this.turning ? Math.min(this.rotationSpeed + 1, 20) : Math.max(this.rotationSpeed - 1, 0);
            this.rotation += this.rotationSpeed;
        }
        super.func_145845_h();
        this.vacuumHandler.updateEntityI();
        List<Pair<ForgeDirection, IAirHandler>> teList = this.getConnectedPneumatics();
        if (teList.size() == 0) {
            this.airLeak(this.getInputSide());
        }
        if ((teList = this.vacuumHandler.getConnectedPneumatics()).size() == 0) {
            this.vacuumHandler.airLeak(this.getVacuumSide());
        }
    }

    @Override
    public void addAir(int amount, ForgeDirection side) {
        if (side == this.getInputSide()) {
            this.currentAir += amount;
        } else {
            this.vacuumHandler.addAir(amount, side);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound vacuum = new NBTTagCompound();
        this.vacuumHandler.writeToNBTI(vacuum);
        tag.func_74782_a("vacuum", (NBTBase)vacuum);
        tag.func_74757_a("turning", this.turning);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.vacuumHandler.readFromNBTI(tag.func_74775_l("vacuum"));
        this.turning = tag.func_74767_n("turning");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public boolean redstoneAllows() {
        switch (this.redstoneMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            case 2: {
                return !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return false;
    }

    @Override
    public void printManometerMessage(EntityPlayer player, List<String> curInfo) {
        curInfo.add(EnumChatFormatting.GREEN + "Input pressure: " + PneumaticCraftUtils.roundNumberTo(this.getPressure(this.getInputSide()), 1) + " bar. Vacuum pressure: " + PneumaticCraftUtils.roundNumberTo(this.getPressure(this.getVacuumSide()), 1) + " bar.");
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return Blockss.vacuumPump.func_149739_a();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() == Itemss.machineUpgrade;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }
}

