/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.fluids.FluidRegistry;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.block.pneumaticPlants.BlockPneumaticPlantBase;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.fluid.Fluids;
import pneumaticCraft.common.item.ItemPlasticPlants;

public class WorldGeneratorPneumaticCraft
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!(chunkGenerator instanceof ChunkProviderFlat)) {
            switch (world.field_73011_w.field_76574_g) {
                case 0: {
                    this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                    break;
                }
                case -1: {
                    this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                    break;
                }
                case 1: {
                    this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                    break;
                }
                default: {
                    this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                }
            }
        }
    }

    public void generateSurface(World world, Random rand, int chunkX, int chunkZ) {
        if (rand.nextDouble() < Config.oilGenerationChance / 100.0) {
            int y = rand.nextInt(rand.nextInt(128) + 8);
            new WorldGenLakes(FluidRegistry.getFluid((String)Fluids.oil.getName()).getBlock()).func_76484_a(world, rand, chunkX + 8, y, chunkZ + 8);
        }
        for (int j = 0; j < 16; ++j) {
            if (!(rand.nextDouble() < Config.configPlantGenerationChance[j]) || j == 11 || j == 1) continue;
            int plantsInGroup = 7 + rand.nextInt(8);
            for (int i = 0; i < plantsInGroup; ++i) {
                int z;
                int x = chunkX + rand.nextInt(20);
                int y = world.func_72976_f(x, z = chunkZ + rand.nextInt(20));
                if (y <= 0 || !((BlockPneumaticPlantBase)ItemPlasticPlants.getPlantBlockIDFromSeed(j)).canPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z), world, x, y - 1, z)) continue;
                world.func_147465_d(x, y, z, ItemPlasticPlants.getPlantBlockIDFromSeed(j), rand.nextInt(5), 2);
            }
        }
    }

    public void generateNether(World world, Random rand, int chunkX, int chunkZ) {
        int z;
        int x;
        int i;
        int plantsInGroup;
        if (rand.nextDouble() < Config.configPlantGenerationChance[11] && rand.nextInt(10) == 0) {
            plantsInGroup = 7 + rand.nextInt(8);
            for (i = 0; i < plantsInGroup; ++i) {
                x = chunkX + rand.nextInt(20);
                int y = this.getNetherRoof(world, x, z = chunkZ + rand.nextInt(20));
                if (y <= 0) continue;
                world.func_147465_d(x, y, z, Blockss.heliumPlant, rand.nextInt(5), 2);
            }
        }
        if (rand.nextDouble() < Config.configPlantGenerationChance[1] && rand.nextInt(10) == 0) {
            plantsInGroup = 7 + rand.nextInt(8);
            block1: for (i = 0; i < plantsInGroup; ++i) {
                x = chunkX + rand.nextInt(20);
                z = chunkZ + rand.nextInt(20);
                int baseY = 0;
                for (int j = 0; j < 64; ++j) {
                    int y = baseY == 0 ? rand.nextInt(127) : baseY - 4 + rand.nextInt(8);
                    if (!world.func_147437_c(x, y, z) || !((BlockPneumaticPlantBase)Blockss.fireFlower).canPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z), world, x, y - 1, z)) continue;
                    world.func_147465_d(x, y, z, Blockss.fireFlower, rand.nextInt(5), 2);
                    if (baseY != 0) continue block1;
                    baseY = y;
                    continue block1;
                }
            }
        }
    }

    public void generateEnd(World world, Random rand, int chunkX, int chunkZ) {
    }

    private int getNetherRoof(World world, int x, int z) {
        int y = 127;
        boolean lastYWasNetherrack = false;
        while (y > 0) {
            if (world.func_147437_c(x, --y, z) && lastYWasNetherrack) {
                return y;
            }
            lastYWasNetherrack = world.func_147439_a(x, y, z) == Blocks.field_150424_aL;
        }
        return 0;
    }
}

