/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.magicalcrops;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCropPlant;
import powercrystals.minefactoryreloaded.modhelpers.magicalcrops.Harvestable;

@Mod(modid="MineFactoryReloaded|CompatMagicalCrops", name="MFR Compat: MagicalCrops", version="1.2.1", dependencies="required-after:MineFactoryReloaded;required-after:magicalcrops")
public class MagicalCrops {
    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (!Loader.isModLoaded((String)"magicalcrops")) {
            FMLLog.info((String)"Magical Crops not founded!", (Object[])new Object[0]);
            return;
        }
        try {
            Class<?> MSeeds = Class.forName("com.mark719.magicalcrops.handlers.MSeeds");
            Class<?> MCrops = Class.forName("com.mark719.magicalcrops.handlers.MCrops");
            FMLLog.info((String)"Registering Magical Crops for Planter/Harvester/Fertilizer", (Object[])new Object[0]);
            Field[] hSeeds = MSeeds.getFields();
            Field[] hCrops = MCrops.getFields();
            ArrayList<ItemSeeds> Seeds = new ArrayList<ItemSeeds>();
            ArrayList<BlockBush> Crops = new ArrayList<BlockBush>();
            FMLLog.info((String)"%d Seeds founded!", (Object[])new Object[]{hSeeds.length});
            int i = 0;
            while (i < hSeeds.length) {
                if (hSeeds[i].get(null) instanceof Item) {
                    Seeds.add((ItemSeeds)hSeeds[i].get(null));
                }
                ++i;
            }
            i = 0;
            while (i < hCrops.length) {
                if (hCrops[i].get(null) instanceof Block) {
                    Crops.add((BlockBush)hCrops[i].get(null));
                }
                ++i;
            }
            i = 0;
            while (i < Seeds.size()) {
                MFRRegistry.registerPlantable((IFactoryPlantable)new PlantableCropPlant((Item)Seeds.get(i), ((ItemSeeds)Seeds.get(i)).getPlant(null, 0, 0, 0)));
                MFRRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable((ItemSeeds)Seeds.get(i)));
                ++i;
            }
            FMLLog.info((String)"%d Seeds added to MFR!", (Object[])new Object[]{Seeds.size()});
        }
        catch (ClassNotFoundException e) {
            FMLLog.warning((String)"Unable to load support for Magical Crops", (Object[])new Object[0]);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Class<?> ModCompat = Class.forName("com.mark719.magicalcrops.handlers.ModCompat");
            Field[] list = ModCompat.getFields();
            ArrayList<ItemSeeds> ModSeeds = new ArrayList<ItemSeeds>();
            int i = 0;
            while (i < list.length) {
                try {
                    if (list[i].get(null) instanceof ItemSeeds && list[i].get(null) != null) {
                        ModSeeds.add((ItemSeeds)list[i].get(null));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            FMLLog.info((String)"%d Seeds founded!", (Object[])new Object[]{ModSeeds.size()});
            i = 0;
            while (i < ModSeeds.size()) {
                FMLLog.info((String)"Added %s to MFR!", (Object[])new Object[]{((ItemSeeds)ModSeeds.get(i)).toString()});
                MFRRegistry.registerPlantable((IFactoryPlantable)new PlantableCropPlant((Item)ModSeeds.get(i), ((ItemSeeds)ModSeeds.get(i)).getPlant(null, 0, 0, 0)));
                MFRRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable((ItemSeeds)ModSeeds.get(i)));
                ++i;
            }
            FMLLog.info((String)"%d Seeds added to MFR!", (Object[])new Object[]{ModSeeds.size()});
        }
        catch (ClassNotFoundException e) {
            FMLLog.warning((String)"Unable to load support for Magical Crops", (Object[])new Object[0]);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

