/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.inventory.Validator;
import binnie.core.machines.inventory.ValidatorIcon;
import binnie.core.util.I18N;
import forestry.api.genetics.AlleleManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class SlotValidator
extends Validator<ItemStack> {
    public static ValidatorIcon IconBee;
    public static ValidatorIcon IconFrame;
    public static ValidatorIcon IconCircuit;
    public static ValidatorIcon IconBlock;
    private ValidatorIcon icon;

    public SlotValidator(ValidatorIcon icon) {
        this.icon = icon;
    }

    public IIcon getIcon(boolean input) {
        if (this.icon == null) {
            return null;
        }
        return this.icon.getIcon(input).getIcon();
    }

    public static class Individual
    extends SlotValidator {
        public Individual() {
            super(null);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return AlleleManager.alleleRegistry.getIndividual(itemStack) != null;
        }

        @Override
        public String getTooltip() {
            return I18N.localise("binniecore.gui.slot.breedableIndividual");
        }
    }

    public static class Item
    extends SlotValidator {
        private ItemStack target;

        public Item(ItemStack target, ValidatorIcon icon) {
            super(icon);
            this.target = target;
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return itemStack.func_77969_a(this.target);
        }

        @Override
        public String getTooltip() {
            return this.target.func_82833_r();
        }
    }
}

