/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary.machine.stimulator;

import binnie.core.genetics.BeeModifierLogic;
import binnie.core.genetics.EnumBeeBooleanModifier;
import binnie.core.genetics.EnumBeeModifier;
import binnie.extrabees.apiary.machine.stimulator.StimulatorCircuit;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.circuits.ICircuitLayout;

public enum CircuitType implements IBeeModifier
{
    LowVoltage(3, 10),
    HighVoltage(5, 20),
    Plant(10, 10),
    Death(6, 10),
    Life(11, 10),
    Nether(7, 15),
    Mutation(4, 15),
    Inhibitor(1, 10),
    Territory(2, 10);

    public int recipe;
    public int power;
    protected BeeModifierLogic logic = new BeeModifierLogic();

    private CircuitType(int recipe, int power) {
        this.recipe = recipe;
        this.power = power;
    }

    public void createCircuit(ICircuitLayout layout) {
        StimulatorCircuit circuit = new StimulatorCircuit(this, layout);
        for (EnumBeeModifier modifier : EnumBeeModifier.values()) {
            float mod = this.logic.getModifier(modifier, 1.0f);
            if (mod == 1.0f) continue;
            if (mod > 1.0f) {
                int increase = (int)((mod - 1.0f) * 100.0f);
                circuit.addTooltipString("Increases " + modifier.getName() + " by " + increase + "%");
                continue;
            }
            int decrease = (int)((1.0f - mod) * 100.0f);
            circuit.addTooltipString("Decreases " + modifier.getName() + " by " + decrease + "%");
        }
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.TERRITORY, currentModifier);
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.MUTATION, currentModifier);
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.LIFESPAN, currentModifier);
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.PRODUCTION, currentModifier);
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.FLOWERING, currentModifier);
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.GENETIC_DECAY, currentModifier);
    }

    public boolean isSealed() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SEALED);
    }

    public boolean isSelfLighted() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SELF_LIGHTED);
    }

    public boolean isSunlightSimulated() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SUNLIGHT_STIMULATED);
    }

    public boolean isHellish() {
        return this.logic.getModifier(EnumBeeBooleanModifier.HELLISH);
    }

    static {
        CircuitType.LowVoltage.logic.setModifier(EnumBeeModifier.PRODUCTION, 1.5f, 5.0f);
        CircuitType.HighVoltage.logic.setModifier(EnumBeeModifier.PRODUCTION, 2.5f, 10.0f);
        CircuitType.Plant.logic.setModifier(EnumBeeModifier.FLOWERING, 1.5f, 5.0f);
        CircuitType.Death.logic.setModifier(EnumBeeModifier.LIFESPAN, 0.8f, 0.2f);
        CircuitType.Life.logic.setModifier(EnumBeeModifier.LIFESPAN, 1.5f, 5.0f);
        CircuitType.Nether.logic.setModifier(EnumBeeBooleanModifier.HELLISH);
        CircuitType.Mutation.logic.setModifier(EnumBeeModifier.MUTATION, 1.5f, 5.0f);
        CircuitType.Inhibitor.logic.setModifier(EnumBeeModifier.TERRITORY, 0.4f, 0.1f);
        CircuitType.Inhibitor.logic.setModifier(EnumBeeModifier.PRODUCTION, 0.9f, 0.5f);
        CircuitType.Territory.logic.setModifier(EnumBeeModifier.TERRITORY, 1.5f, 5.0f);
        for (CircuitType type : CircuitType.values()) {
            type.logic.setModifier(EnumBeeModifier.GENETIC_DECAY, 1.5f, 10.0f);
        }
    }
}

