/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.block.TileEntityMetadata;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.block.PlankType;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.worldgen.BlockTypeLog;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface ILogType {
    public void placeBlock(World var1, int var2, int var3, int var4);

    public ItemStack getItemStack();

    public int getColour();

    public static enum VanillaLog implements ILogType
    {
        Oak(6376752),
        Spruce(2759179),
        Birch(6376752),
        Jungle(5456154);

        protected int colour;

        private VanillaLog(int colour) {
            this.colour = colour;
        }

        @Override
        public void placeBlock(World world, int x, int y, int z) {
            world.func_147465_d(x, y, z, Blocks.field_150364_r, this.ordinal(), 2);
        }

        @Override
        public ItemStack getItemStack() {
            return new ItemStack(Blocks.field_150364_r, 1, this.ordinal());
        }

        @Override
        public int getColour() {
            return this.colour;
        }
    }

    public static enum ForestryLog implements ILogType
    {
        LARCH(1, 0, 6376529),
        TEAK(1, 1, 3486249),
        ACACIA(1, 2, 7565906),
        LIME(1, 3, 7431512),
        CHESTNUT(2, 0, 6183484),
        WENGE(2, 1, 6444875),
        BAOBAB(2, 2, 14326376),
        SEQUOIA(2, 3, 11563861),
        KAPOK(3, 0, 5396559),
        EBONY(3, 1, 10453073),
        MAHOGANY(3, 2, 9403501),
        BALSA(3, 3, 8551285),
        WILLOW(4, 0, 10590869),
        WALNUT(4, 1, 9474682),
        GREENHEART(4, 2, 7956050),
        CHERRY(4, 3, 6296064),
        MAHOE(5, 0, 6382152),
        POPLAR(5, 1, 9217671),
        PALM(5, 2, 8941379),
        PAPAYA(5, 3, 9069862),
        PINE(6, 0, 7558729),
        PLUM(6, 1, 11961953),
        MAPLE(6, 2, 9078657),
        CITRUS(6, 3, 5983033);

        protected int block;
        protected int metadata;
        protected int colour;

        private ForestryLog(int blockOffset, int meta, int colour) {
            this.block = blockOffset;
            this.metadata = meta;
            this.colour = colour;
        }

        @Override
        public void placeBlock(World world, int x, int y, int z) {
            BlockTypeLog logBlock = new BlockTypeLog(TreeManager.woodItemAccess.getLog(EnumWoodType.valueOf((String)this.name().toUpperCase()), false));
            logBlock.setDirection(ForgeDirection.UP);
            logBlock.setBlock(world, x, y, z);
        }

        @Override
        public ItemStack getItemStack() {
            return TreeManager.woodItemAccess.getLog(EnumWoodType.valueOf((String)this.name().toUpperCase()), false);
        }

        @Override
        public int getColour() {
            return this.colour;
        }
    }

    public static enum ExtraTreeLog implements ILogType
    {
        Apple("apple", 0x7B7A7B, PlankType.ExtraTreePlanks.Apple),
        Fig("fig", 8418135, PlankType.ExtraTreePlanks.Fig),
        Butternut("butternut", 12037536, PlankType.ExtraTreePlanks.Butternut),
        Cherry("cherry", 7432272, PlankType.ForestryPlanks.CHERRY),
        Whitebeam("whitebeam", 7891565, PlankType.ExtraTreePlanks.Whitebeam),
        Rowan("rowan", 11972763, PlankType.ExtraTreePlanks.Rowan),
        Hemlock("hemlock", 11379611, PlankType.ExtraTreePlanks.Hemlock),
        Ash("ash", 0x898982, PlankType.ExtraTreePlanks.Ash),
        Alder("alder", 13025464, PlankType.ExtraTreePlanks.Alder),
        Beech("beech", 11702654, PlankType.ExtraTreePlanks.Beech),
        Hawthorn("hawthorn", 6248261, PlankType.ExtraTreePlanks.Hawthorn),
        Banana("banana", 8753743),
        Yew("yew", 13745089, PlankType.ExtraTreePlanks.Yew),
        Cypress("cypress", 10126467, PlankType.ExtraTreePlanks.Cypress),
        Fir("fir", 0x828382, PlankType.ExtraTreePlanks.Fir),
        Hazel("hazel", 11180143, PlankType.ExtraTreePlanks.Hazel),
        Hickory("hickory", 4076848, PlankType.ExtraTreePlanks.Hickory),
        Elm("elm", 8684422, PlankType.ExtraTreePlanks.Elm),
        Elder("elder", 14202996, PlankType.ExtraTreePlanks.Elder),
        Holly("holly", 11905669, PlankType.ExtraTreePlanks.Holly),
        Hornbeam("hornbeam", 10719862, PlankType.ExtraTreePlanks.Hornbeam),
        Cedar("cedar", 11368015, PlankType.ExtraTreePlanks.Cedar),
        Olive("olive", 8089706, PlankType.ExtraTreePlanks.Olive),
        Sweetgum("sweetgum", 10592668, PlankType.ExtraTreePlanks.Sweetgum),
        Locust("locust", 11381948, PlankType.ExtraTreePlanks.Locust),
        Pear("pear", 11048825, PlankType.ExtraTreePlanks.Pear),
        Maclura("maclura", 9131828, PlankType.ExtraTreePlanks.Maclura),
        Brazilwood("brazilwood", 10387560, PlankType.ExtraTreePlanks.Brazilwood),
        Logwood("logwood", 16376530, PlankType.ExtraTreePlanks.Logwood),
        Rosewood("rosewood", 0x998666, PlankType.ExtraTreePlanks.Rosewood),
        Purpleheart("purpleheart", 9671330, PlankType.ExtraTreePlanks.Purpleheart),
        Iroko("iroko", 6315099, PlankType.ExtraTreePlanks.Iroko),
        Gingko("gingko", 11382428, PlankType.ExtraTreePlanks.Gingko),
        Eucalyptus("eucalyptus", 0xEADEDA, PlankType.ExtraTreePlanks.Eucalyptus),
        Eucalyptus2("eucalyptus", 8814181, PlankType.ExtraTreePlanks.Eucalyptus),
        Box("box", 11235159, PlankType.ExtraTreePlanks.Box),
        Syzgium("syzgium", 11235159, PlankType.ExtraTreePlanks.Syzgium),
        Eucalyptus3("eucalyptus", 7123007, PlankType.ExtraTreePlanks.Eucalyptus),
        Cinnamon("cinnamon", 8804412, PlankType.VanillaPlanks.JUNGLE),
        PinkIvory("pinkivory", 8349012, PlankType.ExtraTreePlanks.PinkIvory);

        protected String name;
        protected int color;
        protected IDesignMaterial plank;
        protected IIcon trunk;
        protected IIcon bark;

        private ExtraTreeLog(String name, int color) {
            this.name = name;
            this.color = color;
            this.plank = null;
        }

        private ExtraTreeLog(String name, int color, IDesignMaterial plank) {
            this.name = name;
            this.color = color;
            this.plank = plank;
        }

        public static void registerIcons(IIconRegister register) {
            for (ExtraTreeLog log : ExtraTreeLog.values()) {
                log.trunk = ExtraTrees.proxy.getIcon(register, "logs/" + log.toString().toLowerCase() + "Trunk");
                log.bark = ExtraTrees.proxy.getIcon(register, "logs/" + log.toString().toLowerCase() + "Bark");
            }
        }

        public String getName() {
            return I18N.localise("extratrees.block.planks." + this.name);
        }

        public void addRecipe() {
            if (this.plank == null) {
                return;
            }
            ItemStack log = this.getItemStack();
            ItemStack result = this.plank.getStack();
            result.field_77994_a = 4;
            GameRegistry.addShapelessRecipe((ItemStack)result, (Object[])new Object[]{log});
        }

        @Override
        public void placeBlock(World world, int x, int y, int z) {
            world.func_147465_d(x, y, z, ExtraTrees.blockLog, 0, 2);
            if (world.func_147438_o(x, y, z) != null) {
                ((TileEntityMetadata)world.func_147438_o(x, y, z)).setTileMetadata(this.ordinal(), false);
            }
        }

        public IIcon getTrunk() {
            return this.trunk;
        }

        public IIcon getBark() {
            return this.bark;
        }

        @Override
        public ItemStack getItemStack() {
            return TileEntityMetadata.getItemStack(ExtraTrees.blockLog, this.ordinal()).func_77946_l();
        }

        @Override
        public int getColour() {
            return this.color;
        }
    }
}

