/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.incubator;

import binnie.core.machines.Machine;
import binnie.core.machines.power.ComponentProcessIndefinate;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.transfer.TransferRequest;
import binnie.core.util.I18N;
import binnie.genetics.api.IIncubatorRecipe;
import binnie.genetics.machine.incubator.Incubator;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class IncubatorComponentLogic
extends ComponentProcessIndefinate
implements IProcess {
    IIncubatorRecipe recipe = null;
    private Random rand = new Random();
    private boolean roomForOutput = true;

    public IncubatorComponentLogic(Machine machine) {
        super(machine, 2.0f);
    }

    @Override
    public ErrorState canWork() {
        if (this.recipe != null) {
            return super.canWork();
        }
        return new ErrorState(I18N.localise("genetics.machine.incubator.error.noRecipe.title"), I18N.localise("genetics.machine.incubator.error.noRecipe"));
    }

    @Override
    public ErrorState canProgress() {
        if (this.recipe != null) {
            if (!this.recipe.isInputLiquidSufficient(this.getUtil().getFluid(0))) {
                return new ErrorState.InsufficientLiquid(I18N.localise("genetics.machine.incubator.error.noLiquid"), 0);
            }
            if (!this.roomForOutput) {
                return new ErrorState.TankSpace(I18N.localise("genetics.machine.incubator.error.noRoom"), 1);
            }
        }
        return super.canProgress();
    }

    @Override
    protected void onTickTask() {
        if (this.rand.nextInt(20) == 0 && this.recipe != null && this.rand.nextFloat() < this.recipe.getChance()) {
            this.recipe.doTask(this.getUtil());
        }
    }

    @Override
    public boolean inProgress() {
        return this.recipe != null;
    }

    private IIncubatorRecipe getRecipe(ItemStack stack, FluidStack liquid) {
        for (IIncubatorRecipe recipe : Incubator.RECIPES) {
            boolean rightLiquid = recipe.isInputLiquid(liquid);
            boolean rightItem = recipe.isItemStack(stack);
            if (!rightLiquid || !rightItem) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void onInventoryUpdate() {
        super.onInventoryUpdate();
        if (!this.getUtil().isServer()) {
            return;
        }
        FluidStack liquid = this.getUtil().getFluid(0);
        ItemStack incubator = this.getUtil().getStack(3);
        if (!(this.recipe == null || incubator != null && liquid != null && this.recipe.isInputLiquid(liquid) && this.recipe.isItemStack(incubator))) {
            this.recipe = null;
            ItemStack leftover = new TransferRequest(incubator, this.getInventory()).setTargetSlots(Incubator.SLOT_OUTPUT).ignoreValidation().transfer(true);
            this.getUtil().setStack(3, leftover);
        }
        if (this.recipe == null) {
            IIncubatorRecipe recipe;
            if (liquid == null) {
                return;
            }
            if (incubator != null && (recipe = this.getRecipe(incubator, liquid)) != null) {
                this.recipe = recipe;
                return;
            }
            IIncubatorRecipe potential = null;
            int potentialSlot = 0;
            block0: for (int slot : Incubator.SLOT_QUEUE) {
                ItemStack stack = this.getUtil().getStack(slot);
                if (stack == null || potential != null) continue;
                for (IIncubatorRecipe recipe2 : Incubator.RECIPES) {
                    boolean rightLiquid = recipe2.isInputLiquid(liquid);
                    boolean rightItem = recipe2.isItemStack(stack);
                    if (!rightLiquid || !rightItem) continue;
                    potential = recipe2;
                    potentialSlot = slot;
                    continue block0;
                }
            }
            if (potential != null) {
                TransferRequest removal = new TransferRequest(incubator, this.getInventory()).setTargetSlots(Incubator.SLOT_OUTPUT).ignoreValidation();
                if (removal.transfer(false) == null) {
                    this.recipe = potential;
                }
                removal.transfer(true);
                ItemStack stack2 = this.getUtil().getStack(potentialSlot);
                this.getUtil().setStack(potentialSlot, null);
                this.getUtil().setStack(3, stack2);
            }
        }
        if (this.recipe != null) {
            this.roomForOutput = this.recipe.roomForOutput(this.getUtil());
        }
    }
}

