/*
 * Decompiled with CFR 0.152.
 */
package chocohead.patcher;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

@IFMLLoadingPlugin.Name(value="Choco Patcher ASM")
@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.SortingIndex(value=5)
@IFMLLoadingPlugin.TransformerExclusions(value={"chocohead.patcher"})
public final class PatcherPlugin
implements IFMLLoadingPlugin,
IClassTransformer {
    public static final boolean obfuscated;

    public String[] getASMTransformerClass() {
        return new String[]{"chocohead.patcher.PatcherPlugin"};
    }

    public String getModContainerClass() {
        return "chocohead.patcher.PatcherPlugin$Patcher";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("gravisuite.ItemSimpleItems")) {
            return this.fixGSNames(basicClass);
        }
        if (transformedName.equals("gravisuite.BlockRelocatorPortal")) {
            return this.fixGSTexture(basicClass);
        }
        if (transformedName.equals("gravisuite.keyboard.KeyboardClient")) {
            return this.fixGSKeys(basicClass);
        }
        if (transformedName.equals("gravisuite.client.ClientTickHandler")) {
            return this.patchGSTickHandler(basicClass);
        }
        if (transformedName.equals("gravisuite.GraviSuite")) {
            return this.fixGSRecipes(basicClass);
        }
        if (transformedName.equals("advsolar.common.AdvancedSolarPanel")) {
            return this.fixASPRecipes(basicClass);
        }
        return basicClass;
    }

    private byte[] fixASPRecipes(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("afterModsLoaded")) continue;
            ArrayList<MethodInsnNode> fix = new ArrayList<MethodInsnNode>();
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() != 9 || !((LdcInsnNode)n).cst.equals("reactorReflectorThick")) continue;
                fix.add((MethodInsnNode)n.getNext());
            }
            if (fix.size() > 0) {
                InsnList l = new InsnList();
                for (MethodInsnNode n : fix) {
                    l.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", obfuscated ? "func_77973_b" : "getItem", "()Lnet/minecraft/item/Item;", false));
                    l.add((AbstractInsnNode)new InsnNode(4));
                    l.add((AbstractInsnNode)new InsnNode(4));
                    l.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/item/ItemStack", "<init>", "(Lnet/minecraft/item/Item;II)V", false));
                    method.instructions.insert((AbstractInsnNode)n, l);
                    method.instructions.insertBefore(n.getPrevious(), (AbstractInsnNode)new TypeInsnNode(187, "net/minecraft/item/ItemStack"));
                    method.instructions.insertBefore(n.getPrevious(), (AbstractInsnNode)new InsnNode(89));
                }
                Patcher.logger.info("Suceeded in transforming AdvancedSolarPanel (" + fix.size() + " recipe item" + (fix.size() > 1 ? "s" : "") + ")");
                break;
            }
            Patcher.logger.info("Error finding any ASP items to fix");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] fixGSRecipes(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("afterModsLoaded")) continue;
            ArrayList<MethodInsnNode> fix = new ArrayList<MethodInsnNode>();
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() != 9 || !((LdcInsnNode)n).cst.equals("reactorCoolantSix") && !((LdcInsnNode)n).cst.equals("reactorHeatSwitchDiamond") && !((LdcInsnNode)n).cst.equals("reactorVentDiamond")) continue;
                fix.add((MethodInsnNode)n.getNext());
            }
            if (fix.size() > 0) {
                InsnList l = new InsnList();
                for (MethodInsnNode n : fix) {
                    l.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", obfuscated ? "func_77973_b" : "getItem", "()Lnet/minecraft/item/Item;", false));
                    l.add((AbstractInsnNode)new InsnNode(4));
                    l.add((AbstractInsnNode)new InsnNode(4));
                    l.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/item/ItemStack", "<init>", "(Lnet/minecraft/item/Item;II)V", false));
                    method.instructions.insert((AbstractInsnNode)n, l);
                    method.instructions.insertBefore(n.getPrevious(), (AbstractInsnNode)new TypeInsnNode(187, "net/minecraft/item/ItemStack"));
                    method.instructions.insertBefore(n.getPrevious(), (AbstractInsnNode)new InsnNode(89));
                }
                Patcher.logger.info("Suceeded in transforming GraviSuite (" + fix.size() + " recipe item" + (fix.size() > 1 ? "s" : "") + ")");
                break;
            }
            Patcher.logger.info("Error finding any GS items to fix");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] fixGSNames(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("getUnlocalizedName") && !method.name.equals("func_77667_c")) continue;
            ++method.maxStack;
            FieldInsnNode pre = null;
            TypeInsnNode post = null;
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() == 4 && n.getOpcode() == 178) {
                    pre = (FieldInsnNode)n;
                    continue;
                }
                if (n.getType() != 3 || n.getOpcode() != 192) continue;
                post = (TypeInsnNode)n;
                break;
            }
            if (pre != null && post != null) {
                InsnList l = new InsnList();
                l.add((AbstractInsnNode)new TypeInsnNode(187, "java/lang/StringBuilder"));
                l.add((AbstractInsnNode)new InsnNode(89));
                l.add((AbstractInsnNode)new LdcInsnNode((Object)"item."));
                l.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false));
                method.instructions.insertBefore((AbstractInsnNode)pre, l);
                l.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false));
                l.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false));
                method.instructions.insert((AbstractInsnNode)post, l);
                Patcher.logger.info("Suceeded in transforming ItemSimpleItems");
                break;
            }
            Patcher.logger.info("Error finding insert location in ItemSimpleItems: " + (pre == null) + " - " + (post == null));
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] fixGSTexture(byte[] basicClass) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("registerBlockIcons") && !method.name.equals("func_149651_a")) continue;
            for (AbstractInsnNode n = method.instructions.getFirst(); n != null; n = n.getNext()) {
                if (n.getType() != 9 || !((LdcInsnNode)n).cst.equals("gravisuite:block_side.png")) continue;
                ((LdcInsnNode)n).cst = "gravisuite:block_side";
                Patcher.logger.info("Suceeded in transforming BlockRelocatorPortal");
                break block0;
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] fixGSKeys(byte[] basicClass) {
        ClassNode node = new ClassNode(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("isBoostKeyDown") || name.equals("isAltKeyDown") || name.equals("isModeKeyPress") || name.equals("isJumpKeyDown") || name.equals("isSneakKeyDown")) {
                    return null;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        ClassWriter writer = new ClassWriter(0);
        this.patchGSKeys(writer, "isBoostKeyDown");
        this.patchGSKeys(writer, "isAltKeyDown");
        MethodVisitor method = writer.visitMethod(9, "isModeKeyPress", "(Lnet/minecraft/entity/player/EntityPlayer;)Z", null, null);
        method.visitCode();
        Label start = new Label();
        method.visitLabel(start);
        method.visitFieldInsn(178, "ic2/api/util/Keys", "instance", "Lic2/api/util/IKeyboard;");
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(185, "ic2/api/util/IKeyboard", "isModeSwitchKeyDown", "(Lnet/minecraft/entity/player/EntityPlayer;)Z", true);
        Label pressed = new Label();
        method.visitJumpInsn(153, pressed);
        method.visitFieldInsn(178, "gravisuite/keyboard/KeyboardClient", "lastKeyModeState", "Z");
        Label seenDown = new Label();
        method.visitJumpInsn(154, seenDown);
        method.visitInsn(4);
        method.visitFieldInsn(179, "gravisuite/keyboard/KeyboardClient", "lastKeyModeState", "Z");
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(184, "gravisuite/keyboard/KeyboardClient", "sendModeKey", "(Lnet/minecraft/entity/player/EntityPlayer;)V", false);
        method.visitLabel(seenDown);
        method.visitLineNumber(70, seenDown);
        method.visitFrame(3, 0, null, 0, null);
        method.visitInsn(4);
        method.visitInsn(172);
        method.visitLabel(pressed);
        method.visitLineNumber(72, pressed);
        method.visitFrame(3, 0, null, 0, null);
        method.visitInsn(3);
        method.visitFieldInsn(179, "gravisuite/keyboard/KeyboardClient", "lastKeyModeState", "Z");
        method.visitInsn(3);
        method.visitInsn(172);
        Label end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("player", "Lnet/minecraft/entity/player/EntityPlayer;", null, start, end, 0);
        method.visitMaxs(2, 1);
        method.visitEnd();
        this.patchGSKeys(writer, "isJumpKeyDown");
        this.patchGSKeys(writer, "isSneakKeyDown");
        node.accept((ClassVisitor)writer);
        Patcher.logger.info("Suceeded in transforming KeyboardClient");
        return writer.toByteArray();
    }

    private void patchGSKeys(ClassWriter writer, String name) {
        MethodVisitor method = writer.visitMethod(9, name, "(Lnet/minecraft/entity/player/EntityPlayer;)Z", null, null);
        method.visitCode();
        Label start = new Label();
        method.visitLabel(start);
        method.visitFieldInsn(178, "ic2/api/util/Keys", "instance", "Lic2/api/util/IKeyboard;");
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(185, "ic2/api/util/IKeyboard", name, "(Lnet/minecraft/entity/player/EntityPlayer;)Z", true);
        method.visitInsn(172);
        Label end = new Label();
        method.visitLabel(end);
        method.visitLocalVariable("player", "Lnet/minecraft/entity/player/EntityPlayer;", null, start, end, 0);
        method.visitMaxs(2, 1);
        method.visitEnd();
    }

    private byte[] patchGSTickHandler(byte[] basicClass) {
        ClassNode node = new ClassNode(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.equals("onTickClient")) {
                    return null;
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        ClassWriter writer = new ClassWriter(0);
        MethodVisitor method = writer.visitMethod(9, "onTickClient", "()V", null, null);
        method.visitCode();
        method.visitFieldInsn(178, "gravisuite/client/ClientTickHandler", "mc", "Lnet/minecraft/client/Minecraft;");
        method.visitFieldInsn(180, "net/minecraft/client/Minecraft", obfuscated ? "field_71441_e" : "theWorld", "Lnet/minecraft/client/multiplayer/WorldClient;");
        Label check = new Label();
        method.visitJumpInsn(198, check);
        method.visitFieldInsn(178, "gravisuite/client/ClientTickHandler", "mc", "Lnet/minecraft/client/Minecraft;");
        method.visitFieldInsn(180, "net/minecraft/client/Minecraft", obfuscated ? "field_71439_g" : "thePlayer", "Lnet/minecraft/client/entity/EntityClientPlayerMP;");
        method.visitFieldInsn(178, "gravisuite/GraviSuite", "keyboard", "Lgravisuite/keyboard/Keyboard;");
        method.visitInsn(95);
        method.visitMethodInsn(182, "gravisuite/keyboard/Keyboard", "sendKeyUpdate", "(Lnet/minecraft/entity/player/EntityPlayer;)V", false);
        method.visitLabel(check);
        method.visitFrame(3, 0, null, 0, null);
        method.visitInsn(177);
        method.visitMaxs(1, 0);
        method.visitEnd();
        node.accept((ClassVisitor)writer);
        Patcher.logger.info("Suceeded in transforming ClientTickHandler");
        return writer.toByteArray();
    }

    private String fix(int type) {
        switch (type) {
            case 4: {
                return "Field Insn";
            }
            case 14: {
                return "Frame";
            }
            case 10: {
                return "Iinc Insn";
            }
            case 0: {
                return "Insn";
            }
            case 1: {
                return "Int Insn";
            }
            case 6: {
                return "Invoke Dynamic Insn";
            }
            case 7: {
                return "Jump Insn";
            }
            case 8: {
                return "Label";
            }
            case 9: {
                return "Ldc Insn";
            }
            case 15: {
                return "Line number";
            }
            case 12: {
                return "Lookupswitch Insn";
            }
            case 5: {
                return "Method Insn";
            }
            case 13: {
                return "Multi a new array Insn";
            }
            case 11: {
                return "Tableswitch Insn";
            }
            case 3: {
                return "Type Insn";
            }
            case 2: {
                return "Var Insn";
            }
        }
        return "Unknown: " + type;
    }

    static {
        boolean o = true;
        try {
            o = Launch.classLoader.getClassBytes("net.minecraft.world.World") == null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        obfuscated = o;
    }

    public static final class Patcher
    extends DummyModContainer {
        @Mod.Instance(value="ChocoPatcher")
        public static Patcher instance;
        public static Logger logger;

        public Patcher() {
            super(new ModMetadata());
            ModMetadata md = super.getMetadata();
            md.authorList = Arrays.asList("Chocohead");
            md.version = "1.1";
            md.name = "Choco Patcher";
            md.modId = "ChocoPatcher";
            md.autogenerated = false;
            md.description = "Coremod to fix Advanced Solar Panels and/or GraviSuite";
            md.parent = "IC2";
            md.dependencies = Arrays.asList(VersionParser.parseVersionReference((String)"IC2"), VersionParser.parseVersionReference((String)"AdvancedSolarPanel"), VersionParser.parseVersionReference((String)"GraviSuite"));
            instance = this;
            logger = LogManager.getLogger((String)"Patcher");
        }

        public boolean registerBus(EventBus bus, LoadController conroller) {
            bus.register((Object)this);
            return true;
        }

        @Subscribe
        public void preInit(FMLPreInitializationEvent event) {
            logger = event.getModLog();
        }

        @Subscribe
        public void postInit(FMLPostInitializationEvent event) {
            if (Loader.isModLoaded((String)"GraviSuite")) {
                try {
                    Class<?> gravi = Class.forName("gravisuite.GraviSuite");
                    LanguageRegistry.addName((Object)((Item)gravi.getField("sonicLauncher").get(gravi)), (String)"Sonic Launcher");
                    LanguageRegistry.addName((Object)((Block)gravi.getField("blockRelocatorPortal").get(gravi)), (String)"Relocator Portal");
                }
                catch (Exception e) {
                    logger.warn("Issue trying to fix Gravisuite names:", (Throwable)e);
                }
            }
        }
    }
}

