/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import tconstruct.library.tools.AOEHarvestTool;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.tools.TinkerTools;

@Optional.InterfaceList(value={@Optional.Interface(modid="battlegear2", iface="mods.battlegear2.api.weapons.IBattlegearWeapon"), @Optional.Interface(modid="ZeldaItemAPI", iface="zeldaswordskills.api.item.ISword")})
public class Battleaxe
extends AOEHarvestTool
implements IBattlegearWeapon {
    static Material[] materials = new Material[]{Material.field_151575_d, Material.field_151582_l, Material.field_151594_q, Material.field_151570_A, Material.field_151572_C};

    public Battleaxe() {
        super(4, 1, 1);
        this.func_77655_b("InfiTool.Battleaxe");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    protected String getHarvestType() {
        return "axe";
    }

    @Override
    public boolean func_150894_a(ItemStack itemstack, World world, Block b, int x, int y, int z, EntityLivingBase player) {
        if (b != null && b.func_149688_o() == Material.field_151584_j) {
            return false;
        }
        return AbilityHelper.onBlockChanged(itemstack, world, b, x, y, z, player, this.random);
    }

    @Override
    public Item getHeadItem() {
        return TinkerTools.broadAxeHead;
    }

    @Override
    public Item getHandleItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerTools.broadAxeHead;
    }

    @Override
    public Item getExtraItem() {
        return TinkerTools.toughBinding;
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }

    @Override
    public float getRepairCost() {
        return 4.0f;
    }

    @Override
    public float getDurabilityModifier() {
        return 2.5f;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_battleaxe_fronthead";
            }
            case 1: {
                return "_battleaxe_fronthead_broken";
            }
            case 2: {
                return "_battleaxe_handle";
            }
            case 3: {
                return "_battleaxe_backhead";
            }
            case 4: {
                return "_battleaxe_binding";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_battleaxe_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "battleaxe";
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "harvest", "melee", "slicing"};
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int useCount) {
        int time = this.func_77626_a(stack) - useCount;
        int boost = time / 100;
        if (boost > 2) {
            boost = 2;
        }
        player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, time * 4, boost));
        player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, time * 4, boost));
        player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, time * 4, 0));
        player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, time * 2, 0));
        if (time > 5 && player.field_70122_E) {
            float increase;
            player.func_71020_j(0.2f);
            player.func_70031_b(true);
            float speed = 0.025f * (float)time;
            if (speed > 0.925f) {
                speed = 0.925f;
            }
            if ((increase = (float)(0.02 * (double)time + 0.2)) > 0.56f) {
                increase = 0.56f;
            }
            player.field_70181_x += (double)increase;
            player.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed;
            player.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed;
        }
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase mob, EntityLivingBase player) {
        AbilityHelper.knockbackEntity(mob, 1.5);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).func_71011_bu()) != null && usingItem.func_77973_b() == this) {
            player.field_71158_b.field_78900_b *= 5.0f;
            player.field_71158_b.field_78902_a *= 5.0f;
        }
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack off) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side effectiveSide, ItemStack mainhandItem, ItemStack offhandItem) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack mainhand, ItemStack offhand) {
        if (offhand == null) {
            return true;
        }
        return mainhand != null && mainhand.func_77973_b() != TinkerTools.cleaver && mainhand.func_77973_b() != TinkerTools.battleaxe && offhand.func_77973_b() != TinkerTools.cleaver && offhand.func_77973_b() != TinkerTools.battleaxe;
    }
}

