/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tweaker;

import WayofTime.alchemicalWizardry.api.bindingRegistry.BindingRecipe;
import WayofTime.alchemicalWizardry.api.bindingRegistry.BindingRegistry;
import WayofTime.alchemicalWizardry.common.tweaker.MTHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.Binding")
public class Binding {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new BindingRecipe(MTHelper.toStack(output), MTHelper.toStack(input))));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTHelper.toStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        private BindingRecipe recipe;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            for (BindingRecipe r : BindingRegistry.bindingRecipes) {
                if (r.getResult() == null || !r.getResult().func_77969_a(this.output)) continue;
                this.recipe = r;
                break;
            }
            BindingRegistry.bindingRecipes.remove(this.recipe);
        }

        public boolean canUndo() {
            return BindingRegistry.bindingRecipes != null && this.recipe != null;
        }

        public void undo() {
            BindingRegistry.bindingRecipes.add(this.recipe);
        }

        public String describe() {
            return "Removing Binding Recipe for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Restoring Binding Recipe for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final BindingRecipe recipe;

        public Add(BindingRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            BindingRegistry.bindingRecipes.add(this.recipe);
        }

        public boolean canUndo() {
            return BindingRegistry.bindingRecipes != null;
        }

        public void undo() {
            BindingRegistry.bindingRecipes.remove(this.recipe);
        }

        public String describe() {
            return "Adding Binding Recipe for " + this.recipe.getResult().func_82833_r();
        }

        public String describeUndo() {
            return "Removing Binding Recipe for " + this.recipe.getResult().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

