/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.data;

import com.google.common.collect.ImmutableList;

public enum Base10Numbers {
    ZERO('0'),
    ONE('1'),
    TWO('2'),
    THREE('3'),
    FOUR('4'),
    FIVE('5'),
    SIX('6'),
    SEVEN('7'),
    EIGHT('8'),
    NINE('9');

    private static ImmutableList<Integer> cache;
    private static ImmutableList<Character> cache_char;
    private static ImmutableList<String> cache_string;
    private final char c;

    private Base10Numbers(char c) {
        this.c = c;
    }

    public static ImmutableList<Integer> asList() {
        if (cache == null) {
            ImmutableList.Builder l = new ImmutableList.Builder();
            for (int i = 0; i < Base10Numbers.values().length; ++i) {
                l.add((Object)i);
            }
            cache = l.build();
        }
        return cache;
    }

    public static ImmutableList<Character> asCharList() {
        if (cache_char == null) {
            ImmutableList.Builder l = new ImmutableList.Builder();
            for (int i = 0; i < Base10Numbers.values().length; ++i) {
                l.add((Object)Character.valueOf(Base10Numbers.values()[i].c));
            }
            cache_char = l.build();
        }
        return cache_char;
    }

    public static ImmutableList<String> asStringList() {
        if (cache_string == null) {
            ImmutableList.Builder l = new ImmutableList.Builder();
            for (int i = 0; i < Base10Numbers.values().length; ++i) {
                l.add((Object)("" + Base10Numbers.values()[i].c));
            }
            cache_string = l.build();
        }
        return cache_string;
    }

    public static boolean isNumber(Object obj) {
        if (obj instanceof Integer) {
            return true;
        }
        if (obj instanceof Float) {
            return true;
        }
        if (obj instanceof Double) {
            return true;
        }
        if (obj instanceof Character) {
            return Base10Numbers.asCharList().contains(obj);
        }
        if (obj instanceof String) {
            char[] chars;
            for (char c : chars = ((String)obj).toCharArray()) {
                if (Base10Numbers.asCharList().contains(obj)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int num() {
        return this.ordinal();
    }

    public Character character() {
        return Character.valueOf(this.c);
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

