/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.type;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class Group<J> {
    protected final Set<J> members = new LinkedHashSet<J>();
    private String name;

    public Group(String name, J ... js) {
        this.name = name;
        if (js != null) {
            for (J obj : js) {
                this.addMember(obj);
            }
        }
    }

    public Set<J> getMembers() {
        return this.members;
    }

    protected boolean isValid(J obj) {
        return obj != null && !this.members.contains(obj);
    }

    public boolean addMember(J obj) {
        return this.isValid(obj) ? this.members.add(obj) : false;
    }

    public void addMembers(Collection<J> members) {
        for (J mem : members) {
            this.addMember(mem);
        }
    }

    public boolean removeMember(J obj) {
        return this.members.remove(obj);
    }

    public boolean isMember(J obj) {
        return this.members.contains(obj);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        return obj instanceof Group && ((Group)obj).getName().equalsIgnoreCase(this.getName());
    }

    public String toString() {
        return "[Group:" + this.getName() + "]";
    }
}

