/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.api.base;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class Book {
    public List<CategoryAbstract> categoryList = new ArrayList<CategoryAbstract>();
    public String unlocBookTitle;
    public String unlocWelcomeMessage;
    public String unlocDisplayName;
    public String author;
    public ResourceLocation pageTexture;
    public ResourceLocation outlineTexture;
    public String itemTexture;
    public Color bookColor;
    public boolean spawnWithBook;
    public boolean isLostBook;
    public int lootChance;
    public String[] chestHooks;

    public Book(List<CategoryAbstract> categoryList, String unlocBookTitle, String unlocWelcomeMessage, String unlocDisplayName, String author, ResourceLocation pageTexture, ResourceLocation outlineTexture, String itemTexture, Color bookColor, boolean spawnWithBook, boolean isLostBook, int lootChance, String[] chestHooks) {
        this.categoryList = categoryList;
        this.unlocBookTitle = unlocBookTitle;
        this.unlocWelcomeMessage = unlocWelcomeMessage;
        this.unlocDisplayName = unlocDisplayName;
        this.author = author;
        this.pageTexture = pageTexture;
        this.outlineTexture = outlineTexture;
        this.itemTexture = itemTexture;
        this.bookColor = bookColor;
        this.spawnWithBook = spawnWithBook;
        this.isLostBook = isLostBook;
        this.lootChance = lootChance;
        this.chestHooks = chestHooks;
    }

    @Deprecated
    public Book(List<CategoryAbstract> categoryList, String unlocBookTitle, String unlocWelcomeMessage, String unlocDisplayName, ResourceLocation pageTexture, ResourceLocation outlineTexture, Color bookColor) {
        this.categoryList = categoryList;
        this.unlocBookTitle = unlocBookTitle;
        this.unlocWelcomeMessage = unlocWelcomeMessage;
        this.unlocDisplayName = unlocDisplayName;
        this.pageTexture = pageTexture;
        this.outlineTexture = outlineTexture;
        this.bookColor = bookColor;
        this.spawnWithBook = false;
    }

    @Deprecated
    public Book(List<CategoryAbstract> categoryList, String unlocBookTitle, String unlocWelcomeMessage, String unlocDisplayName, Color bookColor) {
        this.categoryList = categoryList;
        this.unlocBookTitle = unlocBookTitle;
        this.unlocWelcomeMessage = unlocWelcomeMessage;
        this.unlocDisplayName = unlocDisplayName;
        this.pageTexture = new ResourceLocation("guideapi:textures/gui/book_colored.png");
        this.outlineTexture = new ResourceLocation("guideapi:textures/gui/book_greyscale.png");
        this.bookColor = bookColor;
        this.spawnWithBook = false;
    }

    @Deprecated
    public Book(List<CategoryAbstract> categoryList, String unlocBookTitle, String unlocWelcomeMessage, String unlocDisplayName, Color bookColor, boolean spawnWithBook) {
        this.categoryList = categoryList;
        this.unlocBookTitle = unlocBookTitle;
        this.unlocWelcomeMessage = unlocWelcomeMessage;
        this.unlocDisplayName = unlocDisplayName;
        this.pageTexture = new ResourceLocation("guideapi:textures/gui/book_colored.png");
        this.outlineTexture = new ResourceLocation("guideapi:textures/gui/book_greyscale.png");
        this.bookColor = bookColor;
        this.spawnWithBook = spawnWithBook;
    }

    public void addCategory(CategoryAbstract category) {
        this.categoryList.add(category);
    }

    public void removeCategory(CategoryAbstract category) {
        this.categoryList.remove(category);
    }

    public void addCategoryList(List<CategoryAbstract> categories) {
        this.categoryList.addAll(categories);
    }

    public void removeCategoryList(List<CategoryAbstract> categories) {
        this.categoryList.removeAll(categories);
    }

    public String getLocalizedBookTitle() {
        return StatCollector.func_74838_a((String)this.unlocBookTitle);
    }

    public String getLocalizedWelcomeMessage() {
        return StatCollector.func_74838_a((String)this.unlocWelcomeMessage);
    }

    public String getLocalizedDisplayName() {
        return StatCollector.func_74838_a((String)this.unlocDisplayName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Book book = (Book)o;
        if (this.spawnWithBook != book.spawnWithBook) {
            return false;
        }
        if (this.bookColor != null ? !this.bookColor.equals(book.bookColor) : book.bookColor != null) {
            return false;
        }
        if (this.categoryList != null ? !this.categoryList.equals(book.categoryList) : book.categoryList != null) {
            return false;
        }
        if (this.outlineTexture != null ? !this.outlineTexture.equals((Object)book.outlineTexture) : book.outlineTexture != null) {
            return false;
        }
        if (this.pageTexture != null ? !this.pageTexture.equals((Object)book.pageTexture) : book.pageTexture != null) {
            return false;
        }
        if (this.unlocBookTitle != null ? !this.unlocBookTitle.equals(book.unlocBookTitle) : book.unlocBookTitle != null) {
            return false;
        }
        if (this.unlocDisplayName != null ? !this.unlocDisplayName.equals(book.unlocDisplayName) : book.unlocDisplayName != null) {
            return false;
        }
        return !(this.unlocWelcomeMessage != null ? !this.unlocWelcomeMessage.equals(book.unlocWelcomeMessage) : book.unlocWelcomeMessage != null);
    }

    public int hashCode() {
        int result = this.categoryList != null ? this.categoryList.hashCode() : 0;
        result = 31 * result + (this.unlocBookTitle != null ? this.unlocBookTitle.hashCode() : 0);
        result = 31 * result + (this.unlocWelcomeMessage != null ? this.unlocWelcomeMessage.hashCode() : 0);
        result = 31 * result + (this.unlocDisplayName != null ? this.unlocDisplayName.hashCode() : 0);
        result = 31 * result + (this.pageTexture != null ? this.pageTexture.hashCode() : 0);
        result = 31 * result + (this.outlineTexture != null ? this.outlineTexture.hashCode() : 0);
        result = 31 * result + (this.bookColor != null ? this.bookColor.hashCode() : 0);
        result = 31 * result + (this.spawnWithBook ? 1 : 0);
        return result;
    }
}

