/*
 * Decompiled with CFR 0.152.
 */
package morph.common.ability;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import morph.api.Ability;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class AbilityPotionEffect
extends Ability {
    public int potionId;
    public int duration;
    public int amplifier;
    public boolean ambient;

    public AbilityPotionEffect() {
        this.potionId = 0;
        this.duration = 0;
        this.amplifier = 0;
        this.ambient = true;
    }

    public AbilityPotionEffect(int id, int dur, int amp, boolean amb) {
        this.potionId = id;
        this.duration = dur;
        this.amplifier = amp;
        this.ambient = amb;
    }

    @Override
    public Ability parse(String[] args) {
        this.potionId = Integer.parseInt(args[0]);
        this.duration = Integer.parseInt(args[1]);
        this.amplifier = Integer.parseInt(args[2]);
        this.ambient = Boolean.parseBoolean(args[3]);
        return this;
    }

    @Override
    public String getType() {
        return "potionEffect";
    }

    @Override
    public void tick() {
    }

    @Override
    public void kill() {
    }

    @Override
    public Ability clone() {
        return new AbilityPotionEffect(this.potionId, this.duration, this.amplifier, this.ambient);
    }

    @Override
    public void save(NBTTagCompound tag) {
        tag.func_74768_a("potionId", this.potionId);
        tag.func_74768_a("duration", this.duration);
        tag.func_74768_a("amplifier", this.amplifier);
        tag.func_74757_a("ambient", this.ambient);
    }

    @Override
    public void load(NBTTagCompound tag) {
        this.potionId = tag.func_74762_e("potionId");
        this.duration = tag.func_74762_e("duration");
        this.amplifier = tag.func_74762_e("amplifier");
        this.ambient = tag.func_74767_n("ambient");
    }

    @Override
    public void postRender() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean entityHasAbility(EntityLivingBase living) {
        EntitySkeleton skele;
        return !(living instanceof EntitySkeleton) || (skele = (EntitySkeleton)living).func_82202_m() == 1;
    }

    @Override
    public ResourceLocation getIcon() {
        return null;
    }
}

