/*
 * Decompiled with CFR 0.152.
 */
package morph.common.core;

import cpw.mods.fml.common.eventhandler.Event;
import ichun.common.core.EntityHelperBase;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import morph.api.MorphAcquiredEvent;
import morph.api.MorphEvent;
import morph.common.Morph;
import morph.common.morph.MorphHandler;
import morph.common.morph.MorphInfo;
import morph.common.morph.MorphState;
import morph.common.packet.PacketMorphAcquisition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;

public class EntityHelper
extends EntityHelperBase {
    public static boolean morphPlayer(EntityPlayerMP player, EntityLivingBase living, boolean kill) {
        return EntityHelper.morphPlayer(player, living, kill, false);
    }

    public static boolean morphPlayer(EntityPlayerMP player, EntityLivingBase living, boolean kill, boolean forced) {
        if (Morph.config.getInt("childMorphs") == 0 && living.func_70631_g_() || Morph.config.getInt("playerMorphs") == 0 && living instanceof EntityPlayer || Morph.config.getInt("bossMorphs") == 0 && living instanceof IBossDisplayData || player.getClass() == FakePlayer.class || player.field_71135_a == null) {
            return false;
        }
        for (Class<? extends EntityLivingBase> clz : Morph.blacklistedClasses) {
            if (!clz.isInstance(living)) continue;
            return false;
        }
        if (!Morph.playerList.isEmpty() && (Morph.config.getInt("listIsBlacklist") == 0 ? Morph.playerList.contains(player.func_70005_c_()) : !Morph.playerList.contains(player.func_70005_c_()))) {
            return false;
        }
        MorphInfo info = Morph.proxy.tickHandlerServer.getPlayerMorphInfo((EntityPlayer)player);
        if (!(living.func_70039_c(new NBTTagCompound()) && !(living instanceof EntityPlayer) || living instanceof EntityPlayer)) {
            return false;
        }
        if (info == null) {
            info = new MorphInfo(player.func_70005_c_(), null, Morph.proxy.tickHandlerServer.getSelfState(player.field_70170_p, (EntityPlayer)player));
        } else if (info.getMorphing() || info.nextState.entInstance == living) {
            return false;
        }
        byte isPlayer = (byte)(info.nextState.entInstance instanceof EntityPlayer && living instanceof EntityPlayer ? 3 : (info.nextState.entInstance instanceof EntityPlayer ? 1 : (living instanceof EntityPlayer ? 2 : 0)));
        if (!(info.nextState.entInstance instanceof EntityPlayer) && !info.nextState.entInstance.func_70039_c(new NBTTagCompound())) {
            return false;
        }
        String username1 = isPlayer == 1 || isPlayer == 3 ? ((EntityPlayer)info.nextState.entInstance).func_70005_c_() : "";
        String username2 = isPlayer == 2 || isPlayer == 3 ? ((EntityPlayer)living).func_70005_c_() : "";
        NBTTagCompound prevTag = new NBTTagCompound();
        NBTTagCompound nextTag = new NBTTagCompound();
        info.nextState.entInstance.func_70039_c(prevTag);
        living.func_70039_c(nextTag);
        MorphState prevState = new MorphState(player.field_70170_p, player.func_70005_c_(), username1, prevTag, false);
        MorphState nextState = new MorphState(player.field_70170_p, player.func_70005_c_(), username2, nextTag, false);
        if (Morph.proxy.tickHandlerServer.hasMorphState((EntityPlayer)player, nextState) || !forced && MinecraftForge.EVENT_BUS.post((Event)new MorphAcquiredEvent((EntityPlayer)player, nextState.entInstance))) {
            return false;
        }
        prevState = MorphHandler.addOrGetMorphState(Morph.proxy.tickHandlerServer.getPlayerMorphs(player.field_70170_p, (EntityPlayer)player), prevState);
        nextState = MorphHandler.addOrGetMorphState(Morph.proxy.tickHandlerServer.getPlayerMorphs(player.field_70170_p, (EntityPlayer)player), nextState);
        if (nextState.identifier.equalsIgnoreCase(info.nextState.identifier)) {
            return false;
        }
        if (Morph.config.getInt("instaMorph") == 1 || forced) {
            MorphInfo info2 = new MorphInfo(player.func_70005_c_(), prevState, nextState);
            info2.setMorphing(true);
            info2.healthOffset = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() - 20.0;
            info2.preMorphHealth = player.func_110143_aJ();
            MorphInfo info3 = Morph.proxy.tickHandlerServer.getPlayerMorphInfo((EntityPlayer)player);
            if (info3 != null) {
                info2.morphAbilities = info3.morphAbilities;
                info2.healthOffset = info3.healthOffset;
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new MorphEvent((EntityPlayer)player, info2.prevState.entInstance, info2.nextState.entInstance))) {
                Morph.proxy.tickHandlerServer.setPlayerMorphInfo((EntityPlayer)player, info2);
                PacketHandler.sendToAll(Morph.channels, (AbstractPacket)info2.getMorphInfoAsPacket());
                player.field_70170_p.func_72956_a((Entity)player, "morph:morph", 1.0f, 1.0f);
            }
        }
        if (kill) {
            PacketHandler.sendToDimension(Morph.channels, (AbstractPacket)new PacketMorphAcquisition(living.func_145782_y(), player.func_145782_y()), (int)player.field_71093_bK);
        }
        MorphHandler.updatePlayerOfMorphStates(player, nextState, false);
        return true;
    }

    public static boolean demorphPlayer(EntityPlayerMP player) {
        MorphInfo info = Morph.proxy.tickHandlerServer.getPlayerMorphInfo((EntityPlayer)player);
        MorphState state2 = Morph.proxy.tickHandlerServer.getSelfState(player.field_70170_p, (EntityPlayer)player);
        if (info != null) {
            MorphState state1 = info.nextState;
            MorphInfo info2 = new MorphInfo(player.func_70005_c_(), state1, state2);
            info2.setMorphing(true);
            info2.preMorphHealth = player.func_110143_aJ();
            MorphInfo info3 = Morph.proxy.tickHandlerServer.getPlayerMorphInfo((EntityPlayer)player);
            if (info3 != null) {
                info2.morphAbilities = info3.morphAbilities;
                info2.healthOffset = info3.healthOffset;
            }
            Morph.proxy.tickHandlerServer.setPlayerMorphInfo((EntityPlayer)player, info2);
            PacketHandler.sendToAll(Morph.channels, (AbstractPacket)info2.getMorphInfoAsPacket());
            player.field_70170_p.func_72956_a((Entity)player, "morph:morph", 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

