/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.asm;

import com.google.common.base.Throwables;
import com.rwtema.funkylocomotion.helper.ItemHelper;
import com.rwtema.funkylocomotion.items.ItemWrench;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class WrenchFactory {
    private static LaunchClassLoader loader = (LaunchClassLoader)ItemWrench.class.getClassLoader();

    public static ItemWrench makeMeAWrench() {
        Object classBytes2;
        ArrayList<ClassNode> nodes = new ArrayList<ClassNode>(ItemHelper.wrenchClassNames.length);
        ArrayList<String> ifaceList = new ArrayList<String>(ItemHelper.wrenchClassNames.length);
        for (String wrenchClassName : ItemHelper.wrenchClassNames) {
            try {
                classBytes2 = loader.getClassBytes(wrenchClassName);
                if (classBytes2 == null) continue;
                ClassNode node = new ClassNode(327680);
                ClassReader reader = new ClassReader((byte[])classBytes2);
                reader.accept((ClassVisitor)node, 8);
                nodes.add(node);
                ifaceList.add(wrenchClassName.replace('.', '/'));
            }
            catch (IOException classBytes2) {
                // empty catch block
            }
        }
        if (nodes.isEmpty()) {
            return new ItemWrench();
        }
        HashSet<String> methods = new HashSet<String>();
        try {
            byte[] classBytes3 = loader.getClassBytes(ItemWrench.class.getName());
            ClassNode node = new ClassNode(327680);
            ClassReader reader = new ClassReader(classBytes3);
            reader.accept((ClassVisitor)node, 8);
            classBytes2 = node.methods.iterator();
            while (classBytes2.hasNext()) {
                MethodNode method = (MethodNode)classBytes2.next();
                methods.add(WrenchFactory.getMethodDesc(method));
            }
        }
        catch (IOException classBytes3) {
            // empty catch block
        }
        ClassWriter cw = new ClassWriter(0);
        String name = "FLM_ItemWrench";
        String superName = Type.getInternalName(ItemWrench.class);
        String[] ifaces = ifaceList.toArray(new String[ifaceList.size()]);
        cw.visit(50, 33, name, null, superName, ifaces);
        cw.visitSource(".dynamic", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superName, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        for (ClassNode node : nodes) {
            for (MethodNode method : node.methods) {
                String mn = WrenchFactory.getMethodDesc(method);
                if (methods.contains(mn)) continue;
                methods.add(mn);
                Type returnType = Type.getReturnType((String)method.desc);
                int returnOpCode = returnType.getOpcode(172);
                mv = cw.visitMethod(1, method.name, method.desc, null, null);
                mv.visitCode();
                switch (returnOpCode) {
                    case 177: {
                        break;
                    }
                    case 172: {
                        mv.visitInsn(returnType == Type.BOOLEAN_TYPE ? 4 : 3);
                        break;
                    }
                    case 173: {
                        mv.visitInsn(9);
                        break;
                    }
                    case 174: {
                        mv.visitInsn(11);
                        break;
                    }
                    case 175: {
                        mv.visitInsn(14);
                        break;
                    }
                    case 176: {
                        mv.visitInsn(1);
                    }
                }
                mv.visitInsn(returnOpCode);
                mv.visitInsn(177);
                mv.visitMaxs(returnOpCode != 177 ? 1 : 0, 1 + Type.getArgumentTypes((String)method.desc).length);
                mv.visitEnd();
            }
        }
        cw.visitEnd();
        Class<?> ret = new ASMClassLoader().define(name, cw.toByteArray());
        try {
            return (ItemWrench)((Object)ret.newInstance());
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static String getMethodDesc(MethodNode method) {
        return method.name + "_" + method.desc;
    }

    private static class ASMClassLoader
    extends ClassLoader {
        private ASMClassLoader() {
            super(ASMClassLoader.class.getClassLoader());
        }

        public Class<?> define(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }
}

