/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.FunkyLocomotion;
import com.rwtema.funkylocomotion.blocks.TileBooster;
import com.rwtema.funkylocomotion.blocks.TilePusher;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import com.rwtema.funkylocomotion.helper.WeakSet;
import com.rwtema.funkylocomotion.movers.MoveManager;
import com.rwtema.funkylocomotion.particles.ObstructionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import framesapi.BlockPos;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTeleport
extends TilePusher {
    int teleportId;
    static TLongObjectHashMap<WeakSet<TileTeleport>> cache = new TLongObjectHashMap();

    @Override
    public List<BlockPos> getBlocks(World world, BlockPos home, ForgeDirection dir, boolean push) {
        BlockPos advance = home.advance(dir);
        if (BlockHelper.canStick(world, advance, dir.getOpposite())) {
            return this.getBlocks(world, home, advance, ForgeDirection.UNKNOWN);
        }
        return null;
    }

    @Override
    public List<BlockPos> checkPositions(World srcWorld, ForgeDirection moveDir, ArrayList<BlockPos> posList, HashSet<BlockPos> posSet) {
        TileTeleport tile = this.getTileTeleport();
        if (tile == null) {
            return null;
        }
        World dstWorld = tile.field_145850_b;
        boolean fail = false;
        for (BlockPos pos : posList) {
            BlockPos adv = this.getDestinationPos(tile, pos);
            if ((dstWorld != srcWorld || !posSet.contains(adv)) && BlockHelper.canReplace(dstWorld, adv)) continue;
            if (!ObstructionHelper.sendObstructionPacket(srcWorld, pos, moveDir)) {
                return null;
            }
            fail = true;
        }
        return fail ? null : posList;
    }

    private TileTeleport getTileTeleport() {
        if (this.teleportId == 0) {
            return null;
        }
        WeakSet tileTeleports = (WeakSet)cache.get((long)this.teleportId);
        if (tileTeleports == null) {
            return null;
        }
        Iterator iterator = tileTeleports.iterator();
        while (iterator.hasNext()) {
            TileTeleport tile = (TileTeleport)iterator.next();
            if (tile.func_145837_r()) {
                iterator.remove();
            }
            if (tile == this || !tile.func_145830_o()) continue;
            World world = tile.func_145831_w();
            if (world == null || world.field_72995_K) {
                iterator.remove();
            }
            if (DimensionManager.getWorld((int)world.field_73011_w.field_76574_g) != world) {
                iterator.remove();
            }
            if (!world.func_72899_e(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) continue;
            return tile;
        }
        return null;
    }

    private BlockPos getDestinationPos(TileTeleport tile, BlockPos pos) {
        BlockPos srcPos = new BlockPos(this).advance(this.func_145832_p() ^ 1);
        BlockPos dstPos = new BlockPos(tile).advance(tile.func_145832_p() ^ 1);
        return new BlockPos(pos.x - srcPos.x + dstPos.x, pos.y - srcPos.y + dstPos.y, pos.z - srcPos.z + dstPos.z);
    }

    @Override
    public void startMoving() {
        boolean push;
        TileTeleport tileTeleport = this.getTileTeleport();
        if (tileTeleport == null) {
            return;
        }
        int meta = this.func_145832_p();
        ForgeDirection dir = ForgeDirection.getOrientation((int)(meta % 6)).getOpposite();
        boolean bl = push = meta < 6;
        if (dir == ForgeDirection.UNKNOWN) {
            return;
        }
        BlockPos pos = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        List<BlockPos> posList = this.getBlocks(this.field_145850_b, pos, dir, push);
        if (posList != null) {
            int energy = posList.size() * powerPerTile;
            if (this.energy.extractEnergy(energy, true) != energy) {
                return;
            }
            if (tileTeleport.energy.extractEnergy(energy, true) != energy) {
                return;
            }
            ArrayList<TileBooster> boosters = new ArrayList<TileBooster>(6);
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile;
                BlockPos p;
                if (d == dir || BlockHelper.getBlock(this.field_145850_b, p = pos.advance(d)) != FunkyLocomotion.booster || ForgeDirection.getOrientation((int)(BlockHelper.getMeta(this.field_145850_b, p) % 6)) != d || !((tile = BlockHelper.getTile(this.field_145850_b, p)) instanceof TileBooster)) continue;
                TileBooster booster = (TileBooster)tile;
                if (booster.energy.extractEnergy(energy, true) != energy) {
                    return;
                }
                boosters.add(booster);
            }
            if (!boosters.isEmpty()) {
                for (TileBooster booster : boosters) {
                    booster.energy.extractEnergy(energy, false);
                }
            }
            this.energy.extractEnergy(energy, false);
            tileTeleport.energy.extractEnergy(energy, false);
            ArrayList<MoveManager.BlockLink> links = new ArrayList<MoveManager.BlockLink>(posList.size());
            for (BlockPos blockPos : posList) {
                links.add(new MoveManager.BlockLink(blockPos, this.getDestinationPos(tileTeleport, blockPos)));
            }
            MoveManager.startMoving(this.field_145850_b, tileTeleport.field_145850_b, links, ForgeDirection.UNKNOWN, moveTime[boosters.size()] * 2);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.unCache();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.unCache();
    }

    private void unCache() {
        WeakSet tileTeleports;
        if (!(this.teleportId == 0 || this.field_145850_b != null && this.field_145850_b.field_72995_K || (tileTeleports = (WeakSet)cache.get((long)this.teleportId)) == null)) {
            tileTeleports.remove(this);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!(this.teleportId == 0 || this.field_145850_b != null && this.field_145850_b.field_72995_K)) {
            WeakSet<TileTeleport> tileTeleports = (WeakSet<TileTeleport>)cache.get((long)this.teleportId);
            if (tileTeleports == null) {
                tileTeleports = new WeakSet<TileTeleport>();
                cache.put((long)this.teleportId, tileTeleports);
            }
            tileTeleports.add(this);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.teleportId = tag.func_74762_e("ID");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("ID", this.teleportId);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.teleportId = pkt.func_148857_g().func_74762_e("ID");
        if (this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("ID", this.teleportId);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }
}

