/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.fakes;

import com.rwtema.funkylocomotion.blocks.TileMovingClient;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;

@SideOnly(value=Side.CLIENT)
public class FakeWorldClient
extends WorldClient {
    private static final HashMap<World, FakeWorldClient> cache = new HashMap();
    public double offset = 0.0;
    public ForgeDirection dir = ForgeDirection.UNKNOWN;
    final World world;
    final WorldClient worldClient;

    private FakeWorldClient(World world) {
        super(new NetHandlerPlayClient(Minecraft.func_71410_x(), null, new NetworkManager(true)), new WorldSettings(world.func_72912_H()), world.field_73011_w.field_76574_g, world.field_73013_u, world.field_72984_F);
        this.world = world;
        this.worldClient = world instanceof WorldClient ? (WorldClient)world : null;
    }

    public static boolean isValid(World world) {
        return world != null && world.field_73011_w != null && DimensionManager.isDimensionRegistered((int)world.field_73011_w.field_76574_g);
    }

    public static FakeWorldClient getFakeWorldWrapper(World world) {
        FakeWorldClient fakeWorldClient = cache.get(world);
        if (fakeWorldClient == null) {
            fakeWorldClient = new FakeWorldClient(world);
            cache.put(world, fakeWorldClient);
        }
        return fakeWorldClient;
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new FakeWorldManager());
    }

    public boolean func_147445_c(int x, int y, int z, boolean defaultValue) {
        Block block = this.func_147439_a(x, y, z);
        return block.isNormalCube((IBlockAccess)this, x, y, z);
    }

    protected boolean func_72916_c(int x, int z) {
        return this.world.func_72899_e(x << 4, 100, z << 4);
    }

    public Chunk func_72964_e(int x, int z) {
        return this.world.func_72964_e(x, z);
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    protected int func_152379_p() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    public Entity func_73045_a(int id) {
        return this.world.func_73045_a(id);
    }

    public TileMovingClient getTile(int x, int y, int z) {
        TileEntity tile = this.world.func_147438_o(x, y, z);
        return tile != null && tile.getClass() == TileMovingClient.class ? (TileMovingClient)tile : null;
    }

    public Block func_147439_a(int x, int y, int z) {
        TileMovingClient tile = this.getTile(x, y, z);
        if (tile != null) {
            return tile.block;
        }
        return Blocks.field_150350_a;
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        TileMovingClient tile = this.getTile(x, y, z);
        return tile == null ? null : tile.tile;
    }

    public boolean func_147465_d(int x, int y, int z, Block block, int meta, int flag) {
        return false;
    }

    public boolean func_147463_c(EnumSkyBlock skyBlock, int x, int y, int z) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72802_i(int x, int y, int z, int minBrightness) {
        return this.world.func_72802_i(x, y, z, minBrightness);
    }

    public int func_72805_g(int x, int y, int z) {
        TileMovingClient tile = this.getTile(x, y, z);
        return tile == null ? 0 : tile.meta;
    }

    public int func_72879_k(int x, int y, int z, int side) {
        return this.world.func_72879_k(x, y, z, side);
    }

    public boolean func_147437_c(int x, int y, int z) {
        TileMovingClient tile = this.getTile(x, y, z);
        return tile == null || tile.block == Blocks.field_150350_a;
    }

    @SideOnly(value=Side.CLIENT)
    public BiomeGenBase func_72807_a(int x, int z) {
        return this.world.func_72807_a(x, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72800_K() {
        return this.world.func_72800_K();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_72806_N() {
        return this.world.func_72806_N();
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        TileMovingClient tile = this.getTile(x, y, z);
        return tile != null && tile.block.isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    public boolean func_72838_d(Entity entity) {
        return false;
    }

    public void func_72869_a(String type, double x, double y, double z, double r, double g, double b) {
        this.world.func_72869_a(type, x + this.offset * (double)this.dir.offsetX, y + this.offset * (double)this.dir.offsetY, z + this.offset * (double)this.dir.offsetZ, r, g, b);
    }

    public void func_72835_b() {
    }

    public CrashReportCategory func_72914_a(CrashReport crash) {
        CrashReportCategory crashReportCategory = this.world.func_72914_a(crash);
        crashReportCategory.func_71507_a("Fake World", (Object)"This world is a fake wrapper used by Funky Locomotion");
        return crashReportCategory;
    }

    public void func_73029_E(int x, int y, int z) {
        if (this.worldClient != null) {
            this.worldClient.func_73029_E(x, y, z);
        }
    }

    public void func_92088_a(double x, double y, double z, double vx, double vy, double vz, NBTTagCompound tag) {
        if (this.worldClient != null) {
            this.worldClient.func_92088_a(x, y, z, vx, vy, vz, tag);
        }
    }

    public boolean func_147492_c(int x, int y, int z, Block block, int meta) {
        return false;
    }

    public void func_72900_e(Entity entity) {
    }

    public void func_73027_a(int id, Entity entity) {
    }

    public Entity func_73028_b(int entity) {
        return null;
    }

    public void func_72980_b(double x, double y, double z, String sound, float volume, float pitch, boolean positioned) {
        if (this.worldClient != null) {
            this.worldClient.func_72980_b(x, y, z, sound, volume, pitch, positioned);
        }
    }

    public void func_73022_a() {
    }

    public void func_73025_a(int x, int z, boolean load) {
    }

    protected void func_147456_g() {
    }

    public void func_72882_A() {
        this.world.func_72882_A();
    }

    @SideOnly(value=Side.CLIENT)
    public static class FakeWorldManager {
        @SubscribeEvent
        public void onDimensionUnload(WorldEvent.Unload event) {
            cache.remove(event.world);
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server != null && !server.func_71278_l()) {
                cache.clear();
            }
        }
    }
}

