/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.movers;

import com.rwtema.funkylocomotion.blocks.BlockMoving;
import com.rwtema.funkylocomotion.blocks.TileMovingServer;
import com.rwtema.funkylocomotion.description.DescriptorRegistry;
import com.rwtema.funkylocomotion.factory.FactoryRegistry;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import com.rwtema.funkylocomotion.movers.MovingTileRegistry;
import com.rwtema.funkylocomotion.network.FLNetwork;
import com.rwtema.funkylocomotion.network.MessageClearTile;
import framesapi.BlockPos;
import framesapi.IDescriptionProxy;
import framesapi.IMoveFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ReportedException;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class MoveManager {
    public static final NBTTagCompound airBlockTag = new NBTTagCompound();
    public static final NBTTagCompound airDescTag = new NBTTagCompound();
    static final LinkedHashMap<String, Object> vars;
    private static final Object BLANK;

    public static void startMoving(World world, List<BlockPos> posList, ForgeDirection dir, int maxTime) {
        ArrayList<BlockLink> links = new ArrayList<BlockLink>(posList.size());
        for (BlockPos blockPos : posList) {
            links.add(new BlockLink(blockPos, blockPos.advance(dir)));
        }
        MoveManager.startMoving(world, world, links, dir, maxTime);
    }

    public static synchronized void startMoving(World srcWorld, World dstWorld, List<BlockLink> links, ForgeDirection dir, int maxTime) {
        String section = "Start";
        MoveManager.clearVars();
        try {
            PlayerManager.PlayerInstance watcher;
            BlockPos srcPos;
            BlockPos dstPos;
            vars.put("srcWorld", srcWorld);
            vars.put("dstWorld", dstWorld);
            vars.put("links", links);
            vars.put("dir", dir);
            vars.put("maxTime", maxTime);
            if (dir != ForgeDirection.UNKNOWN && srcWorld != dstWorld) {
                throw new IllegalArgumentException("Trying to regular shift between worlds");
            }
            HashSet<BlockPos> srcBlocks = new HashSet<BlockPos>();
            HashSet<BlockPos> dstBlocks = new HashSet<BlockPos>();
            vars.put("srcBlocks", srcBlocks);
            vars.put("dstBlocks", dstBlocks);
            for (BlockLink link : links) {
                srcBlocks.add(link.srcPos);
                dstBlocks.add(link.dstPos);
            }
            HashSet<BlockPos> dstBlocksToBeDestroyed = new HashSet<BlockPos>();
            HashSet<BlockPos> srcBlocksToBecomeAir = new HashSet<BlockPos>();
            vars.put("dstBlocksToBeDestroyed", dstBlocksToBeDestroyed);
            vars.put("srcBlocksToBecomeAir", srcBlocksToBecomeAir);
            srcBlocksToBecomeAir.addAll(srcBlocks);
            dstBlocksToBeDestroyed.addAll(dstBlocks);
            if (srcWorld == dstWorld) {
                srcBlocksToBecomeAir.removeAll(dstBlocks);
                dstBlocksToBeDestroyed.removeAll(srcBlocks);
            }
            HashMap<BlockPos, Entry> dstTileEntries = new HashMap<BlockPos, Entry>();
            vars.put("dstTileEntries", dstTileEntries);
            section = "BreakBlockWithDrop";
            for (BlockPos pos : dstBlocksToBeDestroyed) {
                BlockHelper.breakBlockWithDrop(dstWorld, pos);
            }
            HashSet<Chunk> srcChunks = new HashSet<Chunk>();
            HashSet srcWatchingPlayers = new HashSet();
            HashSet<TileEntity> inventories = new HashSet<TileEntity>();
            vars.put("srcChunks", srcChunks);
            vars.put("srcWatchingPlayers", srcWatchingPlayers);
            vars.put("inventories", inventories);
            section = "Read Data";
            for (BlockLink link : links) {
                TileEntity tile;
                vars.put("Iterator", link);
                dstPos = link.dstPos;
                srcPos = link.srcPos;
                Entry e = new Entry(dstPos);
                e.block = srcWorld.func_147439_a(srcPos.x, srcPos.y, srcPos.z);
                e.meta = srcWorld.func_72805_g(srcPos.x, srcPos.y, srcPos.z);
                e.lightopacity = e.block.getLightOpacity((IBlockAccess)srcWorld, srcPos.x, srcPos.y, srcPos.z);
                e.lightlevel = e.block.getLightValue((IBlockAccess)srcWorld, srcPos.x, srcPos.y, srcPos.z);
                ArrayList axes = new ArrayList();
                e.block.func_149743_a(srcWorld, srcPos.x, srcPos.y, srcPos.z, TileEntity.INFINITE_EXTENT_AABB, (List)axes, null);
                if (axes.size() > 0) {
                    e.bb = new ArrayList<AxisAlignedBB>();
                    Iterator iterator = axes.iterator();
                    while (iterator.hasNext()) {
                        AxisAlignedBB bb = (AxisAlignedBB)iterator.next();
                        e.bb.add(AxisAlignedBB.func_72330_a((double)(bb.field_72340_a - (double)srcPos.x), (double)(bb.field_72338_b - (double)srcPos.y), (double)(bb.field_72339_c - (double)srcPos.z), (double)(bb.field_72336_d - (double)srcPos.x), (double)(bb.field_72337_e - (double)srcPos.y), (double)(bb.field_72334_f - (double)srcPos.z)));
                    }
                }
                NBTTagCompound descriptor = new NBTTagCompound();
                descriptor.func_74768_a("Block", Block.func_149682_b((Block)e.block));
                if (e.meta != 0) {
                    descriptor.func_74774_a("Meta", (byte)e.meta);
                }
                if ((tile = srcWorld.func_147438_o(srcPos.x, srcPos.y, srcPos.z)) != null) {
                    boolean flag = false;
                    for (IDescriptionProxy d : DescriptorRegistry.getProxyList()) {
                        if (!d.canHandleTile(tile)) continue;
                        d.addDescriptionToTags(descriptor, tile);
                        if (!"".equals("DescID")) {
                            descriptor.func_74778_a("DescID", d.getID());
                        }
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        descriptor.func_74757_a("DNR", true);
                    }
                    if (tile instanceof IInventory) {
                        inventories.add(tile);
                    }
                }
                e.description = descriptor;
                srcChunks.add(BlockHelper.getChunk(srcWorld, srcPos));
                dstTileEntries.put(dstPos, e);
            }
            vars.put("Iterator", BLANK);
            section = "LoadTicks";
            for (Chunk c : srcChunks) {
                PlayerManager.PlayerInstance chunkWatcher;
                vars.put("Iterator", c);
                List ticks = srcWorld.func_72920_a(c, false);
                if (ticks != null) {
                    long k = srcWorld.func_82737_E();
                    for (NextTickListEntry tick : ticks) {
                        vars.put("Iterator2", tick);
                        BlockPos p = new BlockPos(tick.field_77183_a, tick.field_77181_b, tick.field_77182_c);
                        if (BlockHelper.getBlock(c, p) != tick.func_151351_a() || !dstTileEntries.containsKey(p = p.advance(dir))) continue;
                        Entry e = (Entry)dstTileEntries.get(p);
                        e.scheduledTickTime = (int)(tick.field_77180_e - k);
                        e.scheduledTickPriority = tick.field_82754_f;
                    }
                }
                if ((chunkWatcher = FLNetwork.getChunkWatcher(c, srcWorld)) == null) continue;
                srcWatchingPlayers.addAll(chunkWatcher.field_73263_b);
            }
            vars.put("Iterator", BLANK);
            vars.put("Iterator2", BLANK);
            section = "destroyBlock";
            for (BlockLink link : links) {
                vars.put("Iterator", link);
                IMoveFactory factory = FactoryRegistry.getFactory(srcWorld, link.srcPos);
                ((Entry)dstTileEntries.get((Object)link.dstPos)).blockTag = factory.destroyBlock(srcWorld, link.srcPos);
            }
            vars.put("Iterator", BLANK);
            section = "closeInventories";
            block12: for (EntityPlayer watchingPlayer : srcWatchingPlayers) {
                vars.put("Iterator", watchingPlayer);
                if (watchingPlayer.field_71070_bA == watchingPlayer.field_71069_bz || watchingPlayer.field_71070_bA == null) continue;
                for (Object o : watchingPlayer.field_71070_bA.field_75151_b) {
                    Slot s = (Slot)o;
                    if (!inventories.contains(s.field_75224_c)) continue;
                    watchingPlayer.func_71053_j();
                    continue block12;
                }
            }
            vars.put("Iterator", BLANK);
            section = "clearTilesSilent";
            for (BlockLink link : links) {
                vars.put("Iterator", link);
                dstPos = link.dstPos;
                srcPos = link.srcPos;
                BlockHelper.silentClear(BlockHelper.getChunk(dstWorld, dstPos), dstPos);
                if (dir != ForgeDirection.UNKNOWN) {
                    FLNetwork.sendToAllWatchingChunk(srcWorld, srcPos.x, srcPos.y, srcPos.z, new MessageClearTile(srcPos));
                }
                dstWorld.func_147475_p(dstPos.x, dstPos.y, dstPos.z);
            }
            vars.put("Iterator", BLANK);
            section = "postUpdateBlock";
            for (BlockPos pos : srcBlocksToBecomeAir) {
                vars.put("Iterator", pos);
                BlockHelper.postUpdateBlock(dstWorld, pos);
            }
            vars.put("Iterator", BLANK);
            ArrayList<TileMovingServer> tiles = new ArrayList<TileMovingServer>();
            vars.put("tiles", tiles);
            section = "createTiles";
            for (Entry e : dstTileEntries.values()) {
                vars.put("Iterator", e);
                dstWorld.func_147465_d(e.pos.x, e.pos.y, e.pos.z, (Block)BlockMoving.instance, 0, 1);
                TileMovingServer tile = (TileMovingServer)dstWorld.func_147438_o(e.pos.x, e.pos.y, e.pos.z);
                vars.put("Iterator2", (Object)tile);
                tile.block = e.blockTag;
                tile.desc = e.description;
                tile.dir = dir.ordinal();
                tile.maxTime = maxTime;
                tile.lightLevel = e.lightlevel;
                tile.lightOpacity = e.lightopacity;
                tile.scheduledTickTime = e.scheduledTickTime;
                tile.scheduledTickPriority = e.scheduledTickPriority;
                if (e.bb != null) {
                    tile.collisions = e.bb.toArray(new AxisAlignedBB[e.bb.size()]);
                }
                tile.isAir = false;
                tiles.add(tile);
            }
            vars.put("Iterator", BLANK);
            vars.put("Iterator2", BLANK);
            section = "createBlankTiles";
            for (BlockLink link : links) {
                vars.put("Iterator", BLANK);
                srcPos = link.srcPos;
                if (srcWorld == dstWorld && dstTileEntries.containsKey(srcPos)) continue;
                srcWorld.func_147465_d(srcPos.x, srcPos.y, srcPos.z, (Block)BlockMoving.instance, 0, 1);
                TileMovingServer tile = (TileMovingServer)srcWorld.func_147438_o(srcPos.x, srcPos.y, srcPos.z);
                vars.put("Iterator2", (Object)tile);
                if (dir != ForgeDirection.UNKNOWN) {
                    tile.block = (NBTTagCompound)airBlockTag.func_74737_b();
                    tile.desc = (NBTTagCompound)airDescTag.func_74737_b();
                    tile.dir = dir.ordinal();
                    tile.maxTime = maxTime;
                    tile.lightLevel = 0;
                    tile.lightOpacity = 0;
                    tile.isAir = true;
                } else {
                    FLNetwork.sendToAllWatchingChunk(srcWorld, srcPos.x, srcPos.y, srcPos.z, new MessageClearTile(srcPos));
                    Entry e = (Entry)dstTileEntries.get(link.dstPos);
                    tile.block = (NBTTagCompound)airBlockTag.func_74737_b();
                    tile.desc = e.description != null ? (NBTTagCompound)e.description.func_74737_b() : (NBTTagCompound)airDescTag.func_74737_b();
                    tile.dir = 7;
                    tile.maxTime = maxTime;
                    tile.lightLevel = e.lightlevel;
                    tile.lightOpacity = e.lightopacity;
                    if (e.bb != null) {
                        tile.collisions = e.bb.toArray(new AxisAlignedBB[e.bb.size()]);
                    }
                    tile.isAir = true;
                }
                tiles.add(tile);
            }
            vars.put("Iterator", BLANK);
            section = "networkUpdateBlocks";
            for (TileMovingServer tile : tiles) {
                vars.put("Iterator", (Object)tile);
                watcher = FLNetwork.getChunkWatcher(tile.func_145831_w(), tile.field_145851_c, tile.field_145849_e);
                if (watcher == null) continue;
                S23PacketBlockChange pkt = new S23PacketBlockChange(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.func_145831_w());
                watcher.func_151251_a((Packet)pkt);
            }
            vars.put("Iterator", BLANK);
            section = "networkUpdateTile";
            for (TileMovingServer tile : tiles) {
                vars.put("Iterator", (Object)tile);
                watcher = FLNetwork.getChunkWatcher(tile.func_145831_w(), tile.field_145851_c, tile.field_145849_e);
                if (watcher == null) continue;
                Packet packet = tile.func_145844_m();
                vars.put("Iterator2", packet);
                if (packet == null) continue;
                watcher.func_151251_a(packet);
            }
            vars.put("Iterator", BLANK);
            vars.put("Iterator2", BLANK);
            section = "DoneIfWeCrashNowThenWhatTheHell";
            MoveManager.clearVars();
        }
        catch (Throwable err) {
            try {
                CrashReport crashReport = MoveManager.buildCrashReport(section, err);
                throw new ReportedException(crashReport);
            }
            catch (Throwable throwable) {
                MoveManager.clearVars();
                throw throwable;
            }
        }
    }

    private static CrashReport buildCrashReport(String section, Throwable err) {
        CrashReport crashReport = CrashReport.func_85055_a((Throwable)err, (String)"FunkyLocomotionMoveCrash");
        CrashReportCategory moveCode = crashReport.func_85058_a("MoveCode");
        moveCode.func_71507_a("Section", (Object)("\"" + section + "\""));
        for (Map.Entry<String, Object> e : vars.entrySet()) {
            Object value = e.getValue();
            if (value == BLANK) continue;
            moveCode.func_71507_a("var_" + e.getKey(), (Object)MoveManager.makeString(value, 0));
        }
        return crashReport;
    }

    private static void clearVars() {
        for (Map.Entry<String, Object> entry : vars.entrySet()) {
            entry.setValue(BLANK);
        }
    }

    public static void finishMoving() {
        MoveManager.clearVars();
        String section = "start";
        try {
            BlockPos pos;
            List<TileMovingServer> tiles = MovingTileRegistry.getTilesFinishedMoving();
            HashSet<Chunk> chunks = new HashSet<Chunk>();
            vars.put("tiles", tiles);
            vars.put("chunks", tiles);
            section = "Clear Tiles";
            for (TileMovingServer tile : tiles) {
                vars.put("tile", (Object)tile);
                chunks.add(tile.func_145831_w().func_72938_d(tile.field_145851_c, tile.field_145849_e));
                tile.func_145831_w().func_147465_d(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, Blocks.field_150350_a, 0, 0);
                tile.func_145831_w().func_147465_d(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, Blocks.field_150348_b, 0, 0);
            }
            vars.put("tile", BLANK);
            section = "Set Block/Tile";
            for (TileMovingServer tile : tiles) {
                pos = new BlockPos(tile);
                vars.put("tile", (Object)tile);
                if (tile.block == null) continue;
                BlockHelper.silentClear(BlockHelper.getChunk(tile.func_145831_w(), pos), pos);
                Block block = Block.func_149684_b((String)tile.block.func_74779_i("Block"));
                vars.put("block", block);
                if (block == null) {
                    block = Blocks.field_150350_a;
                }
                IMoveFactory factory = FactoryRegistry.getFactory(block);
                vars.put("factory", factory);
                factory.recreateBlock(tile.func_145831_w(), pos, tile.block);
            }
            vars.put("tile", BLANK);
            vars.put("block", BLANK);
            vars.put("factory", BLANK);
            section = "Update Blocks";
            for (TileMovingServer tile : tiles) {
                vars.put("tile", (Object)tile);
                pos = new BlockPos(tile);
                BlockHelper.postUpdateBlock(tile.func_145831_w(), pos);
                if (tile.scheduledTickTime == -1) continue;
                tile.func_145831_w().func_147454_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, BlockHelper.getBlock(tile.func_145831_w(), pos), tile.scheduledTickTime - tile.maxTime, tile.scheduledTickPriority);
            }
            vars.put("tile", BLANK);
            section = "Send Update Packets";
            for (Chunk chunk : chunks) {
                vars.put("chunk", chunk);
                chunk.field_76643_l = true;
                FLNetwork.updateChunk(chunk);
            }
            vars.put("chunk", BLANK);
            section = "Redo Activation";
            for (TileMovingServer tile : tiles) {
                EntityPlayer player;
                vars.put("tile", (Object)tile);
                if (tile.activatingPlayer == null || (player = (EntityPlayer)tile.activatingPlayer.get()) == null) continue;
                Block b = BlockHelper.getBlock(tile.func_145831_w(), new BlockPos(tile));
                b.func_149727_a(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, player, tile.activatingSide, tile.activatingHitX, tile.activatingHitY, tile.activatingHitZ);
            }
            vars.put("tile", BLANK);
            section = "Fin";
            MoveManager.clearVars();
        }
        catch (Throwable err) {
            try {
                CrashReport crashReport = MoveManager.buildCrashReport(section, err);
                throw new ReportedException(crashReport);
            }
            catch (Throwable throwable) {
                MoveManager.clearVars();
                throw throwable;
            }
        }
    }

    private static String makeString(Object o, int n) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return (String)o;
        }
        StringBuilder builder = new StringBuilder();
        MoveManager.tabs(n, builder);
        builder.append(o.getClass().getSimpleName());
        builder.append("{");
        if (o instanceof Block) {
            String nameForObject = "" + Block.field_149771_c.func_148750_c(o);
            builder.append(nameForObject);
            builder.append(",");
            builder.append(o.toString());
        } else if (o instanceof TileEntity) {
            try {
                builder.append("tag=");
                NBTTagCompound tag = new NBTTagCompound();
                ((TileEntity)o).func_145841_b(tag);
                builder.append(tag.toString());
            }
            catch (Exception err) {
                builder.append("TE WriteToNBT Crash\n");
                builder.append(err.toString());
            }
        } else if (o instanceof Collection) {
            int i = 0;
            Iterator iterator = ((Iterable)o).iterator();
            builder.append('\n');
            MoveManager.tabs(n, builder);
            while (iterator.hasNext()) {
                builder.append("\t\t").append(i).append("=");
                ++i;
                builder.append(MoveManager.makeString(iterator.next(), n + 1));
                builder.append("\n");
                MoveManager.tabs(n, builder);
            }
        } else {
            builder.append(o.toString());
        }
        builder.append("}");
        return builder.toString();
    }

    private static void tabs(int n, StringBuilder builder) {
        for (int j = 0; j < n; ++j) {
            builder.append('\t');
        }
    }

    static {
        if (Block.func_149682_b((Block)Blocks.field_150350_a) != 0) {
            airDescTag.func_74768_a("Block", Block.func_149682_b((Block)Blocks.field_150350_a));
        }
        vars = new LinkedHashMap(10, 0.2f);
        BLANK = new Object();
    }

    public static class BlockLink {
        BlockPos srcPos;
        BlockPos dstPos;

        public BlockLink(BlockPos srcPos, BlockPos dstPos) {
            this.srcPos = srcPos;
            this.dstPos = dstPos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockLink blockLink = (BlockLink)o;
            if (!this.dstPos.equals(blockLink.dstPos)) {
                return false;
            }
            return this.srcPos.equals(blockLink.srcPos);
        }

        public int hashCode() {
            int result = this.srcPos.hashCode();
            result = 31 * result + this.dstPos.hashCode();
            return result;
        }

        public String toString() {
            return "BlockLink{" + this.srcPos.toString() + ", " + this.dstPos.toString() + '}';
        }
    }

    private static class Entry {
        public int scheduledTickTime = -1;
        public int scheduledTickPriority;
        NBTTagCompound blockTag;
        NBTTagCompound description;
        final BlockPos pos;
        Block block;
        int meta;
        List<AxisAlignedBB> bb = null;
        int lightlevel;
        int lightopacity;

        public Entry(BlockPos pos) {
            this.pos = pos;
        }

        public String toString() {
            return "Entry{scheduledTickTime=" + this.scheduledTickTime + ", scheduledTickPriority=" + this.scheduledTickPriority + ", blockTag=" + this.blockTag + ", description=" + this.description + ", pos=" + this.pos + ", block=" + MoveManager.makeString(this.block, 0) + ", meta=" + this.meta + ", bb=" + MoveManager.makeString(this.bb, 0) + ", lightlevel=" + this.lightlevel + ", lightopacity=" + this.lightopacity + '}';
        }
    }
}

