/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.rendering;

import com.rwtema.funkylocomotion.blocks.BlockMoving;
import com.rwtema.funkylocomotion.blocks.TileMovingClient;
import com.rwtema.funkylocomotion.fakes.FakeWorldClient;
import com.rwtema.funkylocomotion.rendering.FLRenderHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.shader.TesselatorVertexState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class TileEntityRenderMoving
extends TileEntitySpecialRenderer {
    private RenderBlocks renderBlocks;
    private World world;
    private FakeWorldClient fakeWorldClient;

    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        if (!(tile instanceof TileMovingClient)) {
            return;
        }
        TileMovingClient mover = (TileMovingClient)tile;
        if (!mover.init) {
            return;
        }
        if (mover.maxTime == 0 || mover.block == Blocks.field_150350_a) {
            return;
        }
        double h = mover.offset(true);
        int dir = mover.dir;
        if (dir == -1) {
            return;
        }
        this.func_147499_a(TextureMap.field_110575_b);
        boolean flag = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        int pass = MinecraftForgeClient.getRenderPass();
        if (mover.render && mover.block.canRenderInPass(pass) && mover.block.func_149645_b() >= 0) {
            GL11.glPushMatrix();
            this.setupTranslations(x, y, z, mover, h, dir);
            flag = this.renderStatic(mover, pass);
            GL11.glPopMatrix();
            GL11.glEnable((int)2884);
        }
        flag |= this.renderDynamic(x, y, z, f, mover, h, dir, pass);
        if (pass == 0) {
            mover.failedToRenderInFirstPass = !flag;
        } else if (!flag && mover.failedToRenderInFirstPass) {
            GL11.glPushMatrix();
            this.setupTranslations(x, y, z, mover, h, dir);
            RenderHelper.func_74518_a();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            if (Minecraft.func_71379_u()) {
                GL11.glShadeModel((int)7425);
            } else {
                GL11.glShadeModel((int)7424);
            }
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            tessellator.func_78382_b();
            this.renderBlocks.func_147757_a(mover.error ? BlockMoving.crate_error : BlockMoving.crate);
            this.renderBlocks.func_147805_b(Blocks.field_150348_b, mover.field_145851_c, mover.field_145848_d, mover.field_145849_e);
            this.renderBlocks.func_147771_a();
            mover.cachedState[0] = TileEntityRenderMoving.leadVertexState();
            mover.skipPass[0] = false;
            mover.cachedState[1] = null;
            mover.skipPass[1] = true;
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            RenderHelper.func_74519_b();
        }
    }

    private void setupTranslations(double x, double y, double z, TileMovingClient mover, double h, int dir) {
        if (dir < 6) {
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glTranslated((double)(-mover.field_145851_c), (double)(-mover.field_145848_d), (double)(-mover.field_145849_e));
            GL11.glTranslated((double)((double)Facing.field_71586_b[dir] * h), (double)((double)Facing.field_71587_c[dir] * h), (double)((double)Facing.field_71585_d[dir] * h));
        } else {
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            double dh = dir == 6 ? h + 1.0 : -h;
            GL11.glScaled((double)dh, (double)dh, (double)dh);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            GL11.glTranslated((double)(-mover.field_145851_c), (double)(-mover.field_145848_d), (double)(-mover.field_145849_e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renderDynamic(double x, double y, double z, float f, TileMovingClient mover, double h, int dir, int pass) {
        if (mover.tile == null || !mover.tile.shouldRenderInPass(pass)) {
            return false;
        }
        if (this.fakeWorldClient == null && !this.createCache()) {
            return false;
        }
        TileEntitySpecialRenderer specialRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(mover.tile);
        if (specialRenderer == null) {
            return false;
        }
        GL11.glPushMatrix();
        this.setupTranslations(x, y, z, mover, h, dir);
        try {
            specialRenderer.func_147496_a((World)this.fakeWorldClient);
            WorldClient prevWorld1 = Minecraft.func_71410_x().field_71441_e;
            World prevWorld2 = Minecraft.func_71410_x().field_71439_g.field_70170_p;
            try {
                Minecraft.func_71410_x().field_71441_e = this.fakeWorldClient;
                Minecraft.func_71410_x().field_71439_g.field_70170_p = this.fakeWorldClient;
                specialRenderer.func_147500_a(mover.tile, (double)mover.field_145851_c, (double)mover.field_145848_d, (double)mover.field_145849_e, f);
            }
            finally {
                Minecraft.func_71410_x().field_71441_e = prevWorld1;
                Minecraft.func_71410_x().field_71439_g.field_70170_p = prevWorld2;
            }
            specialRenderer.func_147496_a(this.world);
        }
        catch (Exception e) {
            FLRenderHelper.clearTessellator();
            new RuntimeException("Unable to render TSER " + mover.tile.getClass().getName() + " for " + Block.field_149771_c.func_148750_c((Object)mover.block) + " with meta " + mover.meta + " at (" + mover.field_145851_c + "," + mover.field_145848_d + mover.field_145849_e + "). Disabling Rendering.", e).printStackTrace();
            TileMovingClient.renderErrorList.add(mover.tile.getClass());
            mover.error = true;
            mover.tile = null;
            mover.render = false;
        }
        GL11.glPopMatrix();
        return true;
    }

    protected boolean renderStatic(TileMovingClient mover, int pass) {
        if (mover.skipPass[pass]) {
            return true;
        }
        RenderHelper.func_74518_a();
        if (pass != 0) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        GL11.glEnable((int)2884);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        if (mover.cachedState[pass] != null) {
            tessellator.func_78382_b();
            tessellator.func_147565_a(mover.cachedState[pass]);
            tessellator.func_78381_a();
        } else {
            tessellator.func_78382_b();
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            mover.cachedState[pass] = null;
            mover.skipPass[pass] = true;
            try {
                if (this.renderBlocks.func_147805_b(mover.block, mover.field_145851_c, mover.field_145848_d, mover.field_145849_e) && tessellator.field_147569_p > 0) {
                    mover.cachedState[pass] = TileEntityRenderMoving.leadVertexState();
                    mover.skipPass[pass] = false;
                }
            }
            catch (Exception e) {
                new RuntimeException("Unable to render block " + Block.field_149771_c.func_148750_c((Object)mover.block) + " with meta " + mover.meta + " at (" + mover.field_145851_c + "," + mover.field_145848_d + mover.field_145849_e + "). Disabling Rendering.", e).printStackTrace();
                TileMovingClient.renderErrorList.add(mover.block.getClass());
                mover.tile = null;
                mover.render = false;
                mover.error = true;
                mover.cachedState[pass] = null;
                mover.skipPass[pass] = true;
            }
            tessellator.func_78381_a();
        }
        RenderHelper.func_74519_b();
        return true;
    }

    private static TesselatorVertexState leadVertexState() {
        return Tessellator.field_78398_a.func_147564_a((float)Minecraft.func_71410_x().field_71439_g.field_70165_t, (float)Minecraft.func_71410_x().field_71439_g.field_70163_u, (float)Minecraft.func_71410_x().field_71439_g.field_70161_v);
    }

    public void func_147496_a(World world) {
        this.world = world;
        this.createCache();
    }

    private boolean createCache() {
        if (!FakeWorldClient.isValid(this.world)) {
            this.fakeWorldClient = null;
            this.renderBlocks = null;
            return false;
        }
        this.fakeWorldClient = FakeWorldClient.getFakeWorldWrapper(this.world);
        this.renderBlocks = new RenderBlocks((IBlockAccess)this.fakeWorldClient);
        return true;
    }
}

