/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.thaumcraft;

import com.rwtema.funkylocomotion.factory.DefaultMoveFactory;
import framesapi.BlockPos;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;

public class NodeMover
extends DefaultMoveFactory {
    @Override
    protected NBTTagCompound saveTile(BlockPos pos, Chunk chunk, NBTTagCompound tag) {
        TileEntity tile = chunk.getTileEntityUnsafe(pos.x & 0xF, pos.y, pos.z & 0xF);
        if (tile == null) {
            return null;
        }
        NBTTagCompound tagCompound = super.saveTile(pos, chunk, tag);
        tag.func_74768_a("OldDim", chunk.field_76637_e.field_73011_w.field_76574_g);
        tag.func_74768_a("OldPosX", pos.x);
        tag.func_74768_a("OldPosY", pos.y);
        tag.func_74768_a("OldPosZ", pos.z);
        return tagCompound;
    }

    @Override
    protected TileEntity loadTile(BlockPos pos, NBTTagCompound tag, Chunk chunk) {
        TileEntity tileEntity = super.loadTile(pos, tag, chunk);
        if (tileEntity instanceof INode) {
            if (tag.func_74762_e("OldDim") == chunk.field_76637_e.field_73011_w.field_76574_g && Math.abs(pos.x - tag.func_74762_e("OldPosX")) + Math.abs(pos.y - tag.func_74762_e("OldPosY")) + Math.abs(pos.z - tag.func_74762_e("OldPosZ")) <= 1) {
                return tileEntity;
            }
            INode node = (INode)tileEntity;
            NodeModifier nodeModifier = node.getNodeModifier();
            if (nodeModifier == NodeModifier.PALE) {
                node.setNodeModifier(NodeModifier.FADING);
            } else if (nodeModifier != NodeModifier.FADING) {
                node.setNodeModifier(NodeModifier.PALE);
            }
        }
        return tileEntity;
    }
}

