/*
 * Decompiled with CFR 0.152.
 */
package extracells.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import extracells.api.IPortableFluidStorageCell;
import extracells.api.IWirelessFluidTermHandler;
import extracells.container.IStorageContainer;
import extracells.container.slot.SlotPlayerInventory;
import extracells.container.slot.SlotRespective;
import extracells.gui.GuiFluidStorage;
import extracells.gui.widget.fluid.IFluidSelectorContainer;
import extracells.inventory.HandlerItemStorageFluid;
import extracells.network.packet.part.PacketFluidStorage;
import extracells.util.FluidUtil;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;

public class ContainerFluidStorage
extends Container
implements IMEMonitorHandlerReceiver<IAEFluidStack>,
IFluidSelectorContainer,
IInventoryUpdateReceiver,
IStorageContainer {
    private GuiFluidStorage guiFluidStorage;
    private IItemList<IAEFluidStack> fluidStackList;
    private Fluid selectedFluid;
    private IAEFluidStack selectedFluidStack;
    private EntityPlayer player;
    private IMEMonitor<IAEFluidStack> monitor;
    private HandlerItemStorageFluid storageFluid;
    private IWirelessFluidTermHandler handler = null;
    private IPortableFluidStorageCell storageCell = null;
    public boolean hasWirelessTermHandler = false;
    private ECPrivateInventory inventory = new ECPrivateInventory("extracells.item.fluid.storage", 2, 64, this){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return FluidUtil.isFluidContainer(itemStack);
        }
    };

    public ContainerFluidStorage(EntityPlayer _player) {
        this(null, _player);
    }

    public ContainerFluidStorage(IMEMonitor<IAEFluidStack> _monitor, EntityPlayer _player) {
        this.monitor = _monitor;
        this.player = _player;
        if (!this.player.field_70170_p.field_72995_K && this.monitor != null) {
            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            this.fluidStackList = this.monitor.getStorageList();
        } else {
            this.fluidStackList = AEApi.instance().storage().createFluidList();
        }
        this.func_75146_a(new SlotRespective(this.inventory, 0, 8, 92));
        this.func_75146_a((Slot)new SlotFurnace(this.player, (IInventory)this.inventory, 1, 26, 92));
        this.bindPlayerInventory(this.player.field_71071_by);
    }

    public ContainerFluidStorage(IMEMonitor<IAEFluidStack> _monitor, EntityPlayer _player, IPortableFluidStorageCell _storageCell) {
        this.hasWirelessTermHandler = _storageCell != null;
        this.storageCell = _storageCell;
        this.monitor = _monitor;
        this.player = _player;
        if (!this.player.field_70170_p.field_72995_K && this.monitor != null) {
            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            this.fluidStackList = this.monitor.getStorageList();
        } else {
            this.fluidStackList = AEApi.instance().storage().createFluidList();
        }
        this.func_75146_a(new SlotRespective(this.inventory, 0, 8, 92));
        this.func_75146_a((Slot)new SlotFurnace(this.player, (IInventory)this.inventory, 1, 26, 92));
        this.bindPlayerInventory(this.player.field_71071_by);
    }

    public ContainerFluidStorage(IMEMonitor<IAEFluidStack> _monitor, EntityPlayer _player, IWirelessFluidTermHandler _handler) {
        this.hasWirelessTermHandler = _handler != null;
        this.handler = _handler;
        this.monitor = _monitor;
        this.player = _player;
        if (!this.player.field_70170_p.field_72995_K && this.monitor != null) {
            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            this.fluidStackList = this.monitor.getStorageList();
        } else {
            this.fluidStackList = AEApi.instance().storage().createFluidList();
        }
        this.func_75146_a(new SlotRespective(this.inventory, 0, 8, 92));
        this.func_75146_a((Slot)new SlotFurnace(this.player, (IInventory)this.inventory, 1, 26, 92));
        this.bindPlayerInventory(this.player.field_71071_by);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotPlayerInventory((IInventory)inventoryPlayer, this, j + i * 9 + 9, 8 + j * 18, i * 18 + 122));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotPlayerInventory((IInventory)inventoryPlayer, this, i, 8 + i * 18, 180));
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void decreaseFirstSlot() {
        ItemStack slot = this.inventory.func_70301_a(0);
        if (slot == null) {
            return;
        }
        --slot.field_77994_a;
        if (slot.field_77994_a <= 0) {
            this.inventory.func_70299_a(0, null);
        }
    }

    public void doWork() {
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot != null && secondSlot.field_77994_a > secondSlot.func_77976_d()) {
            return;
        }
        ItemStack container = this.inventory.func_70301_a(0);
        if (!FluidUtil.isFluidContainer(container)) {
            return;
        }
        if (this.monitor == null) {
            return;
        }
        container = container.func_77946_l();
        container.field_77994_a = 1;
        if (FluidUtil.isEmpty(container)) {
            int proposedAmount;
            if (this.selectedFluid == null) {
                return;
            }
            int capacity = FluidUtil.getCapacity(container);
            IAEFluidStack result = (IAEFluidStack)this.monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.selectedFluid, (long)capacity), Actionable.SIMULATE, (BaseActionSource)new PlayerSource(this.player, null));
            int n = proposedAmount = result == null ? 0 : (int)Math.min((long)capacity, result.getStackSize());
            if (proposedAmount == 0) {
                return;
            }
            MutablePair<Integer, ItemStack> filledContainer = FluidUtil.fillStack(container, new FluidStack(this.selectedFluid, proposedAmount));
            if (this.fillSecondSlot((ItemStack)filledContainer.getRight())) {
                this.monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.selectedFluid, (long)((Integer)filledContainer.getLeft()).intValue()), Actionable.MODULATE, (BaseActionSource)new PlayerSource(this.player, null));
                this.decreaseFirstSlot();
            }
        } else if (FluidUtil.isFilled(container)) {
            FluidStack containerFluid = FluidUtil.getFluidFromContainer(container);
            IAEFluidStack notInjected = (IAEFluidStack)this.monitor.injectItems((IAEStack)FluidUtil.createAEFluidStack(containerFluid), Actionable.SIMULATE, (BaseActionSource)new PlayerSource(this.player, null));
            if (notInjected != null) {
                return;
            }
            if (this.handler != null) {
                if (!this.handler.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                    return;
                }
                this.handler.usePower(this.player, 20.0, this.player.func_71045_bC());
            } else if (this.storageCell != null) {
                if (!this.storageCell.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                    return;
                }
                this.storageCell.usePower(this.player, 20.0, this.player.func_71045_bC());
            }
            MutablePair<Integer, ItemStack> drainedContainer = FluidUtil.drainStack(container, containerFluid);
            if (this.fillSecondSlot((ItemStack)drainedContainer.getRight())) {
                this.monitor.injectItems((IAEStack)FluidUtil.createAEFluidStack(containerFluid), Actionable.MODULATE, (BaseActionSource)new PlayerSource(this.player, null));
                this.decreaseFirstSlot();
            }
        }
    }

    public boolean fillSecondSlot(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot == null) {
            if (this.handler != null) {
                if (!this.handler.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                    return false;
                }
                this.handler.usePower(this.player, 20.0, this.player.func_71045_bC());
            } else if (this.storageCell != null) {
                if (!this.storageCell.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                    return false;
                }
                this.storageCell.usePower(this.player, 20.0, this.player.func_71045_bC());
            }
            this.inventory.func_70299_a(1, itemStack);
            return true;
        }
        if (!secondSlot.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)secondSlot)) {
            return false;
        }
        if (this.handler != null) {
            if (!this.handler.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                return false;
            }
            this.handler.usePower(this.player, 20.0, this.player.func_71045_bC());
        } else if (this.storageCell != null) {
            if (!this.storageCell.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                return false;
            }
            this.storageCell.usePower(this.player, 20.0, this.player.func_71045_bC());
        }
        this.inventory.incrStackSize(1, itemStack.field_77994_a);
        return true;
    }

    public void forceFluidUpdate() {
        if (this.monitor != null) {
            new PacketFluidStorage(this.player, (IItemList<IAEFluidStack>)this.monitor.getStorageList()).sendPacketToPlayer(this.player);
        }
        new PacketFluidStorage(this.player, this.hasWirelessTermHandler).sendPacketToPlayer(this.player);
    }

    public IItemList<IAEFluidStack> getFluidStackList() {
        return this.fluidStackList;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public Fluid getSelectedFluid() {
        return this.selectedFluid;
    }

    public IAEFluidStack getSelectedFluidStack() {
        return this.selectedFluidStack;
    }

    @Override
    public boolean hasWirelessTermHandler() {
        return this.hasWirelessTermHandler;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void func_75134_a(EntityPlayer entityPlayer) {
        super.func_75134_a(entityPlayer);
        if (!entityPlayer.field_70170_p.field_72995_K) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
            for (int i = 0; i < 2; ++i) {
                this.player.func_71019_a(((Slot)this.field_75151_b.get(i)).func_75211_c(), false);
            }
        }
    }

    @Override
    public void onInventoryChanged() {
    }

    public void onListUpdate() {
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        this.fluidStackList = ((IMEMonitor)monitor).getStorageList();
        new PacketFluidStorage(this.player, this.fluidStackList).sendPacketToPlayer(this.player);
        new PacketFluidStorage(this.player, this.hasWirelessTermHandler).sendPacketToPlayer(this.player);
    }

    public void receiveSelectedFluid(Fluid _selectedFluid) {
        this.selectedFluid = _selectedFluid;
        if (this.selectedFluid != null) {
            for (IAEFluidStack stack : this.fluidStackList) {
                if (stack == null || stack.getFluid() != this.selectedFluid) continue;
                this.selectedFluidStack = stack;
                break;
            }
        } else {
            this.selectedFluidStack = null;
        }
        if (this.guiFluidStorage != null) {
            this.guiFluidStorage.updateSelectedFluid();
        }
    }

    public void removeEnergyTick() {
        if (this.handler != null) {
            if (this.handler.hasPower(this.player, 1.0, this.player.func_71045_bC())) {
                this.handler.usePower(this.player, 1.0, this.player.func_71045_bC());
            }
        } else if (this.storageCell != null && this.storageCell.hasPower(this.player, 0.5, this.player.func_71045_bC())) {
            this.storageCell.usePower(this.player, 0.5, this.player.func_71045_bC());
        }
    }

    public void setGui(GuiFluidStorage _guiFluidStorage) {
        this.guiFluidStorage = _guiFluidStorage;
    }

    @Override
    public void setSelectedFluid(Fluid _selectedFluid) {
        new PacketFluidStorage(this.player, _selectedFluid).sendPacketToServer();
        this.receiveSelectedFluid(_selectedFluid);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotnumber) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotnumber);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (this.inventory.func_94041_b(0, itemstack1)) {
                if (slotnumber == 0 || slotnumber == 1 ? !this.func_75135_a(itemstack1, 2, 36, false) : !this.func_75135_a(itemstack1, 0, 1, false)) {
                    return null;
                }
                if (itemstack1.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
            } else {
                return null;
            }
        }
        return itemstack;
    }

    public void updateFluidList(IItemList<IAEFluidStack> _fluidStackList) {
        this.fluidStackList = _fluidStackList;
        if (this.guiFluidStorage != null) {
            this.guiFluidStorage.updateFluids();
        }
    }
}

