/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.api.IFluidInterface;
import extracells.api.crafting.IFluidCraftingPatternDetails;
import extracells.container.ContainerFluidInterface;
import extracells.container.IContainerListener;
import extracells.crafting.CraftingPattern;
import extracells.crafting.CraftingPattern2;
import extracells.gui.GuiFluidInterface;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.part.PartECBase;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import extracells.render.TextureManager;
import extracells.util.EmptyMeItemMonitor;
import extracells.util.ItemUtils;
import extracells.util.PermissionUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class PartFluidInterface
extends PartECBase
implements IFluidHandler,
IFluidInterface,
IFluidSlotPartOrBlock,
ITileStorageMonitorable,
IStorageMonitorable,
IGridTickable,
ICraftingProvider {
    List<IContainerListener> listeners = new ArrayList<IContainerListener>();
    private List<ICraftingPatternDetails> patternHandlers = new ArrayList<ICraftingPatternDetails>();
    private HashMap<ICraftingPatternDetails, IFluidCraftingPatternDetails> patternConvert = new HashMap();
    private List<IAEItemStack> requestedItems = new ArrayList<IAEItemStack>();
    private List<IAEItemStack> removeList = new ArrayList<IAEItemStack>();
    public final FluidInterfaceInventory inventory = new FluidInterfaceInventory();
    private boolean update = false;
    private List<IAEStack> export = new ArrayList<IAEStack>();
    private List<IAEStack> removeFromExport = new ArrayList<IAEStack>();
    private List<IAEStack> addToExport = new ArrayList<IAEStack>();
    private IAEItemStack toExport = null;
    private final Item encodedPattern = (Item)AEApi.instance().definitions().items().encodedPattern().maybeItem().orNull();
    private FluidTank tank = new FluidTank(10000){

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            if (!nbt.func_74764_b("Empty")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                this.setFluid(fluid);
            } else {
                this.setFluid(null);
            }
            return this;
        }
    };
    private int fluidFilter = -1;
    public boolean doNextUpdate = false;
    private boolean needBreake = false;
    private int tickCount = 0;

    @Override
    public int cableConnectionRenderTo() {
        return 3;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid != null && tankFluid.getFluid() == fluid;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.fill(new FluidStack(fluid, 1), false) > 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack tankFluid = this.tank.getFluid();
        if (resource == null || tankFluid == null || tankFluid.getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drained = this.tank.drain(maxDrain, doDrain);
        if (drained != null) {
            this.getHost().markForUpdate();
        }
        this.doNextUpdate = true;
        return drained;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if ((this.tank.getFluid() == null || this.tank.getFluid().getFluid() == resource.getFluid()) && resource.getFluid() == FluidRegistry.getFluid((int)this.fluidFilter)) {
            int added = this.tank.fill(resource.copy(), doFill);
            if (added == resource.amount) {
                this.doNextUpdate = true;
                return added;
            }
            added += this.fillToNetwork(new FluidStack(resource.getFluid(), resource.amount - added), doFill);
            this.doNextUpdate = true;
            return added;
        }
        int filled = 0;
        if ((filled += this.fillToNetwork(resource, doFill)) < resource.amount) {
            filled += this.tank.fill(new FluidStack(resource.getFluid(), resource.amount - filled), doFill);
        }
        if (filled > 0) {
            this.getHost().markForUpdate();
        }
        this.doNextUpdate = true;
        return filled;
    }

    public int fillToNetwork(FluidStack resource, boolean doFill) {
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (node == null || resource == null) {
            return 0;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return 0;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return 0;
        }
        FluidStack copy = resource.copy();
        IAEFluidStack notRemoved = doFill ? (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(resource), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this)) : (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(resource), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        if (notRemoved == null) {
            return resource.amount;
        }
        return (int)((long)resource.amount - notRemoved.getStackSize());
    }

    private void forceUpdate() {
        this.getHost().markForUpdate();
        for (IContainerListener listener : this.listeners) {
            if (listener == null) continue;
            listener.updateContainer();
        }
        this.doNextUpdate = false;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiFluidInterface(player, this, this.getSide());
    }

    @SideOnly(value=Side.CLIENT)
    private World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack pattern = this.inventory.func_70301_a(i);
            if (pattern == null) continue;
            drops.add(pattern);
        }
    }

    @Override
    public Fluid getFilter(ForgeDirection side) {
        return FluidRegistry.getFluid((int)this.fluidFilter);
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        if (this.getGridNode(ForgeDirection.UNKNOWN) == null) {
            return null;
        }
        IGrid grid = this.getGridNode(ForgeDirection.UNKNOWN).getGrid();
        if (grid == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return null;
        }
        return storage.getFluidInventory();
    }

    @Override
    public IFluidTank getFluidTank(ForgeDirection side) {
        return this.tank;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return new EmptyMeItemMonitor();
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        ItemStack is = new ItemStack(ItemEnum.PARTITEM.getItem(), 1, PartEnum.getPartID(this));
        if (type != PartItemStack.Break) {
            is.func_77982_d(this.writeFilter(new NBTTagCompound()));
        }
        return is;
    }

    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src) {
        return this;
    }

    @Override
    public IInventory getPatternInventory() {
        return this.inventory;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerFluidInterface(player, this);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 40, false, false);
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound tag, List<String> list) {
        FluidStack fluid = null;
        int id = -1;
        int amount = 0;
        if (tag.func_74764_b("fluidID") && tag.func_74764_b("amount")) {
            id = tag.func_74762_e("fluidID");
            amount = tag.func_74762_e("amount");
        }
        if (id != -1) {
            fluid = new FluidStack(id, amount);
        }
        if (fluid == null) {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + StatCollector.func_74838_a((String)"extracells.tooltip.empty1"));
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": 0mB / 10000mB");
        } else {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + fluid.getLocalizedName());
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": " + fluid.amount + "mB / 10000mB");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        if (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null) {
            tag.func_74768_a("fluidID", -1);
        } else {
            tag.func_74768_a("fluidID", this.tank.getFluid().getFluidID());
        }
        tag.func_74768_a("amount", this.tank.getFluidAmount());
        return tag;
    }

    @Override
    public void initializePart(ItemStack partStack) {
        if (partStack.func_77942_o()) {
            this.readFilter(partStack.func_77978_p());
        }
    }

    public boolean isBusy() {
        return !this.export.isEmpty();
    }

    private ItemStack makeCraftingPatternItem(ICraftingPatternDetails details) {
        if (details == null) {
            return null;
        }
        NBTTagList in = new NBTTagList();
        NBTTagList out = new NBTTagList();
        for (IAEItemStack s : details.getInputs()) {
            if (s == null) {
                in.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            in.func_74742_a((NBTBase)s.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        for (IAEItemStack s : details.getOutputs()) {
            if (s == null) {
                out.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            out.func_74742_a((NBTBase)s.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        NBTTagCompound itemTag = new NBTTagCompound();
        itemTag.func_74782_a("in", (NBTBase)in);
        itemTag.func_74782_a("out", (NBTBase)out);
        itemTag.func_74757_a("crafting", details.isCraftable());
        ItemStack pattern = new ItemStack(this.encodedPattern);
        pattern.func_77982_d(itemTag);
        return pattern;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, pos);
        }
        return false;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.patternHandlers = new ArrayList<ICraftingPatternDetails>();
        this.patternConvert.clear();
        for (ItemStack currentPatternStack : this.inventory.inv) {
            ICraftingPatternItem currentPattern;
            if (currentPatternStack == null || currentPatternStack.func_77973_b() == null || !(currentPatternStack.func_77973_b() instanceof ICraftingPatternItem) || (currentPattern = (ICraftingPatternItem)currentPatternStack.func_77973_b()) == null || currentPattern.getPatternForItem(currentPatternStack, this.getGridNode().getWorld()) == null) continue;
            CraftingPattern2 pattern = new CraftingPattern2(currentPattern.getPatternForItem(currentPatternStack, this.getGridNode().getWorld()));
            this.patternHandlers.add(pattern);
            ItemStack is = this.makeCraftingPatternItem(pattern);
            if (is == null) continue;
            ICraftingPatternDetails p = ((ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getGridNode().getWorld());
            this.patternConvert.put(p, pattern);
            craftingTracker.addCraftingOption((ICraftingMedium)this, p);
        }
    }

    private void pushItems() {
        for (IAEStack s : this.removeFromExport) {
            this.export.remove(s);
        }
        this.removeFromExport.clear();
        for (IAEStack s : this.addToExport) {
            this.export.add(s);
        }
        this.addToExport.clear();
        if (this.getGridNode().getWorld() == null || this.export.isEmpty()) {
            return;
        }
        ForgeDirection dir = this.getSide();
        TileEntity tile = this.getGridNode().getWorld().func_147438_o(this.getGridNode().getGridBlock().getLocation().x + dir.offsetX, this.getGridNode().getGridBlock().getLocation().y + dir.offsetY, this.getGridNode().getGridBlock().getLocation().z + dir.offsetZ);
        if (tile != null) {
            IAEStack stack0 = this.export.iterator().next();
            IAEStack stack = stack0.copy();
            if (stack instanceof IAEItemStack && tile instanceof IInventory) {
                if (tile instanceof ISidedInventory) {
                    ISidedInventory inv = (ISidedInventory)tile;
                    for (int i : inv.func_94128_d(dir.getOpposite().ordinal())) {
                        if (!inv.func_102007_a(i, ((IAEItemStack)stack).getItemStack(), dir.getOpposite().ordinal())) continue;
                        if (inv.func_70301_a(i) == null) {
                            inv.func_70299_a(i, ((IAEItemStack)stack).getItemStack());
                            this.removeFromExport.add(stack0);
                            return;
                        }
                        if (!ItemUtils.areItemEqualsIgnoreStackSize(inv.func_70301_a(i), ((IAEItemStack)stack).getItemStack())) continue;
                        int max = inv.func_70297_j_();
                        int current = inv.func_70301_a((int)i).field_77994_a;
                        int outStack = (int)stack.getStackSize();
                        if (max == current) continue;
                        if (current + outStack <= max) {
                            ItemStack s = inv.func_70301_a(i).func_77946_l();
                            s.field_77994_a += outStack;
                            inv.func_70299_a(i, s);
                            this.removeFromExport.add(stack0);
                            return;
                        }
                        ItemStack s = inv.func_70301_a(i).func_77946_l();
                        s.field_77994_a = max;
                        inv.func_70299_a(i, s);
                        this.removeFromExport.add(stack0);
                        stack.setStackSize((long)(outStack - max + current));
                        this.addToExport.add(stack);
                        return;
                    }
                } else {
                    IInventory inv = (IInventory)tile;
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        if (!inv.func_94041_b(i, ((IAEItemStack)stack).getItemStack())) continue;
                        if (inv.func_70301_a(i) == null) {
                            inv.func_70299_a(i, ((IAEItemStack)stack).getItemStack());
                            this.removeFromExport.add(stack0);
                            return;
                        }
                        if (!ItemUtils.areItemEqualsIgnoreStackSize(inv.func_70301_a(i), ((IAEItemStack)stack).getItemStack())) continue;
                        int max = inv.func_70297_j_();
                        int current = inv.func_70301_a((int)i).field_77994_a;
                        int outStack = (int)stack.getStackSize();
                        if (max == current) continue;
                        if (current + outStack <= max) {
                            ItemStack s = inv.func_70301_a(i).func_77946_l();
                            s.field_77994_a += outStack;
                            inv.func_70299_a(i, s);
                            this.removeFromExport.add(stack0);
                            return;
                        }
                        ItemStack s = inv.func_70301_a(i).func_77946_l();
                        s.field_77994_a = max;
                        inv.func_70299_a(i, s);
                        this.removeFromExport.add(stack0);
                        stack.setStackSize((long)(outStack - max + current));
                        this.addToExport.add(stack);
                        return;
                    }
                }
            } else if (stack instanceof IAEFluidStack && tile instanceof IFluidHandler) {
                IFluidHandler handler = (IFluidHandler)tile;
                IAEFluidStack fluid = (IAEFluidStack)stack;
                if (handler.canFill(dir.getOpposite(), fluid.copy().getFluid())) {
                    int amount = handler.fill(dir.getOpposite(), fluid.getFluidStack().copy(), false);
                    if (amount == 0) {
                        return;
                    }
                    if ((long)amount == fluid.getStackSize()) {
                        handler.fill(dir.getOpposite(), fluid.getFluidStack().copy(), true);
                        this.removeFromExport.add(stack0);
                    } else {
                        IAEFluidStack f = fluid.copy();
                        f.setStackSize(f.getStackSize() - (long)amount);
                        FluidStack fl = fluid.getFluidStack().copy();
                        fl.amount = amount;
                        handler.fill(dir.getOpposite(), fl, true);
                        this.removeFromExport.add(stack0);
                        this.addToExport.add((IAEStack)f);
                        return;
                    }
                }
            }
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patDetails, InventoryCrafting table) {
        if (this.isBusy() || !this.patternConvert.containsKey(patDetails)) {
            return false;
        }
        ICraftingPatternDetails patternDetails = this.patternConvert.get(patDetails);
        if (patternDetails instanceof CraftingPattern) {
            IAEFluidStack extractFluid;
            Long amount;
            CraftingPattern patter = (CraftingPattern)patternDetails;
            HashMap<Fluid, Long> fluids = new HashMap<Fluid, Long>();
            for (IAEFluidStack stack : patter.getCondensedFluidInputs()) {
                if (fluids.containsKey(stack.getFluid())) {
                    amount = (Long)fluids.get(stack.getFluid()) + stack.getStackSize();
                    fluids.remove(stack.getFluid());
                    fluids.put(stack.getFluid(), amount);
                    continue;
                }
                fluids.put(stack.getFluid(), stack.getStackSize());
            }
            IGrid grid = this.getGridNode().getGrid();
            if (grid == null) {
                return false;
            }
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            if (storage == null) {
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(fluid, (int)(amount + 0L))), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (extractFluid != null && extractFluid.getStackSize() == amount.longValue()) continue;
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(fluid, (int)(amount + 0L))), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                this.export.add((IAEStack)extractFluid);
            }
            for (IAEItemStack s : patter.getCondensedInputs()) {
                if (s == null) continue;
                if (s.getItem() == ItemEnum.FLUIDPATTERN.getItem()) {
                    this.toExport = s.copy();
                    continue;
                }
                this.export.add((IAEStack)s);
            }
        }
        return true;
    }

    public void readFilter(NBTTagCompound tag) {
        if (tag.func_74764_b("filter")) {
            this.fluidFilter = tag.func_74762_e("filter");
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("tank")) {
            this.tank.readFromNBT(data.func_74775_l("tank"));
        }
        if (data.func_74764_b("filter")) {
            this.fluidFilter = data.func_74762_e("filter");
        }
        if (data.func_74764_b("inventory")) {
            this.inventory.readFromNBT(data.func_74775_l("inventory"));
        }
        if (data.func_74764_b("export")) {
            this.readOutputFromNBT(data.func_74775_l("export"));
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)data);
        if (tag.func_74764_b("tank")) {
            this.tank.readFromNBT(tag.func_74775_l("tank"));
        }
        if (tag.func_74764_b("filter")) {
            this.fluidFilter = tag.func_74762_e("filter");
        }
        if (tag.func_74764_b("inventory")) {
            this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        }
        return true;
    }

    private void readOutputFromNBT(NBTTagCompound tag) {
        IAEItemStack s;
        int j;
        this.addToExport.clear();
        this.removeFromExport.clear();
        this.export.clear();
        int i = tag.func_74762_e("remove");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("remove-" + j + "-isItem")) {
                s = AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("remove-" + j)));
                s.setStackSize(tag.func_74763_f("remove-" + j + "-amount"));
                this.removeFromExport.add((IAEStack)s);
                continue;
            }
            s = AEApi.instance().storage().createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("remove-" + j)));
            s.setStackSize(tag.func_74763_f("remove-" + j + "-amount"));
            this.removeFromExport.add((IAEStack)s);
        }
        i = tag.func_74762_e("add");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("add-" + j + "-isItem")) {
                s = AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("add-" + j)));
                s.setStackSize(tag.func_74763_f("add-" + j + "-amount"));
                this.addToExport.add((IAEStack)s);
                continue;
            }
            s = AEApi.instance().storage().createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("add-" + j)));
            s.setStackSize(tag.func_74763_f("add-" + j + "-amount"));
            this.addToExport.add((IAEStack)s);
        }
        i = tag.func_74762_e("export");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("export-" + j + "-isItem")) {
                s = AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("export-" + j)));
                s.setStackSize(tag.func_74763_f("export-" + j + "-amount"));
                this.export.add((IAEStack)s);
                continue;
            }
            s = AEApi.instance().storage().createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("export-" + j)));
            s.setStackSize(tag.func_74763_f("export-" + j + "-amount"));
            this.export.add((IAEStack)s);
        }
    }

    public void registerListener(IContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IContainerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.BUS_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.INTERFACE.getTextures()[0], side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.renderInventoryFace(TextureManager.INTERFACE.getTextures()[0], ForgeDirection.SOUTH, renderer);
        rh.setTexture(side);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.BUS_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.INTERFACE.getTextures()[0], side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        ts.func_78380_c(0x1400000);
        rh.renderFace(x, y, z, TextureManager.INTERFACE.getTextures()[0], ForgeDirection.SOUTH, renderer);
        rh.setTexture(side);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
    }

    @Override
    public void setFilter(ForgeDirection side, Fluid fluid) {
        if (fluid == null) {
            this.fluidFilter = -1;
            this.doNextUpdate = true;
            return;
        }
        this.fluidFilter = fluid.getID();
        this.doNextUpdate = true;
    }

    @Override
    public void setFluid(int _index, Fluid _fluid, EntityPlayer _player) {
        this.setFilter(ForgeDirection.getOrientation((int)_index), _fluid);
    }

    @Override
    public void setFluidTank(ForgeDirection side, FluidStack fluid) {
        this.tank.setFluid(fluid);
        this.doNextUpdate = true;
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        FluidStack s;
        IGrid grid;
        if (this.doNextUpdate) {
            this.forceUpdate();
        }
        if ((grid = node.getGrid()) == null) {
            return TickRateModulation.URGENT;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return TickRateModulation.URGENT;
        }
        this.pushItems();
        if (this.toExport != null) {
            storage.getItemInventory().injectItems((IAEStack)this.toExport, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            this.toExport = null;
        }
        if (this.update) {
            this.update = false;
            if (this.getGridNode() != null && this.getGridNode().getGrid() != null) {
                this.getGridNode().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getGridNode()));
            }
        }
        if (this.tank.getFluid() != null && FluidRegistry.getFluid((int)this.fluidFilter) != this.tank.getFluid().getFluid() && (s = this.tank.drain(125, false)) != null) {
            IAEFluidStack notAdded = (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(s.copy()), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            if (notAdded != null) {
                int toAdd = (int)((long)s.amount - notAdded.getStackSize());
                storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(this.tank.drain(toAdd, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                this.doNextUpdate = true;
                this.needBreake = false;
            } else {
                storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(this.tank.drain(s.amount, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                this.doNextUpdate = true;
                this.needBreake = false;
            }
        }
        if ((this.tank.getFluid() == null || this.tank.getFluid().getFluid() == FluidRegistry.getFluid((int)this.fluidFilter)) && FluidRegistry.getFluid((int)this.fluidFilter) != null) {
            IAEFluidStack extracted = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(FluidRegistry.getFluid((int)this.fluidFilter), 125)), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            if (extracted == null) {
                return TickRateModulation.URGENT;
            }
            int accepted = this.tank.fill(extracted.getFluidStack(), false);
            if (accepted == 0) {
                return TickRateModulation.URGENT;
            }
            this.tank.fill(((IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(FluidRegistry.getFluid((int)this.fluidFilter), accepted)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this))).getFluidStack(), true);
            this.doNextUpdate = true;
            this.needBreake = false;
        }
        return TickRateModulation.URGENT;
    }

    public NBTTagCompound writeFilter(NBTTagCompound tag) {
        if (FluidRegistry.getFluid((int)this.fluidFilter) == null) {
            return null;
        }
        tag.func_74768_a("filter", this.fluidFilter);
        return tag;
    }

    private NBTTagCompound writeOutputToNBT(NBTTagCompound tag) {
        NBTTagCompound data;
        int i = 0;
        for (IAEStack s : this.removeFromExport) {
            if (s != null) {
                tag.func_74757_a("remove-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).getItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("remove-" + i, (NBTBase)data);
                tag.func_74772_a("remove-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("remove", this.removeFromExport.size());
        i = 0;
        for (IAEStack s : this.addToExport) {
            if (s != null) {
                tag.func_74757_a("add-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).getItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("add-" + i, (NBTBase)data);
                tag.func_74772_a("add-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("add", this.addToExport.size());
        i = 0;
        for (IAEStack s : this.export) {
            if (s != null) {
                tag.func_74757_a("export-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).getItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("export-" + i, (NBTBase)data);
                tag.func_74772_a("export-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("export", this.export.size());
        return tag;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        this.writeToNBTWithoutExport(data);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeOutputToNBT(tag);
        data.func_74782_a("export", (NBTBase)tag);
    }

    public void writeToNBTWithoutExport(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        data.func_74768_a("filter", this.fluidFilter);
        NBTTagCompound inventory = new NBTTagCompound();
        this.inventory.writeToNBT(inventory);
        data.func_74782_a("inventory", (NBTBase)inventory);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a("filter", this.fluidFilter);
        NBTTagCompound inventory = new NBTTagCompound();
        this.inventory.writeToNBT(inventory);
        tag.func_74782_a("inventory", (NBTBase)inventory);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)tag);
    }

    private class FluidInterfaceInventory
    implements IInventory {
        private ItemStack[] inv = new ItemStack[9];

        private FluidInterfaceInventory() {
        }

        public void func_70305_f() {
        }

        public ItemStack func_70298_a(int slot, int amt) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null) {
                if (stack.field_77994_a <= amt) {
                    this.func_70299_a(slot, null);
                } else {
                    stack = stack.func_77979_a(amt);
                    if (stack.field_77994_a == 0) {
                        this.func_70299_a(slot, null);
                    }
                }
            }
            PartFluidInterface.this.update = true;
            return stack;
        }

        public String func_145825_b() {
            return "inventory.fluidInterface";
        }

        public int func_70297_j_() {
            return 1;
        }

        public int func_70302_i_() {
            return this.inv.length;
        }

        public ItemStack func_70301_a(int slot) {
            return this.inv[slot];
        }

        public ItemStack func_70304_b(int slot) {
            return null;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            if (stack.func_77973_b() instanceof ICraftingPatternItem) {
                IGridNode n = PartFluidInterface.this.getGridNode();
                World w = n == null ? PartFluidInterface.this.getClientWorld() : n.getWorld();
                if (w == null) {
                    return false;
                }
                ICraftingPatternDetails details = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, w);
                return details != null;
            }
            return false;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_70296_d() {
        }

        public void func_70295_k_() {
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.inv[slot] = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
            PartFluidInterface.this.update = true;
        }

        public void writeToNBT(NBTTagCompound tagCompound) {
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.inv.length; ++i) {
                ItemStack stack = this.inv[i];
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        }
    }
}

