/*
 * Decompiled with CFR 0.152.
 */
package hilburnlib.asm;

import java.util.Arrays;
import java.util.Comparator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InsnComparator
implements Comparator<AbstractInsnNode> {
    private static final String WILDCARD_STRING = "HilburnIsAwesome";
    private static final int WILDCARD_INT = -42;
    private static final Object[] WILDCARD_ARRAY = new Object[]{"HilburnIsAwesome", -42};

    @Override
    public int compare(AbstractInsnNode a, AbstractInsnNode b) {
        return InsnComparator.areNodesEqual(a, b) ? 0 : 1;
    }

    public static boolean areNodesEqual(AbstractInsnNode a, AbstractInsnNode b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (a.getType() == b.getType() && a.getOpcode() == b.getOpcode()) {
            switch (a.getType()) {
                case 4: {
                    return InsnComparator.areFieldInsnNodesEqual((FieldInsnNode)a, (FieldInsnNode)b);
                }
                case 10: {
                    return InsnComparator.areIincInsnNodesEqual((IincInsnNode)a, (IincInsnNode)b);
                }
                case 1: {
                    return InsnComparator.areIntInsnNodesEqual((IntInsnNode)a, (IntInsnNode)b);
                }
                case 6: {
                    return InsnComparator.areInvokeDynamicInsnNodesEqual((InvokeDynamicInsnNode)a, (InvokeDynamicInsnNode)b);
                }
                case 9: {
                    return InsnComparator.areLdcInsnNodesEqual((LdcInsnNode)a, (LdcInsnNode)b);
                }
                case 5: {
                    return InsnComparator.areMethodInsnNodesEqual((MethodInsnNode)a, (MethodInsnNode)b);
                }
                case 13: {
                    return InsnComparator.areMultiANewArrayInsnNodesEqual((MultiANewArrayInsnNode)a, (MultiANewArrayInsnNode)b);
                }
                case 3: {
                    return InsnComparator.areTypeInsnNodesEqual((TypeInsnNode)a, (TypeInsnNode)b);
                }
                case 2: {
                    return InsnComparator.areVarInsnNodesEqual((VarInsnNode)a, (VarInsnNode)b);
                }
            }
        }
        return false;
    }

    private static boolean areFieldInsnNodesEqual(FieldInsnNode a, FieldInsnNode b) {
        return InsnComparator.objectMatch(a.name, b.name) && InsnComparator.objectMatch(a.desc, b.desc);
    }

    private static boolean areIincInsnNodesEqual(IincInsnNode a, IincInsnNode b) {
        return InsnComparator.intMatch(a.incr, b.incr) && InsnComparator.intMatch(a.var, b.var);
    }

    private static boolean areIntInsnNodesEqual(IntInsnNode a, IntInsnNode b) {
        return InsnComparator.intMatch(a.operand, b.operand);
    }

    private static boolean areInvokeDynamicInsnNodesEqual(InvokeDynamicInsnNode a, InvokeDynamicInsnNode b) {
        return InsnComparator.objectMatch(a.name, b.name) && InsnComparator.objectMatch(a.desc, b.desc) && InsnComparator.arrayMatch(a.bsmArgs, b.bsmArgs);
    }

    private static boolean areLdcInsnNodesEqual(LdcInsnNode a, LdcInsnNode b) {
        return InsnComparator.objectMatch(a.cst, b.cst);
    }

    private static boolean areMethodInsnNodesEqual(MethodInsnNode a, MethodInsnNode b) {
        return InsnComparator.objectMatch(a.name, b.name) && a.itf == b.itf && InsnComparator.objectMatch(a.desc, b.desc);
    }

    private static boolean areMultiANewArrayInsnNodesEqual(MultiANewArrayInsnNode a, MultiANewArrayInsnNode b) {
        return InsnComparator.intMatch(a.dims, b.dims) && InsnComparator.objectMatch(a.desc, b.desc);
    }

    private static boolean areTypeInsnNodesEqual(TypeInsnNode a, TypeInsnNode b) {
        return InsnComparator.objectMatch(a.desc, b.desc);
    }

    private static boolean areVarInsnNodesEqual(VarInsnNode a, VarInsnNode b) {
        return InsnComparator.intMatch(a.var, b.var);
    }

    private static boolean intMatch(int a, int b) {
        return a == b || a == -42 || b == -42;
    }

    private static boolean objectMatch(Object a, Object b) {
        return a.equals(b) || a.equals(WILDCARD_STRING) || b.equals(WILDCARD_STRING);
    }

    private static boolean arrayMatch(Object[] a, Object[] b) {
        return Arrays.deepEquals(a, b) || Arrays.deepEquals(a, WILDCARD_ARRAY) || Arrays.deepEquals(b, WILDCARD_ARRAY);
    }
}

