/*
 * Decompiled with CFR 0.152.
 */
package hilburnlib.asm;

import hilburnlib.asm.ASMHelper;
import hilburnlib.asm.ITransformer;
import hilburnlib.asm.obfuscation.ASMString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class Transformer<T>
implements ITransformer,
Opcodes {
    public static int NODE_MODIFY = 1;
    public static int NODE_ACCESS = 2;
    public static int NODE_DELETE = 4;
    public static int NODE_ADD = 8;
    public static Logger log = LogManager.getLogger((String)"CartFixes-ASM");
    protected Access access;
    protected int action;
    protected ClassNode classNode;
    protected ASMString name;

    protected Transformer() {
        this(NODE_MODIFY);
    }

    protected Transformer(int action) {
        this(action, Access.PUBLIC);
    }

    protected Transformer(int action, Access access) {
        this.action = action;
        this.access = access;
    }

    @Override
    public boolean transform(ClassNode classNode) {
        this.classNode = classNode;
        if ((this.action & NODE_ADD) > 0) {
            this.add();
            return true;
        }
        T node = this.find();
        if (node != null) {
            if ((this.action & NODE_MODIFY) > 0) {
                this.modify(node);
            }
            if ((this.action & NODE_ACCESS) > 0) {
                this.changeAccess(node);
            }
            if ((this.action & NODE_DELETE) > 0) {
                this.delete(node);
            }
            return true;
        }
        return false;
    }

    protected abstract T find();

    protected abstract void changeAccess(T var1);

    protected abstract void modify(T var1);

    protected abstract void delete(T var1);

    protected abstract void add();

    protected abstract T getNodeToAdd();

    protected abstract void log();

    public static class InnerClassTransformer
    extends Transformer<InnerClassNode> {
        @Override
        protected InnerClassNode find() {
            String name = this.classNode.name + "$" + this.name.getText();
            for (InnerClassNode inner : this.classNode.innerClasses) {
                if (!name.equals(inner.name)) continue;
                return inner;
            }
            return null;
        }

        @Override
        protected void changeAccess(InnerClassNode node) {
            node.access = this.access.modifyAccess(node.access);
        }

        @Override
        protected void modify(InnerClassNode node) {
        }

        @Override
        protected void delete(InnerClassNode node) {
            this.classNode.innerClasses.remove(node);
        }

        @Override
        protected void add() {
            this.classNode.innerClasses.add(this.getNodeToAdd());
        }

        @Override
        protected InnerClassNode getNodeToAdd() {
            return null;
        }

        @Override
        protected void log() {
            log.info("Transformed Inner Class: " + this.name.getReadableText());
        }
    }

    public static class MethodTransformer
    extends Transformer<MethodNode> {
        protected String methodDesc;

        public MethodTransformer(String name, String desc) {
            this(new ASMString(name), desc);
        }

        public MethodTransformer(String name, String obfName, String desc) {
            this(new ASMString.ASMObfString(name, obfName), desc);
        }

        public MethodTransformer(ASMString name, String desc) {
            this(NODE_MODIFY, Access.PUBLIC, name, desc);
        }

        public MethodTransformer(int action, ASMString name, String desc) {
            this(action, Access.PUBLIC, name, desc);
        }

        public MethodTransformer(int action, Access access, ASMString name, String desc) {
            super(action, access);
            this.name = name;
            this.methodDesc = desc;
        }

        @Override
        protected MethodNode find() {
            String name = this.name.getText();
            for (MethodNode method : this.classNode.methods) {
                if (!method.name.equals(name) || !method.desc.equals(this.methodDesc)) continue;
                return method;
            }
            return null;
        }

        @Override
        protected void changeAccess(MethodNode node) {
            node.access = this.access.modifyAccess(node.access);
        }

        @Override
        protected void modify(MethodNode node) {
        }

        @Override
        protected void delete(MethodNode node) {
            this.classNode.methods.remove(node);
        }

        @Override
        protected void add() {
            this.classNode.methods.add(this.getNodeToAdd());
        }

        @Override
        protected MethodNode getNodeToAdd() {
            return null;
        }

        @Override
        protected void log() {
            log.info("Transformed Method: " + this.name.getReadableText());
        }
    }

    public static class FieldTransformer
    extends Transformer<FieldNode> {
        protected String fieldDesc;

        public FieldTransformer(String name, String desc) {
            this(new ASMString(name), desc);
        }

        public FieldTransformer(String name, String obfName, String desc) {
            this(new ASMString.ASMObfString(name, obfName), desc);
        }

        public FieldTransformer(ASMString name, String desc) {
            this(NODE_ACCESS, Access.PUBLIC, name, desc);
        }

        public FieldTransformer(int action, Access access, ASMString name, String desc) {
            super(action, access);
            this.name = name;
            this.fieldDesc = desc;
        }

        @Override
        protected FieldNode find() {
            String fieldName = this.name.getText();
            for (FieldNode field : this.classNode.fields) {
                if (!field.name.equals(fieldName) || !field.desc.equals(this.fieldDesc)) continue;
                return field;
            }
            return null;
        }

        @Override
        protected void changeAccess(FieldNode node) {
            node.access = this.access.modifyAccess(node.access);
        }

        @Override
        protected void modify(FieldNode node) {
        }

        @Override
        protected void delete(FieldNode node) {
            this.classNode.fields.remove(node);
        }

        @Override
        protected void add() {
            this.classNode.fields.add(this.getNodeToAdd());
        }

        @Override
        protected FieldNode getNodeToAdd() {
            return null;
        }

        @Override
        protected void log() {
            log.info("Transformed Field " + this.name.getReadableText());
        }
    }

    public static class ClassTransformer
    extends Transformer<ClassNode> {
        private Transformer[] transformers;

        public ClassTransformer(String name, Transformer ... transformers) {
            this(new ASMString(name), transformers);
        }

        public ClassTransformer(String name, String obfName, Transformer ... transformers) {
            this(new ASMString.ASMObfString(name, obfName), transformers);
        }

        public ClassTransformer(ASMString name, Transformer ... transformers) {
            super(NODE_MODIFY);
            this.name = name;
            this.transformers = transformers;
        }

        public String getClassName() {
            return this.name.getText();
        }

        public byte[] transform(byte[] bytes) {
            ClassNode node = ASMHelper.readClassFromBytes(bytes);
            if (this.transform(node)) {
                return ASMHelper.writeClassToBytesNoDeobfSkipFrames(node);
            }
            return bytes;
        }

        @Override
        protected ClassNode find() {
            return this.classNode;
        }

        @Override
        protected void changeAccess(ClassNode node) {
            this.classNode.access = this.access.modifyAccess(this.classNode.access);
        }

        @Override
        protected void modify(ClassNode node) {
            this.log();
            for (Transformer transformer : this.transformers) {
                if (!transformer.transform(node)) continue;
                transformer.log();
            }
        }

        @Override
        protected void delete(ClassNode node) {
        }

        @Override
        protected void add() {
        }

        @Override
        protected ClassNode getNodeToAdd() {
            return null;
        }

        @Override
        protected void log() {
            log.info("Transforming Class: " + this.name.getReadableText());
        }
    }

    public static enum Access {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4);

        public static int clearAccess;
        private int val;

        private Access(int val) {
            this.val = val;
        }

        public int modifyAccess(int access) {
            return access & clearAccess ^ this.val;
        }

        static {
            clearAccess = -8;
        }
    }
}

