/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.rendering.grid;

import ivorius.ivtoolkit.rendering.IvRenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;

public class GridRenderer {
    public static void renderGrid(int lines, float spacing, float lineLength, float lineWidth) {
        int z;
        int x;
        Tessellator.field_78398_a.func_78382_b();
        for (x = -lines; x <= lines; ++x) {
            for (z = -lines; z <= lines; ++z) {
                GridRenderer.renderLine((float)x * spacing, -lineLength * 0.5f, (float)z * spacing, ForgeDirection.UP, lineLength, lineWidth);
            }
        }
        for (x = -lines; x <= lines; ++x) {
            for (int y = -lines; y <= lines; ++y) {
                GridRenderer.renderLine((float)x * spacing, (float)y * spacing, -lineLength * 0.5f, ForgeDirection.SOUTH, lineLength, lineWidth);
            }
        }
        for (int y = -lines; y <= lines; ++y) {
            for (z = -lines; z <= lines; ++z) {
                GridRenderer.renderLine(-lineLength * 0.5f, (float)y * spacing, (float)z * spacing, ForgeDirection.EAST, lineLength, lineWidth);
            }
        }
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void renderLine(float x, float y, float z, ForgeDirection direction, float length, float size) {
        float xDir = (float)direction.offsetX * length;
        float yDir = (float)direction.offsetY * length;
        float zDir = (float)direction.offsetZ * length;
        if (xDir == 0.0f) {
            xDir = size;
        } else {
            x = (float)((double)x + (double)xDir * 0.5);
        }
        if (yDir == 0.0f) {
            yDir = size;
        } else {
            y = (float)((double)y + (double)yDir * 0.5);
        }
        if (zDir == 0.0f) {
            zDir = size;
        } else {
            z = (float)((double)z + (double)zDir * 0.5);
        }
        Tessellator.field_78398_a.func_78372_c(x, y, z);
        IvRenderHelper.renderCuboid(Tessellator.field_78398_a, xDir, yDir, zDir, 1.0f);
        Tessellator.field_78398_a.func_78372_c(-x, -y, -z);
    }
}

