/*
 * Decompiled with CFR 0.152.
 */
package hats.addons.hatstand.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import hats.addons.hatstand.client.render.BlockRenderHatStand;
import hats.addons.hatstand.client.render.TileRendererHatStand;
import hats.addons.hatstand.common.HatStand;
import hats.addons.hatstand.common.block.BlockHatStand;
import hats.addons.hatstand.common.packet.PacketStandHatInfo;
import hats.addons.hatstand.common.tileentity.TileEntityHatStand;
import hats.client.core.HatInfoClient;
import hats.common.Hats;
import hats.common.core.CommonProxy;
import hats.common.core.HatHandler;
import ichun.client.gui.GuiSlider;
import ichun.client.gui.ISlider;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiHatSelection
extends GuiScreen
implements ISlider {
    private final int ID_PAGE_LEFT = 1;
    private final int ID_DONE_SELECT = 2;
    private final int ID_PAGE_RIGHT = 3;
    private final int ID_CLOSE = 4;
    private final int ID_NONE = 8;
    private final int ID_HAT_COLOUR_SWAP = 9;
    private final int ID_RANDOM = 10;
    private final int ID_HEAD = 11;
    private final int ID_BASE = 12;
    private final int ID_STAND = 13;
    private final int ID_HAT_START_ID = 600;
    private final int VIEW_HATS = 0;
    private final int VIEW_COLOURIZER = 1;
    private String currentDisplay;
    private GuiTextField searchBar;
    private String selectedButtonName = "";
    private int favourite;
    private boolean hasClicked = false;
    private boolean confirmed = false;
    private boolean justClickedButton = false;
    private boolean enabledSearchBar = false;
    public TileEntityHatStand stand;
    public List<String> availableHats;
    public List<String> hatsToShow;
    protected int xSize = 176;
    protected int ySize = 170;
    public float mouseX;
    public float mouseY;
    protected int guiLeft;
    protected int guiTop;
    public int pageNumber;
    public int colourR;
    public int colourG;
    public int colourB;
    public int alpha;
    public int head;
    public boolean base;
    public boolean standPost;
    private String prevHatName;
    private int prevColourR;
    private int prevColourG;
    private int prevColourB;
    private int prevAlpha;
    private int prevHead;
    private GameProfile prevGameProfile;
    private boolean prevBase;
    private boolean prevStandPost;
    private HatInfoClient tempInfo;
    public int view;
    public Random rand;

    public GuiHatSelection(TileEntityHatStand hatStand) {
        if (Hats.config.getSessionInt("playerHatsMode") == 4) {
            if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                HatHandler.repopulateHatsList();
            } else {
                CommonProxy.tickHandlerClient.availableHats = new HashMap(CommonProxy.tickHandlerClient.serverHats);
            }
        }
        ArrayList list = new ArrayList();
        for (Map.Entry e : CommonProxy.tickHandlerClient.availableHats.entrySet()) {
            list.add(e.getKey());
        }
        Collections.sort(list);
        this.availableHats = ImmutableList.copyOf(list);
        this.hatsToShow = new ArrayList<String>(this.availableHats);
        Collections.sort(this.hatsToShow);
        this.stand = hatStand;
        this.prevHatName = this.stand.hatName;
        this.prevGameProfile = this.stand.gameProfile;
        this.prevColourR = this.colourR = this.stand.colourR;
        this.prevColourG = this.colourG = this.stand.colourG;
        this.prevColourB = this.colourB = this.stand.colourB;
        this.prevAlpha = this.alpha = this.stand.alpha;
        this.prevHead = this.head = this.stand.head;
        this.prevBase = this.base = this.stand.hasBase;
        this.prevStandPost = this.standPost = this.stand.hasStand;
        this.pageNumber = 0;
        this.view = 0;
        this.rand = new Random();
        this.enabledSearchBar = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.stand == null) {
            this.field_146297_k.func_147108_a(null);
        } else {
            Keyboard.enableRepeatEvents((boolean)true);
            this.field_146292_n.clear();
            this.guiLeft = (this.field_146294_l - this.xSize) / 2;
            this.guiTop = (this.field_146295_m - this.ySize) / 2;
            this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 6, this.field_146295_m / 2 + 54, 20, 20, "<"));
            this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 + 62, this.field_146295_m / 2 + 54, 20, 20, ">"));
            this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 16, this.field_146295_m / 2 + 54, 44, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
            this.addToolButton(8, 0);
            this.addToolButton(9, 1);
            this.addToolButton(10, 2);
            this.field_146292_n.add(new GuiButton(4, this.field_146294_l - 22, 2, 20, 20, "X"));
            this.pageNumber = 0;
            if (!this.stand.hatName.equalsIgnoreCase("")) {
                for (int i = 0; i < this.hatsToShow.size(); ++i) {
                    String hatName = this.hatsToShow.get(i);
                    if (!hatName.equalsIgnoreCase(this.stand.hatName)) continue;
                    i -= i % 6;
                    this.pageNumber = i / 6;
                    break;
                }
            }
            this.updateButtonList();
            this.searchBar = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 65, this.field_146295_m - 24, 150, 20);
            this.searchBar.func_146203_f(255);
            this.searchBar.func_146180_a(StatCollector.func_74838_a((String)"hats.gui.search"));
            this.searchBar.func_146193_g(0xAAAAAA);
            this.searchBar.func_146189_e(this.enabledSearchBar);
        }
    }

    public void addToolButton(int id, int i) {
        this.field_146292_n.add(new GuiButton(id, this.field_146294_l / 2 + 89, this.field_146295_m / 2 - 85 + i * 21, 20, 20, ""));
    }

    public void func_73876_c() {
        this.searchBar.func_146178_a();
        if (this.searchBar.func_146206_l()) {
            this.searchBar.func_146189_e(true);
        } else {
            this.searchBar.func_146189_e(this.enabledSearchBar);
        }
        if (this.favourite > 0) {
            --this.favourite;
        }
    }

    public void func_146281_b() {
        if (!this.confirmed) {
            this.stand.hatName = this.prevHatName;
            this.stand.colourR = this.prevColourR;
            this.stand.colourG = this.prevColourG;
            this.stand.colourB = this.prevColourB;
            this.stand.alpha = this.prevAlpha;
            this.stand.head = this.prevHead;
            this.stand.gameProfile = this.prevGameProfile;
            this.stand.hasBase = this.prevBase;
            this.stand.hasStand = this.prevStandPost;
            this.stand.func_145831_w().func_147471_g(this.stand.field_145851_c, this.stand.field_145848_d, this.stand.field_145849_e);
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char c, int i) {
        this.searchBar.func_146201_a(c, i);
        if (this.searchBar.func_146206_l()) {
            this.onSearch();
        }
        if (i == 1) {
            if (this.searchBar.func_146206_l()) {
                this.searchBar.func_146180_a("");
                this.searchBar.func_146195_b(false);
                this.onSearchBarInteract();
            } else {
                this.exitWithoutUpdate();
                this.field_146297_k.func_71381_h();
            }
        }
        if (!this.searchBar.func_146206_l()) {
            GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
            if (i == 19) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                this.randomize();
            } else if (i == 15 || i == gameSettings.field_74310_D.func_151463_i()) {
                this.searchBar.func_146195_b(true);
                this.onSearchBarInteract();
            } else if (!(i != 35 || this.stand.hatName.equalsIgnoreCase("") && this.view == 0)) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                this.toggleHatsColourizer();
            } else if (i == 49 && !this.stand.hatName.equalsIgnoreCase("")) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                this.removeHat();
            }
            if (this.view == 0) {
                if ((i == gameSettings.field_74370_x.func_151463_i() || i == 203) && this.pageNumber > 0) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    this.switchPage(true);
                } else if ((i == gameSettings.field_74366_z.func_151463_i() || i == 205) && (this.pageNumber + 1) * 6 < this.hatsToShow.size()) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    this.switchPage(false);
                }
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        boolean flag;
        super.func_73864_a(par1, par2, par3);
        boolean bl = flag = par1 >= this.field_146294_l / 2 - 65 && par1 < this.field_146294_l / 2 - 65 + this.field_146294_l && par2 >= this.field_146295_m - 24 && par2 < this.field_146295_m - 24 + this.field_146295_m;
        if (this.enabledSearchBar) {
            this.searchBar.func_146192_a(par1, par2, par3);
            if (par3 == 1 && flag) {
                this.searchBar.func_146180_a("");
                this.onSearch();
            }
            this.onSearchBarInteract();
        }
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        super.func_146286_b(par1, par2, par3);
        this.justClickedButton = false;
    }

    public void onSearch() {
        if (this.searchBar.func_146179_b().equalsIgnoreCase("") || !this.hasClicked && this.searchBar.func_146179_b().equalsIgnoreCase("Search")) {
            this.searchBar.func_146193_g(0xE0E0E0);
            this.hatsToShow = new ArrayList<String>(this.availableHats);
            Collections.sort(this.hatsToShow);
        } else {
            String query = this.searchBar.func_146179_b();
            ArrayList<String> matches = new ArrayList<String>();
            block0: for (String s : this.availableHats) {
                String[] split;
                if (s.toLowerCase().startsWith(query.toLowerCase())) {
                    if (matches.contains(s)) continue;
                    matches.add(s);
                    continue;
                }
                for (String s1 : split = s.split(" ")) {
                    if (!s1.toLowerCase().startsWith(query.toLowerCase())) continue;
                    if (matches.contains(s)) continue block0;
                    matches.add(s);
                    continue block0;
                }
            }
            if (matches.size() == 0) {
                this.searchBar.func_146193_g(0xFF5555);
                this.hatsToShow = new ArrayList<String>(this.availableHats);
                Collections.sort(this.hatsToShow);
            } else {
                this.searchBar.func_146193_g(0xE0E0E0);
                this.pageNumber = 0;
                this.hatsToShow = new ArrayList<String>(matches);
                Collections.sort(this.hatsToShow);
            }
        }
        this.updateButtonList();
    }

    public void onSearchBarInteract() {
        if (this.searchBar.func_146206_l()) {
            this.searchBar.func_146193_g(0xE0E0E0);
            if (!this.hasClicked && this.searchBar.func_146179_b().equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.search"))) {
                this.hasClicked = true;
                this.searchBar.func_146180_a("");
                this.onSearch();
            }
        } else {
            this.searchBar.func_146193_g(0xAAAAAA);
            if (this.searchBar.func_146179_b().equalsIgnoreCase("")) {
                this.hasClicked = false;
                this.searchBar.func_146180_a(StatCollector.func_74838_a((String)"hats.gui.search"));
            }
        }
    }

    protected void func_146284_a(GuiButton btn) {
        if (!this.justClickedButton) {
            if (btn.field_146127_k == 2) {
                this.exitAndUpdate();
            }
            if (btn.field_146127_k == 1) {
                this.switchPage(true);
            } else if (btn.field_146127_k == 3) {
                this.switchPage(false);
            } else if (btn.field_146127_k == 4) {
                this.exitWithoutUpdate();
            } else if (btn.field_146127_k == 8) {
                this.removeHat();
            } else if (btn.field_146127_k == 9) {
                this.toggleHatsColourizer();
            } else if (btn.field_146127_k == 10) {
                this.randomize();
            } else if (btn.field_146127_k == 11) {
                ++this.stand.head;
                if (this.stand.head == TileEntityHatStand.headNames.length) {
                    this.stand.head = 0;
                }
                if (this.stand.head == 4) {
                    this.stand.gameProfile = Minecraft.func_71410_x().field_71439_g.func_146103_bH();
                }
                this.head = this.stand.head;
                this.justClickedButton = true;
                this.updateButtonList();
            } else if (btn.field_146127_k == 12) {
                this.stand.hasBase = this.base = !this.base;
                this.justClickedButton = true;
                if (!this.base) {
                    this.standPost = false;
                    this.stand.hasStand = false;
                }
                this.stand.func_145831_w().func_147471_g(this.stand.field_145851_c, this.stand.field_145848_d, this.stand.field_145849_e);
                this.updateButtonList();
            } else if (btn.field_146127_k == 13) {
                this.stand.hasStand = this.standPost = !this.standPost;
                this.justClickedButton = true;
                this.stand.func_145831_w().func_147471_g(this.stand.field_145851_c, this.stand.field_145848_d, this.stand.field_145849_e);
                this.updateButtonList();
            } else if (btn.field_146127_k >= 600) {
                this.justClickedButton = true;
                this.stand.hatName = btn.field_146126_j.toLowerCase();
                this.alpha = 255;
                this.colourB = 255;
                this.colourG = 255;
                this.colourR = 255;
                this.stand.colourR = 255;
                this.stand.colourG = 255;
                this.stand.colourB = 255;
                this.stand.alpha = 255;
                this.updateButtonList();
            }
        }
    }

    public void exitAndUpdate() {
        this.confirmed = true;
        this.field_146297_k.func_147108_a(null);
        PacketHandler.sendToServer(HatStand.channels, (AbstractPacket)new PacketStandHatInfo(this.stand.field_145851_c, this.stand.field_145848_d, this.stand.field_145849_e, this.stand.hatName, this.colourR, this.colourG, this.colourB, this.alpha, this.head, this.base, this.standPost));
    }

    public void exitWithoutUpdate() {
        this.field_146297_k.func_147108_a(null);
        this.stand.hatName = this.prevHatName;
        this.stand.colourR = this.prevColourR;
        this.stand.colourG = this.prevColourG;
        this.stand.colourB = this.prevColourB;
        this.stand.head = this.prevHead;
        this.stand.gameProfile = this.prevGameProfile;
        this.stand.hasBase = this.prevBase;
        this.stand.hasStand = this.prevStandPost;
        this.stand.func_145831_w().func_147471_g(this.stand.field_145851_c, this.stand.field_145848_d, this.stand.field_145849_e);
    }

    public void updateButtonList() {
        int button;
        for (int k1 = this.field_146292_n.size() - 1; k1 >= 0; --k1) {
            GuiButton btn = (GuiButton)this.field_146292_n.get(k1);
            if (btn.field_146127_k >= 5 && btn.field_146127_k <= 7 || btn.field_146127_k == 15 || btn.field_146127_k >= 11 && btn.field_146127_k <= 13 || btn.field_146127_k >= 600) {
                this.field_146292_n.remove(k1);
                continue;
            }
            if (btn.field_146127_k == 1) {
                if (this.pageNumber == 0 || this.view == 1) {
                    btn.field_146124_l = false;
                    continue;
                }
                btn.field_146124_l = true;
                continue;
            }
            if (btn.field_146127_k == 3) {
                if ((this.pageNumber + 1) * 6 >= this.hatsToShow.size() || this.view == 1) {
                    btn.field_146124_l = false;
                    continue;
                }
                btn.field_146124_l = true;
                continue;
            }
            if (btn.field_146127_k != 8) continue;
            btn.field_146124_l = !this.stand.hatName.equalsIgnoreCase("");
        }
        if (this.view == 0) {
            int pageCount;
            button = 0;
            for (int i = this.pageNumber * 6; i < this.hatsToShow.size() && i < (this.pageNumber + 1) * 6; ++i) {
                String hatName = this.hatsToShow.get(i);
                GuiButton btn = new GuiButton(600 + i, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * button, 88, 20, hatName);
                if (this.view == 0 && hatName.toLowerCase().equalsIgnoreCase(this.stand.hatName)) {
                    btn.field_146124_l = false;
                }
                this.field_146292_n.add(btn);
                if (++button != 6) continue;
                button = 0;
                break;
            }
            if ((pageCount = (int)Math.ceil((float)this.hatsToShow.size() / 6.0f)) <= 0) {
                pageCount = 1;
            }
            this.currentDisplay = StatCollector.func_74838_a((String)"hats.gui.allHats") + " (" + (this.pageNumber + 1) + "/" + pageCount + ")";
        } else if (this.view == 1) {
            button = 0;
            for (int i = 0; i < 4; ++i) {
                GuiSlider btn = new GuiSlider(i == 3 ? 15 : 5 + i, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * button, 88, i == 0 ? StatCollector.func_74838_a((String)"item.fireworksCharge.red") + ": " : (i == 1 ? StatCollector.func_74838_a((String)"item.fireworksCharge.green") + ": " : (i == 2 ? StatCollector.func_74838_a((String)"item.fireworksCharge.blue") + ": " : StatCollector.func_74838_a((String)"hats.gui.alpha") + ": ")), "", 0.0, 255.0, i == 0 ? (double)this.colourR : (i == 1 ? (double)this.colourG : (i == 2 ? (double)this.colourB : (double)this.alpha)), false, true, (ISlider)this);
                this.field_146292_n.add(btn);
                ++button;
            }
            this.field_146292_n.add(new GuiButton(11, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * button, 88, 20, StatCollector.func_74838_a((String)"item.skull.char.name") + ": " + TileEntityHatStand.headNames[this.stand.head]));
            this.field_146292_n.add(new GuiButton(12, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * ++button, 88, 20, StatCollector.func_74838_a((String)"hats.addon.hatstands.gui.base") + ": " + (this.base ? StatCollector.func_74838_a((String)"gui.yes") : StatCollector.func_74838_a((String)"gui.no"))));
            GuiButton btn = new GuiButton(13, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * ++button, 88, 20, StatCollector.func_74838_a((String)"hats.addon.hatstands.gui.stand") + ": " + (this.standPost ? StatCollector.func_74838_a((String)"gui.yes") : StatCollector.func_74838_a((String)"gui.no")));
            if (!this.stand.isOnFloor || !this.base) {
                btn.field_146124_l = false;
            }
            this.field_146292_n.add(btn);
            ++button;
            this.currentDisplay = StatCollector.func_74838_a((String)"hats.gui.personalize");
        }
    }

    public void removeHat() {
        this.stand.hatName = "";
        this.updateButtonList();
    }

    public void switchPage(boolean left) {
        if (left) {
            --this.pageNumber;
            if (this.pageNumber < 0) {
                this.pageNumber = 0;
            }
            this.updateButtonList();
        } else {
            ++this.pageNumber;
            if (this.pageNumber * 6 >= this.hatsToShow.size()) {
                --this.pageNumber;
            }
            this.updateButtonList();
        }
    }

    public void toggleHatsColourizer() {
        this.view = this.view > 0 ? 0 : 1;
        this.hatsToShow = new ArrayList<String>(this.availableHats);
        Collections.sort(this.hatsToShow);
        this.searchBar.func_146180_a("");
        this.onSearchBarInteract();
        this.updateButtonList();
    }

    public void randomize() {
        if (this.view == 0) {
            if (this.hatsToShow.size() > 0) {
                int randVal = this.rand.nextInt(this.hatsToShow.size());
                String hatName = this.hatsToShow.get(randVal);
                this.stand.hatName = hatName.toLowerCase();
                this.alpha = 255;
                this.colourB = 255;
                this.colourG = 255;
                this.colourR = 255;
                this.stand.colourR = 255;
                this.stand.colourG = 255;
                this.stand.colourB = 255;
                this.stand.alpha = 255;
                this.pageNumber = randVal / 6;
                if (GuiHatSelection.func_146272_n()) {
                    this.view = 1;
                    this.updateButtonList();
                    this.randomizeColour();
                    this.view = 0;
                }
                this.updateButtonList();
            }
        } else if (this.view == 1) {
            if (GuiHatSelection.func_146272_n()) {
                this.alpha = 255;
                this.colourB = 255;
                this.colourG = 255;
                this.colourR = 255;
                this.stand.colourR = 255;
                this.stand.colourG = 255;
                this.stand.colourB = 255;
                this.stand.alpha = 255;
                this.updateButtonList();
            } else {
                this.randomizeColour();
            }
        }
    }

    public void randomizeColour() {
        for (int k1 = this.field_146292_n.size() - 1; k1 >= 0; --k1) {
            GuiButton btn1 = (GuiButton)this.field_146292_n.get(k1);
            if (!(btn1 instanceof GuiSlider)) continue;
            GuiSlider slider = (GuiSlider)btn1;
            if (slider.field_146127_k < 5 || slider.field_146127_k > 7) continue;
            slider.sliderValue = this.stand.hatName.equalsIgnoreCase("") ? 0.0 : (double)this.rand.nextFloat();
            slider.updateSlider();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(hats.client.gui.GuiHatSelection.texChooser);
        int k = this.guiLeft;
        int l = this.guiTop;
        this.func_73729_b(k, l, 0, 0, this.xSize, this.ySize);
        this.field_146297_k.func_110434_K().func_110577_a(hats.client.gui.GuiHatSelection.texIcons);
        for (int k1 = 0; k1 < this.field_146292_n.size(); ++k1) {
            GuiButton btn = (GuiButton)this.field_146292_n.get(k1);
            String disp = btn.field_146126_j;
            if (btn.field_146127_k >= 600) {
                int id = btn.field_146127_k - 600;
                if (this.pageNumber * 6 > id || (this.pageNumber + 1) * 6 <= id) continue;
                if (btn.field_146126_j.length() > 16) {
                    btn.field_146126_j = btn.field_146126_j.substring(0, 13) + "...";
                }
            }
            btn.func_146112_a(this.field_146297_k, par1, par2);
            if (!(btn instanceof GuiSlider)) {
                btn.field_146126_j = disp;
            }
            if (btn.field_146127_k != 9 && btn.field_146127_k != 8 && btn.field_146127_k != 10) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.field_146297_k.func_110434_K().func_110577_a(hats.client.gui.GuiHatSelection.texIcons);
            if (btn.field_146125_m) {
                if (btn.field_146127_k == 9) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, this.view == 0 ? 176 : 0, 0, 16, 16);
                } else if (btn.field_146127_k == 8) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 32, 0, 16, 16);
                } else if (btn.field_146127_k == 10) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 80, 0, 16, 16);
                }
            }
            GL11.glDisable((int)3042);
        }
        this.func_73731_b(this.field_146289_q, "Viewing: " + this.currentDisplay, this.guiLeft, this.guiTop - 9, 0xFFFFFF);
        this.mouseX = par1;
        this.mouseY = par2;
        this.drawSearchBar();
        this.drawPlayerOnGui(k + 42, l + 155, 55, (float)(k + 42) - this.mouseX, (float)(l + 155 - 42) - this.mouseY);
        this.drawForeground(par1, par2, par3);
    }

    public void drawForeground(int par1, int par2, float par3) {
        for (int k1 = 0; k1 < this.field_146292_n.size(); ++k1) {
            GuiButton btn = (GuiButton)this.field_146292_n.get(k1);
            if (!btn.func_146115_a()) continue;
            if (btn.field_146127_k >= 600 && btn.field_146126_j.length() > 16) {
                this.drawTooltip(Arrays.asList("\u00a77" + btn.field_146126_j), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 4) {
                this.drawTooltip(Arrays.asList(StatCollector.func_74838_a((String)"hats.gui.discardChanges")), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 8) {
                this.drawTooltip(Arrays.asList(StatCollector.func_74838_a((String)"hats.gui.removeHat") + " (N)"), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 9) {
                this.drawTooltip(Arrays.asList((this.view == 0 ? StatCollector.func_74838_a((String)"hats.gui.personalize") : StatCollector.func_74838_a((String)"hats.gui.hatsList")) + " (H)"), par1, par2);
                continue;
            }
            if (btn.field_146127_k != 10) continue;
            this.drawTooltip(Arrays.asList((this.view == 0 ? StatCollector.func_74838_a((String)"hats.gui.randomHat") : (GuiHatSelection.func_146272_n() ? StatCollector.func_74838_a((String)"hats.gui.resetColor") : StatCollector.func_74838_a((String)"hats.gui.randomColor"))) + " (R)"), par1, par2);
        }
    }

    protected void drawTooltip(List par1List, int par2, int par3) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = this.field_146289_q.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                this.field_146289_q.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
        }
    }

    public void drawPlayerOnGui(int par1, int par2, int par3, float par4, float par5) {
        if (this.stand != null) {
            GL11.glEnable((int)2903);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)par1, (float)par2, (float)50.0f);
            GL11.glTranslatef((float)23.0f, (float)-20.0f, (float)0.0f);
            GL11.glScalef((float)(-par3), (float)par3, (float)par3);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-80.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderManager.field_78727_a.field_78735_i = 180.0f;
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
            GL11.glRotatef((float)(-((float)Math.atan(par4 / 40.0f)) * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-((float)Math.atan(par5 / 40.0f)) * 20.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
            if (this.stand.orientation == 0) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (this.stand.orientation == 1) {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (this.stand.orientation == 3) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            TileRendererHatStand.renderBlocks.field_147845_a = this.stand.func_145831_w();
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            BlockRenderHatStand.instance.renderInventoryBlockWithTileEntity((BlockHatStand)HatStand.blockHatStand, this.stand, TileRendererHatStand.renderBlocks);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            HatInfoClient info = this.stand.info;
            if (this.tempInfo == null || info == null || !this.tempInfo.hatName.equalsIgnoreCase(this.stand.hatName) || this.tempInfo.colourR != this.stand.colourR || this.tempInfo.colourG != this.stand.colourG || this.tempInfo.colourB != this.stand.colourB || this.tempInfo.alpha != this.stand.alpha) {
                this.tempInfo = new HatInfoClient(this.stand.hatName, this.stand.colourR, this.stand.colourG, this.stand.colourB, this.stand.alpha);
            }
            this.stand.info = this.tempInfo;
            TileRendererHatStand.renderer.renderHatStand(this.stand, 0.0, 0.0, 0.0, 1.0f, this.stand.gameProfile);
            this.stand.info = info;
            GL11.glPopMatrix();
            GL11.glDisable((int)32826);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GL11.glDisable((int)3553);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        }
    }

    public void drawSearchBar() {
        if (this.searchBar.func_146176_q()) {
            this.searchBar.func_146194_f();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.field_146297_k.func_110434_K().func_110577_a(hats.client.gui.GuiHatSelection.texIcons);
            this.func_73729_b(this.field_146294_l / 2 - 85, this.field_146295_m - 22, 128, 0, 16, 16);
            GL11.glDisable((int)3042);
        }
    }

    public void onChangeSliderValue(GuiSlider slider) {
        if (slider.field_146127_k == 5) {
            this.stand.colourR = this.colourR = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
        } else if (slider.field_146127_k == 6) {
            this.stand.colourG = this.colourG = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
        } else if (slider.field_146127_k == 7) {
            this.stand.colourB = this.colourB = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
        } else if (slider.field_146127_k == 15) {
            this.stand.alpha = this.alpha = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
        }
    }
}

