/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.eplus.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.client.gui.GuiGraphicButton;
import net.darkhax.bookshelf.lib.util.EnchantmentUtils;
import net.epoxide.eplus.EnchantingPlus;
import net.epoxide.eplus.client.gui.GuiEnchantmentLabel;
import net.epoxide.eplus.common.network.PacketEnchant;
import net.epoxide.eplus.common.network.PacketGui;
import net.epoxide.eplus.common.network.PacketRepair;
import net.epoxide.eplus.handler.ConfigurationHandler;
import net.epoxide.eplus.inventory.ContainerEnchantTable;
import net.epoxide.eplus.tileentity.TileEntityEnchantTable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiModEnchantmentTable
extends GuiContainer {
    private final ResourceLocation texture = new ResourceLocation("eplus:textures/gui/enchant.png");
    private ArrayList<GuiEnchantmentLabel> enchantmentArray = new ArrayList();
    private final EntityPlayer player;
    private final ContainerEnchantTable container;
    private final int x;
    private final int y;
    private final int z;
    private static int guiOffset = 26;
    private double sliderIndex = 0.0;
    private double enchantingPages = 0.0;
    private Map<Integer, Integer> enchantments;
    private boolean clicked = false;
    private boolean sliding = false;
    private int totalCost = 0;
    private boolean dirty = false;
    private GuiEnchantmentLabel last;

    public GuiModEnchantmentTable(InventoryPlayer inventory, World world, int x, int y, int z, TileEntityEnchantTable tileEntity) {
        super((Container)new ContainerEnchantTable(inventory, world, x, y, z, tileEntity));
        this.player = inventory.field_70458_d;
        this.container = (ContainerEnchantTable)this.field_147002_h;
        this.x = x;
        this.y = y;
        this.z = z;
        this.field_146999_f = 235;
        this.field_147000_g = 182;
        this.field_73735_i = -1.0f;
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        HashMap<Integer, Integer> enchants = new HashMap<Integer, Integer>();
        for (GuiEnchantmentLabel label : this.enchantmentArray) {
            Integer id = this.enchantments.get(label.enchantment.field_77352_x);
            if (label.enchantmentLevel == id || label.locked) continue;
            enchants.put(label.enchantment.field_77352_x, label.enchantmentLevel);
        }
        switch (par1GuiButton.field_146127_k) {
            case 0: {
                if (enchants.size() > 0) {
                    EnchantingPlus.network.sendToServer((IMessage)new PacketEnchant(enchants, this.totalCost));
                }
                return;
            }
            case 1: {
                if (enchants.size() == 0 && ConfigurationHandler.allowRepairs) {
                    EnchantingPlus.network.sendToServer((IMessage)new PacketRepair(this.totalCost));
                }
                return;
            }
            case 2: {
                EnchantingPlus.network.sendToServer((IMessage)new PacketGui(this.player.getDisplayName(), 1, this.x, this.y, this.z));
            }
        }
    }

    private ArrayList<GuiEnchantmentLabel> convertMapToGuiItems(Map<Integer, Integer> map, int x, int y) {
        ArrayList<GuiEnchantmentLabel> temp = new ArrayList<GuiEnchantmentLabel>();
        if (map == null) {
            return temp;
        }
        int i = 0;
        int yPos = y;
        for (Integer obj : map.keySet()) {
            temp.add(new GuiEnchantmentLabel(this.container, obj, map.get(obj), x, yPos));
            yPos = y + ++i * 18;
        }
        return temp;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        boolean flag = Mouse.isButtonDown((int)0);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (GuiEnchantmentLabel label : this.enchantmentArray) {
            if (label.yPos < this.field_147009_r + 15 || label.yPos >= this.field_147009_r + 87) {
                label.show(false);
            } else {
                label.show(true);
            }
            label.draw(this.field_146289_q);
        }
        int adjustedMouseX = mouseX - this.field_147003_i;
        int adjustedMouseY = mouseY - this.field_147009_r;
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        int tempY = adjustedMouseY - 16;
        if (tempY <= 0) {
            tempY = 0;
        } else if (tempY >= 57) {
            tempY = 57;
        }
        double d = this.sliderIndex = this.sliding ? (double)Math.round((double)tempY / 57.0 * this.enchantingPages / 0.25) * 0.25 : this.sliderIndex;
        if (this.sliderIndex >= this.enchantingPages) {
            this.sliderIndex = this.enchantingPages;
        }
        double sliderY = this.sliding ? (double)tempY : 57.0 * (this.sliderIndex / this.enchantingPages);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i + guiOffset + 180, this.field_147009_r + 16 + (int)sliderY, 0, 182, 12, 15);
        if (!this.clicked && flag) {
            for (GuiEnchantmentLabel label : this.enchantmentArray) {
                if (this.getItemFromPos(mouseX, mouseY) != label || label.locked) continue;
                label.dragging = true;
            }
            if (adjustedMouseX <= 191 + guiOffset && adjustedMouseX >= 180 + guiOffset && this.enchantingPages != 0.0) {
                this.sliding = true;
            }
        }
        for (GuiEnchantmentLabel label : this.enchantmentArray) {
            if (!label.dragging || this.getItemFromPos(mouseX, mouseY) == label) continue;
            label.dragging = false;
            this.last = label;
        }
        if (!flag) {
            for (GuiEnchantmentLabel label : this.enchantmentArray) {
                if (this.getItemFromPos(mouseX, mouseY) != label) continue;
                label.dragging = false;
                this.last = label;
            }
            this.sliding = false;
        }
        this.clicked = flag;
        for (GuiEnchantmentLabel label : this.enchantmentArray) {
            if (!label.dragging) continue;
            label.scroll(adjustedMouseX - 36, guiOffset + this.field_147003_i + 10);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.updateEnchantmentLabels();
        int maxWidth = this.field_147003_i - 20;
        ArrayList<List> information = new ArrayList<List>();
        information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", StatCollector.func_74838_a((String)"tooltip.eplus.playerlevel"), this.player.field_71068_ca), maxWidth));
        if (this.container.tableInventory.func_70301_a(0) == null || this.levelChanged() || !this.levelChanged() && !this.container.tableInventory.func_70301_a(0).func_77951_h()) {
            boolean negExp;
            boolean exp = this.totalCost <= EnchantmentUtils.getExperienceFromLevel((int)1) && this.totalCost >= -EnchantmentUtils.getExperienceFromLevel((int)1);
            boolean bl = negExp = this.totalCost < 0;
            int finalCost = exp ? this.totalCost : (negExp ? -EnchantmentUtils.getLevelsFromExperience((int)(-this.totalCost)) : EnchantmentUtils.getLevelsFromExperience((int)this.totalCost));
            information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", exp ? StatCollector.func_74838_a((String)"tooltip.eplus.experienceGained") : StatCollector.func_74838_a((String)"tooltip.eplus.enchant"), finalCost), maxWidth));
        } else if (ConfigurationHandler.allowRepairs && !this.levelChanged() && this.container.tableInventory.func_70301_a(0).func_77951_h()) {
            information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", StatCollector.func_74838_a((String)"tooltip.eplus.repair"), EnchantmentUtils.getLevelsFromExperience((int)this.totalCost)), maxWidth));
        }
        information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", StatCollector.func_74838_a((String)"tooltip.eplus.maxlevel"), Float.valueOf(this.container.bookCases())), maxWidth));
        for (List display : information) {
            int height;
            int n = height = information.indexOf(display) == 0 ? this.field_147009_r + this.field_146289_q.field_78288_b + 8 : this.field_147009_r + (this.field_146289_q.field_78288_b + 8) * (information.indexOf(display) + 1);
            if (information.indexOf(display) > 0) {
                for (int i = information.indexOf(display) - 1; i >= 0; --i) {
                    height += (this.field_146289_q.field_78288_b + 3) * (((List)information.get(i)).size() - 1);
                }
            }
            try {
                this.drawHoveringText(display, this.field_147003_i - 20 - maxWidth, height, this.field_146289_q);
            }
            catch (NoSuchMethodError e) {
                StringBuilder sb = new StringBuilder();
                for (String text : display) {
                    sb.append(text);
                    sb.append(" ");
                }
                this.func_146279_a(sb.toString(), this.field_147003_i - 20 - maxWidth, height);
            }
        }
        GuiEnchantmentLabel label = this.getItemFromPos(mouseX, mouseY);
        if (GuiModEnchantmentTable.func_146272_n() && label != null && label.enchantment != null) {
            String enchName = EnumChatFormatting.BOLD + label.getTranslatedName();
            String description = StatCollector.func_74838_a((String)("description." + label.enchantment.func_77320_a()));
            description = description.startsWith("description.") ? EnumChatFormatting.RED + StatCollector.func_74838_a((String)"tooltip.eplus.nodesc") : EnumChatFormatting.LIGHT_PURPLE + description;
            ArrayList<String> display = new ArrayList<String>();
            display.add(enchName);
            display.addAll(this.field_146289_q.func_78271_c(description, 215));
            try {
                this.drawHoveringText(display, mouseX, mouseY, this.field_146289_q);
            }
            catch (NoSuchMethodError e) {
                StringBuilder sb = new StringBuilder();
                for (String text : display) {
                    sb.append(text);
                    sb.append(" ");
                }
                this.func_146279_a(sb.toString(), this.field_147003_i - 20 - maxWidth, this.field_146295_m);
            }
        }
    }

    private GuiEnchantmentLabel getItemFromPos(int x, int y) {
        if (x < this.field_147003_i + guiOffset + 35 || x > this.field_147003_i + this.field_146999_f - 32) {
            return null;
        }
        for (GuiEnchantmentLabel label : this.enchantmentArray) {
            if (!label.show || y < label.yPos || y > label.yPos + label.height) continue;
            return label;
        }
        return null;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int eventDWheel = Mouse.getEventDWheel();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.field_147009_r;
        if (eventDWheel != 0 && (mouseX >= 35 + guiOffset && mouseX <= this.field_146999_f + guiOffset - 32 || mouseX >= 180 + guiOffset && mouseX <= 192 + guiOffset) && mouseY >= 15 && mouseY <= 87) {
            if (eventDWheel < 0) {
                this.sliderIndex += 0.25;
                if (this.sliderIndex >= this.enchantingPages) {
                    this.sliderIndex = this.enchantingPages;
                }
            } else {
                this.sliderIndex -= 0.25;
                if (this.sliderIndex <= 0.0) {
                    this.sliderIndex = 0.0;
                }
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiGraphicButton(0, this.field_147003_i + guiOffset + 9, this.field_147009_r + 38, "eplus:textures/gui/button_enchant"));
        this.field_146292_n.add(new GuiGraphicButton(1, this.field_147003_i + guiOffset + 9, this.field_147009_r + 63, "eplus:textures/gui/button_repair"));
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i - 20, this.field_147009_r + 110, this.field_146289_q.func_78256_a(StatCollector.func_74838_a((String)"gui.button.eplus.vanilla")) + 10, 20, StatCollector.func_74838_a((String)"Vanilla")));
        this.dirty = true;
    }

    protected boolean levelChanged() {
        for (GuiEnchantmentLabel label : this.enchantmentArray) {
            if (label.enchantmentLevel == label.currentLevel) continue;
            return true;
        }
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        Map<Integer, Integer> enchantments = this.updateEnchantments(this.container.getEnchantments());
        this.handleChangedScreenSize(enchantments);
        this.updateEnchantmentLabels();
        this.enchantingPages = (double)this.enchantmentArray.size() / 4.0 > 1.0 ? (double)this.enchantmentArray.size() / 4.0 - 1.0 : 0.0;
        this.totalCost = 0;
        this.handleChangedEnchantments(enchantments);
    }

    private void updateEnchantmentLabels() {
        for (GuiEnchantmentLabel label : this.enchantmentArray) {
            label.locked = false;
        }
        int i = 0;
        for (GuiEnchantmentLabel mainLabel : this.enchantmentArray) {
            if (mainLabel.enchantmentLevel != 0) {
                ++i;
                for (GuiEnchantmentLabel otherLabel : this.enchantmentArray) {
                    if (mainLabel == otherLabel || EnchantmentUtils.areEnchantmentsCompatible((Enchantment)mainLabel.enchantment, (Enchantment)otherLabel.enchantment)) continue;
                    otherLabel.locked = true;
                }
                continue;
            }
            if (this.player.field_71075_bZ.field_75098_d || ConfigurationHandler.maxEnchantmentAmount <= 0 || i < ConfigurationHandler.maxEnchantmentAmount) continue;
            mainLabel.locked = true;
        }
    }

    private void handleChangedEnchantments(Map<Integer, Integer> enchantments) {
        if (!this.enchantmentArray.isEmpty() && this.levelChanged()) {
            for (GuiEnchantmentLabel label : this.enchantmentArray) {
                if (label == this.last) continue;
                this.handleChangedEnchantment(enchantments, label);
            }
            if (this.last != null) {
                this.handleChangedEnchantment(enchantments, this.last);
            }
        } else if (ConfigurationHandler.allowRepairs && !this.levelChanged()) {
            this.totalCost += this.container.repairCostMax();
            for (GuiEnchantmentLabel label : this.enchantmentArray) {
                label.yPos = label.startingYPos - (int)(72.0 * this.sliderIndex);
            }
        }
    }

    private void handleChangedEnchantment(Map<Integer, Integer> enchantments, GuiEnchantmentLabel label) {
        label.yPos = label.startingYPos - (int)(72.0 * this.sliderIndex);
        Integer level = enchantments.get(label.enchantment.field_77352_x);
        if (!label.locked && label.enchantmentLevel > level) {
            int temp = this.totalCost + this.container.enchantmentCost(label.enchantment, label.enchantmentLevel, level);
            if (!this.container.canPurchase(this.player, temp)) {
                while (label.enchantmentLevel > 0) {
                    label.dragging = false;
                    --label.enchantmentLevel;
                    temp = this.totalCost + this.container.enchantmentCost(label.enchantment, label.enchantmentLevel, level);
                    if (!this.container.canPurchase(this.player, temp)) continue;
                }
            }
            this.totalCost = temp;
        } else if (label.enchantmentLevel < level && !label.locked) {
            this.totalCost += this.container.disenchantmentCost(label.enchantment, label.enchantmentLevel, level);
        }
    }

    private void handleChangedScreenSize(Map<Integer, Integer> enchantments) {
        if (this.dirty) {
            ArrayList<GuiEnchantmentLabel> temp = this.convertMapToGuiItems(enchantments, 35 + guiOffset + this.field_147003_i, 15 + this.field_147009_r);
            for (GuiEnchantmentLabel label : this.enchantmentArray) {
                for (GuiEnchantmentLabel tempItem : temp) {
                    if (label.enchantment != tempItem.enchantment) continue;
                    label.startingXPos = label.xPos = tempItem.xPos;
                    label.startingYPos = label.yPos = tempItem.yPos;
                }
            }
            this.dirty = false;
        }
    }

    private Map<Integer, Integer> updateEnchantments(Map<Integer, Integer> enchantments) {
        if (this.enchantments != enchantments) {
            this.enchantments = enchantments;
            this.enchantmentArray = this.convertMapToGuiItems(enchantments, 35 + guiOffset + this.field_147003_i, 15 + this.field_147009_r);
            this.enchantingPages = 0.0;
            this.sliderIndex = 0.0;
            this.sliding = false;
            this.clicked = false;
            return this.enchantments;
        }
        return enchantments;
    }
}

