/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.eplus.common;

import com.google.common.primitives.Ints;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.epoxide.eplus.EnchantingPlus;
import net.epoxide.eplus.common.network.PacketSyncPlayerProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public final class PlayerProperties
implements IExtendedEntityProperties {
    public static final String PROP_NAME = "EnchantingPlusData";
    public EntityPlayer player;
    public List<Integer> unlockedEnchantments;

    private PlayerProperties(EntityPlayer player) {
        this.player = player;
        this.unlockedEnchantments = new LinkedList<Integer>();
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound playerData = new NBTTagCompound();
        playerData.func_74783_a("unlockedEnchantments", Ints.toArray(this.unlockedEnchantments));
        compound.func_74782_a(PROP_NAME, (NBTBase)playerData);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound playerData = compound.func_74775_l(PROP_NAME);
        ArrayList<Integer> enchantments = new ArrayList<Integer>();
        enchantments.addAll(Ints.asList((int[])playerData.func_74759_k("unlockedEnchantments")));
        this.unlockedEnchantments = enchantments;
    }

    public void init(Entity entity, World world) {
    }

    public void sync() {
        if (this.player instanceof EntityPlayerMP) {
            EnchantingPlus.network.sendTo((IMessage)new PacketSyncPlayerProperties(this), (EntityPlayerMP)this.player);
        }
    }

    public static PlayerProperties getProperties(EntityPlayer player) {
        return (PlayerProperties)player.getExtendedProperties(PROP_NAME);
    }

    public static PlayerProperties setProperties(EntityPlayer player) {
        player.registerExtendedProperties(PROP_NAME, (IExtendedEntityProperties)new PlayerProperties(player));
        return PlayerProperties.getProperties(player);
    }

    public static boolean hasProperties(EntityPlayer player) {
        return PlayerProperties.getProperties(player) != null;
    }

    public void copy(PlayerProperties properties) {
        this.unlockedEnchantments = properties.unlockedEnchantments;
    }
}

