/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.eplus.common.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.darkhax.bookshelf.common.network.AbstractMessage;
import net.epoxide.eplus.inventory.ContainerEnchantTable;
import net.minecraft.entity.player.EntityPlayer;

public class PacketEnchant
extends AbstractMessage {
    protected int totalCost;
    protected HashMap<Integer, Integer> enchants = new HashMap();

    public PacketEnchant() {
    }

    public PacketEnchant(HashMap<Integer, Integer> enchants, int totalCost) {
        this.enchants = enchants;
        this.totalCost = totalCost;
    }

    public void handleClientMessage(AbstractMessage message, EntityPlayer player) {
    }

    public void handleServerMessage(AbstractMessage message, EntityPlayer player) {
        if (message instanceof PacketEnchant) {
            PacketEnchant packet = (PacketEnchant)message;
            if (player.field_71070_bA instanceof ContainerEnchantTable) {
                ((ContainerEnchantTable)player.field_71070_bA).updateItemStack(player, packet.enchants, packet.totalCost);
                player.field_71070_bA.func_75142_b();
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        HashMap<Integer, Integer> enchants = new HashMap<Integer, Integer>();
        this.totalCost = buf.readInt();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            enchants.put(buf.readInt(), buf.readInt());
        }
        this.enchants = enchants;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.totalCost);
        buf.writeInt(this.enchants.size());
        for (Integer enchantmentId : this.enchants.keySet()) {
            buf.writeInt(enchantmentId.intValue());
            buf.writeInt(this.enchants.get(enchantmentId).intValue());
        }
    }
}

