/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.eplus.handler;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.buff.Buff;
import net.darkhax.bookshelf.common.BookshelfRegistry;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.Utilities;
import net.epoxide.eplus.EnchantingPlus;
import net.epoxide.eplus.block.BlockArcaneInscriber;
import net.epoxide.eplus.block.BlockEnchantTable;
import net.epoxide.eplus.block.BlockEnchantmentBook;
import net.epoxide.eplus.buff.BuffBookFall;
import net.epoxide.eplus.handler.ConfigurationHandler;
import net.epoxide.eplus.handler.VillagerHandler;
import net.epoxide.eplus.item.ItemBlockEnchantmentBook;
import net.epoxide.eplus.item.ItemBookSummoner;
import net.epoxide.eplus.item.ItemEnchantedScroll;
import net.epoxide.eplus.item.ItemTableUpgrade;
import net.epoxide.eplus.modifiers.ScrollModifier;
import net.epoxide.eplus.tileentity.TileEntityArcaneInscriber;
import net.epoxide.eplus.tileentity.TileEntityEnchantTable;
import net.epoxide.eplus.tileentity.TileEntityEnchantmentBook;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.ChestGenHooks;
import org.apache.commons.lang3.StringUtils;

public final class ContentHandler {
    private static List<Integer> blacklistEnchantments = new ArrayList<Integer>();
    private static List<String> blacklistItems = new ArrayList<String>();
    private static Map<String, Integer> colorMap = new HashMap<String, Integer>();
    public static List<ScrollModifier> modifiers = new ArrayList<ScrollModifier>();
    public static ChestGenHooks eplusChest = new ChestGenHooks("EplusChest", new WeightedRandomChestContent[0], 3, 7);
    public static int achievementCount = 0;
    public static Block blockAdvancedTable;
    public static Block blockArcaneInscriber;
    public static Block blockEnchantmentBook;
    public static Item itemTableUpgrage;
    public static Item itemScroll;
    public static Item itemFloatingBook;
    public static Buff buffFloatingBook;
    public static AchievementPage achievementPageEplus;
    public static Achievement achievementEnchanter;
    public static Achievement achievementRepair;
    public static Achievement achievementStudies;
    public static Achievement achievementResearch;
    public static Achievement achievementEnlightened;

    public static void initBlocks() {
        blockAdvancedTable = new BlockEnchantTable();
        GameRegistry.registerBlock((Block)blockAdvancedTable, (String)"advancedEnchantmentTable");
        GameRegistry.registerTileEntity(TileEntityEnchantTable.class, (String)"eplus:advancedEnchantmentTable");
        blockArcaneInscriber = new BlockArcaneInscriber();
        GameRegistry.registerBlock((Block)blockArcaneInscriber, (String)"arcane_inscriber");
        GameRegistry.registerTileEntity(TileEntityArcaneInscriber.class, (String)"eplus:arcane_inscriber");
        blockEnchantmentBook = new BlockEnchantmentBook();
        GameRegistry.registerBlock((Block)blockEnchantmentBook, ItemBlockEnchantmentBook.class, (String)"enchantment_book");
        GameRegistry.registerTileEntity(TileEntityEnchantmentBook.class, (String)"eplus:enchantment_book");
    }

    public static void initItems() {
        itemTableUpgrage = new ItemTableUpgrade();
        GameRegistry.registerItem((Item)itemTableUpgrage, (String)"tableUpgrade");
        itemScroll = new ItemEnchantedScroll();
        GameRegistry.registerItem((Item)itemScroll, (String)"enchantment_scroll");
        itemFloatingBook = new ItemBookSummoner();
        GameRegistry.registerItem((Item)itemFloatingBook, (String)"tomb_guardian");
    }

    public static void initEnchantmentColors() {
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.all, 15029174);
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.armor, 10394268);
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.armor_feet, 10394268);
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.armor_legs, 10394268);
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.armor_torso, 10394268);
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.armor_head, 10394268);
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.weapon, 0xFF0000);
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.digger, 9127187);
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.fishing_rod, 1596073);
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.breakable, 10394268);
        ContentHandler.setEnchantmentColor(EnumEnchantmentType.bow, 29696);
    }

    public static void initModifiers() {
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Items.field_151065_br), -0.05f, 0.1f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Blocks.field_150343_Z), 0.1f, -0.05f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Items.field_151045_i), 0.25f, -0.05f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Items.field_151166_bC), -0.05f, 0.25f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Items.field_151079_bi), 0.05f, 0.0f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Blocks.field_150426_aN), 0.0f, 0.05f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Items.field_151061_bv), 0.0f, 0.1f, false));
    }

    public static void initRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemTableUpgrage), (Object[])new Object[]{"gbg", "o o", "geg", Character.valueOf('b'), Items.field_151099_bA, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('g'), Items.field_151043_k});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvancedTable), (Object[])new Object[]{"gbg", "oto", "geg", Character.valueOf('b'), Items.field_151099_bA, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('t'), Blocks.field_150381_bn});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockArcaneInscriber), (Object[])new Object[]{"fpi", "bcb", Character.valueOf('f'), Items.field_151008_G, Character.valueOf('p'), Items.field_151121_aF, Character.valueOf('i'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('b'), Blocks.field_150342_X, Character.valueOf('c'), Blocks.field_150462_ai});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockEnchantmentBook), (Object[])new Object[]{" g ", "gbg", " g ", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('b'), Items.field_151134_bR});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockAdvancedTable), (Object[])new Object[]{Blocks.field_150381_bn, itemTableUpgrage});
    }

    public static void initMisc() {
        buffFloatingBook = new BuffBookFall();
        BookshelfRegistry.registerBuff((Buff)buffFloatingBook);
        VillagerHandler.initVillageHandler();
        for (String entry : ConfigurationHandler.blacklistedItems) {
            ContentHandler.addItemToBlacklist(entry, "Configuration File");
        }
        for (String entry : ConfigurationHandler.blacklistedEnchantments) {
            if (!StringUtils.isNumeric((CharSequence)entry)) continue;
            ContentHandler.blacklistEnchantment(Integer.parseInt(entry), "Configuration File");
        }
        if (Loader.isModLoaded((String)"NotEnoughItems")) {
            ContentHandler.addInformation(blockAdvancedTable);
            ContentHandler.addInformation(blockArcaneInscriber);
            ContentHandler.addInformation(blockEnchantmentBook);
            ContentHandler.addInformation(itemTableUpgrage);
            ContentHandler.addInformation(itemScroll);
            ContentHandler.addInformation(itemFloatingBook);
        }
    }

    public static void initAchievements() {
        achievementEnchanter = ContentHandler.registerAchievement("eplus.enchanter", Item.func_150898_a((Block)blockAdvancedTable));
        achievementRepair = ContentHandler.registerAchievement("eplus.repair", Item.func_150898_a((Block)Blocks.field_150467_bQ));
        achievementStudies = ContentHandler.registerAchievement("eplus.study", Item.func_150898_a((Block)blockArcaneInscriber));
        achievementResearch = ContentHandler.registerAchievement("eplus.research", itemScroll);
        achievementEnlightened = ContentHandler.registerAchievement("eplus.enlightened", Item.func_150898_a((Block)blockEnchantmentBook));
        achievementPageEplus = new AchievementPage("Enchanting Plus", new Achievement[]{achievementEnchanter, achievementRepair, achievementStudies, achievementResearch, achievementEnlightened});
        AchievementPage.registerAchievementPage((AchievementPage)achievementPageEplus);
    }

    public static void registerDungeonLoot() {
        ChestGenHooks contents = ChestGenHooks.getInfo((String)"EPLUSSCROLLS");
        for (Enchantment enchantment : Utilities.getAvailableEnchantments()) {
            if (ContentHandler.isBlacklisted(enchantment)) continue;
            WeightedRandomChestContent scrollEntry = new WeightedRandomChestContent(ItemEnchantedScroll.createScroll(enchantment), 1, 1, 2);
            for (String type : Utilities.vanillaLootChests) {
                ChestGenHooks.addItem((String)type, (WeightedRandomChestContent)scrollEntry);
            }
            eplusChest.addItem(scrollEntry);
        }
        eplusChest.addItem(new WeightedRandomChestContent(new ItemStack(blockEnchantmentBook), 1, 3, 2));
        eplusChest.addItem(new WeightedRandomChestContent(new ItemStack(Items.field_151121_aF), 1, 3, 2));
        eplusChest.addItem(new WeightedRandomChestContent(new ItemStack(Items.field_151062_by), 1, 5, 2));
    }

    public static void blacklistEnchantment(Enchantment enchant, String blacklister) {
        ContentHandler.blacklistEnchantment(enchant.field_77352_x, blacklister);
    }

    public static void blacklistEnchantment(int enchantID, String blacklister) {
        if (!blacklistEnchantments.contains(enchantID)) {
            blacklistEnchantments.add(enchantID);
            EnchantingPlus.printDebugMessage(blacklister + " has succesfully blacklisted an enchantment with the ID of " + enchantID);
        }
    }

    public static void addItemToBlacklist(ItemStack stack, String blacklister) {
        if (ItemStackUtils.isValidStack((ItemStack)stack)) {
            ContentHandler.addItemToBlacklist(stack.func_77973_b(), blacklister);
        }
    }

    public static void addItemToBlacklist(Item item, String blacklister) {
        ContentHandler.addItemToBlacklist(GameData.getItemRegistry().func_148750_c((Object)item), blacklister);
    }

    public static void addItemToBlacklist(String name, String blacklister) {
        if (!blacklistItems.contains(name)) {
            blacklistItems.add(name);
            EnchantingPlus.printDebugMessage(blacklister + " has successfully blacklisted " + name);
        }
    }

    public static boolean isBlacklisted(Enchantment enchant) {
        return blacklistEnchantments.contains(enchant.field_77352_x);
    }

    public static boolean isBlacklisted(ItemStack stack) {
        return !ItemStackUtils.isValidStack((ItemStack)stack) || ContentHandler.isBlacklisted(stack.func_77973_b());
    }

    public static boolean isBlacklisted(Item item) {
        return blacklistItems.contains(GameData.getItemRegistry().func_148750_c((Object)item));
    }

    public static int getEnchantmentColor(String enchType) {
        return colorMap.containsKey(enchType) ? colorMap.get(enchType) : 0xFFFFFF;
    }

    public static void setEnchantmentColor(EnumEnchantmentType enchType, int color) {
        ContentHandler.setEnchantmentColor(enchType.name(), color);
    }

    public static void setEnchantmentColor(String enchType, int color) {
        if (!colorMap.containsKey(enchType)) {
            colorMap.put(enchType, color);
            EnchantingPlus.printDebugMessage("The color of enchantment type " + enchType + " has been set to " + color);
        }
    }

    public static void addScrollModifier(ScrollModifier modifier) {
        modifiers.add(modifier);
    }

    public static ScrollModifier findScrollModifier(ItemStack stack) {
        for (ScrollModifier modifier : modifiers) {
            if (!ItemStackUtils.areStacksSimilar((ItemStack)modifier.stack, (ItemStack)stack)) continue;
            return modifier;
        }
        return null;
    }

    private static void addInformation(Item item) {
        BookshelfRegistry.addInformation((Item)item, (String)("info." + item.func_77658_a()));
    }

    private static void addInformation(Block block) {
        BookshelfRegistry.addInformation((Block)block, (String)("info." + block.func_149739_a()));
    }

    public static Achievement registerAchievement(String key, Item item) {
        int posX = achievementCount % 8;
        int posY = achievementCount / 8;
        ++achievementCount;
        return new Achievement(key, key, posX, posY + 1, item, null).func_75971_g();
    }
}

