/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.eplus.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.List;
import net.darkhax.bookshelf.event.ItemEnchantedEvent;
import net.darkhax.bookshelf.lib.util.EnchantmentUtils;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.MathsUtils;
import net.darkhax.bookshelf.lib.util.Utilities;
import net.epoxide.eplus.block.BlockEnchantmentBook;
import net.epoxide.eplus.client.gui.GuiModEnchantmentTable;
import net.epoxide.eplus.common.PlayerProperties;
import net.epoxide.eplus.handler.ConfigurationHandler;
import net.epoxide.eplus.handler.ContentHandler;
import net.epoxide.eplus.inventory.EnchantHelper;
import net.epoxide.eplus.item.ItemEnchantedScroll;
import net.epoxide.eplus.modifiers.ScrollModifier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public final class ForgeEventHandler {
    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (ItemStackUtils.isValidStack((ItemStack)event.crafting) && Block.func_149634_a((Item)event.crafting.func_77973_b()) instanceof BlockEnchantmentBook) {
            event.player.func_71029_a((StatBase)ContentHandler.achievementEnlightened);
        }
    }

    @SubscribeEvent
    public void onItemPickedUp(PlayerEvent.ItemPickupEvent event) {
        if (ItemStackUtils.isValidStack((ItemStack)event.pickedUp.func_92059_d()) && event.pickedUp.func_92059_d().func_77973_b() instanceof ItemEnchantedScroll) {
            event.player.func_71029_a((StatBase)ContentHandler.achievementResearch);
        }
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        if (event.entityLiving instanceof EntityMob && MathsUtils.tryPercentage((double)(ConfigurationHandler.scrollDrop * (float)(event.lootingLevel + 1)))) {
            event.drops.add(new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70136_U, ItemEnchantedScroll.createRandomScroll()));
        }
    }

    @SubscribeEvent
    public void onItemEnchanted(ItemEnchantedEvent event) {
        if (!event.entityPlayer.field_71075_bZ.field_75098_d && ItemStackUtils.isValidStack((ItemStack)event.stack)) {
            ItemStackUtils.prepareDataTag((ItemStack)event.stack).func_74778_a("enchantedOwnerUUID", event.entityPlayer.func_110124_au().toString());
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (ConfigurationHandler.allowModifierTooltips && ItemStackUtils.isValidStack((ItemStack)event.itemStack)) {
            for (ScrollModifier modifier : ContentHandler.modifiers) {
                boolean isPositive;
                if (!ItemStackUtils.areStacksSimilar((ItemStack)event.itemStack, (ItemStack)modifier.stack)) continue;
                event.toolTip.add(EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)"tooltip.eplus.modifier"));
                if ((double)modifier.speed != 0.0) {
                    isPositive = (double)modifier.speed > 0.0;
                    event.toolTip.add((isPositive ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + StatCollector.func_74838_a((String)"tooltip.eplus.speed") + ": " + (isPositive ? "+" : "") + modifier.speed * 100.0f + "%");
                }
                if ((double)modifier.stability == 0.0) continue;
                isPositive = (double)modifier.stability > 0.0;
                event.toolTip.add((isPositive ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + StatCollector.func_74838_a((String)"tooltip.eplus.stability") + ": " + (isPositive ? "+" : "") + modifier.stability * 100.0f + "%");
            }
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiModEnchantmentTable && (!ConfigurationHandler.allowUnownedModifications && !EnchantHelper.hasRestriction(event.itemStack) && EnchantmentUtils.isStackEnchanted((ItemStack)event.itemStack) || ConfigurationHandler.secureItems && EnchantHelper.hasRestriction(event.itemStack) && !EnchantHelper.isValidOwner(event.itemStack, event.entityPlayer))) {
            Utilities.wrapStringToListWithFormat((String)StatCollector.func_74838_a((String)"tooltip.eplus.notowner"), (int)30, (boolean)false, (List)event.toolTip, (EnumChatFormatting)EnumChatFormatting.RED);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerProperties.getProperties(event.entityPlayer).copy(PlayerProperties.getProperties(event.original));
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && !PlayerProperties.hasProperties((EntityPlayer)event.entity)) {
            PlayerProperties.setProperties((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer && !event.entity.field_70170_p.field_72995_K && PlayerProperties.hasProperties((EntityPlayer)event.entity)) {
            PlayerProperties.getProperties((EntityPlayer)event.entity).sync();
        }
    }
}

