/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.eplus.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.darkhax.bookshelf.lib.util.EnchantmentUtils;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.Utilities;
import net.epoxide.eplus.handler.ConfigurationHandler;
import net.epoxide.eplus.handler.ContentHandler;
import net.epoxide.eplus.inventory.EnchantHelper;
import net.epoxide.eplus.inventory.SlotEnchant;
import net.epoxide.eplus.inventory.SlotEnchantTable;
import net.epoxide.eplus.lib.Constants;
import net.epoxide.eplus.tileentity.TileEntityEnchantTable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ContainerEnchantTable
extends Container {
    public final World world;
    private final TileEntityEnchantTable tileEnchantTable;
    private final int x;
    private final int y;
    private final int z;
    private final EntityPlayer player;
    private Map<Integer, Integer> enchantments = new HashMap<Integer, Integer>();
    public final IInventory tableInventory = new SlotEnchantTable(this, "Enchant", true, 1);

    public ContainerEnchantTable(InventoryPlayer inventoryPlayer, World world, int x, int y, int z, TileEntityEnchantTable tileEntityTable) {
        int l;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.tileEnchantTable = tileEntityTable;
        this.player = inventoryPlayer.field_70458_d;
        int guiOffest = 26;
        this.func_75146_a(new SlotEnchant(this, this.tableInventory, 0, 11 + guiOffest, 17));
        for (l = 0; l < 3; ++l) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, i1 + l * 9 + 9, 17 + i1 * 18 + guiOffest, 91 + l * 18));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, l, 17 + l * 18 + guiOffest, 149));
        }
        for (int k = 0; k < 4; ++k) {
            final int armorType = k;
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, 39 - k, 7, 24 + k * 19){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack par1ItemStack) {
                    Item item = par1ItemStack == null ? null : par1ItemStack.func_77973_b();
                    return item != null && item.isValidArmor(par1ItemStack, armorType, (Entity)ContainerEnchantTable.this.player);
                }
            });
        }
        if (this.tileEnchantTable.itemInTable != null) {
            this.player.func_70099_a(this.tileEnchantTable.itemInTable, 0.2f);
            this.tileEnchantTable.itemInTable.field_77994_a = 0;
        }
    }

    public float bookCases() {
        float temp = ConfigurationHandler.minimumBookshelfs;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0 || !this.world.func_147437_c(this.x + k, this.y, this.z + j) || !this.world.func_147437_c(this.x + k, this.y + 1, this.z + j)) continue;
                temp += ForgeHooks.getEnchantPower((World)this.world, (int)(this.x + k * 2), (int)this.y, (int)(this.z + j * 2));
                temp += ForgeHooks.getEnchantPower((World)this.world, (int)(this.x + k * 2), (int)(this.y + 1), (int)(this.z + j * 2));
                if (k == 0 || j == 0) continue;
                temp += ForgeHooks.getEnchantPower((World)this.world, (int)(this.x + k * 2), (int)this.y, (int)(this.z + j));
                temp += ForgeHooks.getEnchantPower((World)this.world, (int)(this.x + k * 2), (int)(this.y + 1), (int)(this.z + j));
                temp += ForgeHooks.getEnchantPower((World)this.world, (int)(this.x + k), (int)this.y, (int)(this.z + j * 2));
                temp += ForgeHooks.getEnchantPower((World)this.world, (int)(this.x + k), (int)(this.y + 1), (int)(this.z + j * 2));
            }
        }
        return temp * 2.0f;
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) <= 64.0 && !entityPlayer.field_70128_L;
    }

    public boolean canPurchase(EntityPlayer player, int cost) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int expLevel = EnchantmentUtils.getLevelsFromExperience((int)cost);
        if (ConfigurationHandler.needsBookShelves && (float)expLevel > this.bookCases()) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.eplus.morebooks") + " " + expLevel));
            return false;
        }
        if (player.field_71068_ca < expLevel) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.eplus.morelevels") + " " + expLevel));
            return false;
        }
        return true;
    }

    public int disenchantmentCost(Enchantment enchantment, int enchantmentLevel, Integer existingLevel) {
        int newCost;
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (!ItemStackUtils.isValidStack((ItemStack)itemStack) && enchantmentLevel > enchantment.func_77325_b()) {
            return 0;
        }
        int oldCost = (int)((float)((enchantment.func_77317_b(existingLevel.intValue()) - itemStack.func_77973_b().getItemEnchantability(itemStack)) / 2) * ConfigurationHandler.costFactor);
        int returnAmount = (oldCost - (newCost = (int)((float)((enchantment.func_77317_b(enchantmentLevel) - itemStack.func_77973_b().getItemEnchantability(itemStack)) / 2) * ConfigurationHandler.costFactor))) / 2;
        return -EnchantmentUtils.getExperienceFromLevel((int)(returnAmount > 0 ? returnAmount : 0));
    }

    public void updateItemStack(EntityPlayer player, HashMap<Integer, Integer> map, int cost) {
        Integer level;
        ItemStack itemstack = this.tableInventory.func_70301_a(0);
        ArrayList<Integer> temp = new ArrayList<Integer>();
        int serverCost = 0;
        if (itemstack == null) {
            return;
        }
        for (Integer enchantId : map.keySet()) {
            level = map.get(enchantId);
            Integer startingLevel = this.enchantments.get(enchantId);
            Enchantment enchantment = Utilities.getEnchantment((int)enchantId);
            if (level > startingLevel) {
                serverCost += this.enchantmentCost(enchantment, level, startingLevel);
                continue;
            }
            if (level >= startingLevel) continue;
            serverCost += this.disenchantmentCost(enchantment, level, startingLevel);
        }
        if (cost != serverCost) {
            Constants.LOG.warn(player.func_70005_c_() + " tried to enchant " + itemstack.func_82833_r() + " but the costs were not in sync!");
            return;
        }
        for (Integer enchantId : this.enchantments.keySet()) {
            level = this.enchantments.get(enchantId);
            if (level == 0 || map.containsKey(enchantId)) continue;
            map.put(enchantId, level);
        }
        for (Integer enchantId : map.keySet()) {
            level = map.get(enchantId);
            if (level != 0) continue;
            temp.add(enchantId);
        }
        for (Integer object : temp) {
            map.remove(object);
        }
        if (this.canPurchase(player, serverCost)) {
            ArrayList<EnchantmentData> enchantmentDataList = new ArrayList<EnchantmentData>();
            for (Integer i : map.keySet()) {
                enchantmentDataList.add(new EnchantmentData(i.intValue(), map.get(i).intValue()));
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (serverCost < 0) {
                    player.func_71023_q(-serverCost);
                } else {
                    player.func_82242_a(-EnchantmentUtils.getLevelsFromExperience((int)serverCost));
                }
            }
            ItemStack itemStack = EnchantHelper.updateEnchantments(enchantmentDataList, itemstack, player, cost);
            this.tableInventory.func_70299_a(0, itemStack);
        }
        this.func_75130_a(this.tableInventory);
    }

    public int enchantmentCost(Enchantment enchantment, int enchantmentLevel, Integer level) {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null || enchantmentLevel > enchantment.func_77325_b()) {
            return 0;
        }
        return EnchantmentUtils.getExperienceFromLevel((int)EnchantHelper.calculateEnchantmentCost(enchantment, enchantmentLevel + level, itemStack));
    }

    public Map<Integer, Integer> getEnchantments() {
        return this.enchantments;
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        for (int i = 0; i < this.tableInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.tableInventory.func_70301_a(i);
            if (stack == null || par1EntityPlayer.field_71071_by.func_70441_a(stack)) continue;
            par1EntityPlayer.func_70099_a(stack, 0.2f);
        }
    }

    public void func_75130_a(IInventory par1IInventory) {
        super.func_75130_a(par1IInventory);
        this.tileEnchantTable.func_145831_w().func_147471_g(this.tileEnchantTable.field_145851_c, this.tileEnchantTable.field_145848_d, this.tileEnchantTable.field_145849_e);
        this.readItems();
    }

    private void readItems() {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        LinkedHashMap<Integer, Integer> temp = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> temp2 = new LinkedHashMap<Integer, Integer>();
        if (itemStack == null || ContentHandler.isBlacklisted(itemStack.func_77973_b())) {
            this.enchantments = temp;
            return;
        }
        if (!ConfigurationHandler.allowUnownedModifications && !EnchantHelper.hasRestriction(itemStack) && EnchantmentUtils.isStackEnchanted((ItemStack)itemStack) || ConfigurationHandler.secureItems && EnchantHelper.hasRestriction(itemStack) && !EnchantHelper.isValidOwner(itemStack, this.player)) {
            return;
        }
        if (EnchantmentUtils.isItemEnchantable((ItemStack)itemStack)) {
            this.addEnchantsFor(itemStack, temp);
        } else if (EnchantmentUtils.isStackEnchanted((ItemStack)itemStack) && EnchantHelper.isNewItemEnchantable(itemStack.func_77973_b())) {
            temp.putAll(EnchantmentHelper.func_82781_a((ItemStack)itemStack));
            for (Enchantment enchant : Enchantment.field_77331_b) {
                if (enchant == null) continue;
                boolean add = true;
                for (Integer enc : ((HashMap)temp).keySet()) {
                    Enchantment enchantment = Utilities.getEnchantment((int)enc);
                    if (enchantment == null || EnchantmentUtils.areEnchantmentsCompatible((Enchantment)enchantment, (Enchantment)enchant)) continue;
                    add = false;
                }
                if (!add) continue;
                this.addEnchantFor(itemStack, temp2, enchant);
            }
            temp.putAll(temp2);
        }
        if (this.enchantments != temp) {
            this.enchantments = temp;
        }
    }

    private void addEnchantsFor(ItemStack itemStack, HashMap<Integer, Integer> temp) {
        for (Enchantment obj : Enchantment.field_77331_b) {
            this.addEnchantFor(itemStack, temp, obj);
        }
    }

    private void addEnchantFor(ItemStack itemStack, HashMap<Integer, Integer> temp, Enchantment obj) {
        if (EnchantHelper.isEnchantmentValid(obj, this.player) && !ContentHandler.isBlacklisted(obj) && (itemStack.func_77973_b() == Items.field_151122_aG || itemStack.func_77973_b() == Items.field_151134_bR || obj.canApplyAtEnchantingTable(itemStack))) {
            temp.put(obj.field_77352_x, 0);
        }
    }

    public void repair(EntityPlayer player, int cost) throws Exception {
        boolean flag;
        player.func_71029_a((StatBase)ContentHandler.achievementRepair);
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null) {
            return;
        }
        boolean bl = flag = !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("charge");
        if ((!itemStack.func_77948_v() || cost == 0) && flag) {
            return;
        }
        if (this.canPurchase(player, cost)) {
            int maxCost = this.repairCostMax();
            double percAmnt = (double)cost / (double)maxCost;
            int remain = itemStack.func_77952_i();
            double newDamage = (double)remain - (double)remain * percAmnt;
            newDamage = newDamage <= 0.0 ? 0.0 : newDamage;
            itemStack.func_77964_b((int)newDamage);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_82242_a(-cost);
            }
        }
        this.func_75130_a(this.tableInventory);
    }

    public int repairCostMax() {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null) {
            return 0;
        }
        if (!itemStack.func_77948_v() || !itemStack.func_77951_h()) {
            return 0;
        }
        int cost = 0;
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (Integer enchantment : enchantments.keySet()) {
            Integer enchantmentLevel = (Integer)enchantments.get(enchantment);
            cost += this.enchantmentCost(Utilities.getEnchantment((int)enchantment), enchantmentLevel, 0);
        }
        int maxDamage = itemStack.func_77958_k();
        int displayDamage = itemStack.func_77952_i();
        int enchantability = itemStack.func_77973_b().getItemEnchantability(itemStack);
        if (enchantability <= 1) {
            enchantability = 10;
        }
        double percentDamage = 1.0 - (double)(maxDamage - displayDamage) / (double)maxDamage;
        double totalCost = percentDamage * (double)cost / (double)enchantability;
        return (int)Math.max(1.0, totalCost *= (double)(2 * ConfigurationHandler.repairFactor));
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            Slot firstSlot;
            ItemStack slotStack = slot.func_75211_c();
            ItemStack tempStack = slotStack.func_77946_l();
            itemStack = slotStack.func_77946_l();
            tempStack.field_77994_a = 1;
            if (slotIndex != 0 && !(firstSlot = (Slot)this.field_75151_b.get(0)).func_75216_d() && firstSlot.func_75214_a(tempStack) && this.func_75135_a(tempStack, 0, 1, false)) {
                --slotStack.field_77994_a;
                itemStack = slotStack.func_77946_l();
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemStack.field_77994_a == slotStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(entityPlayer, slotStack);
        }
        return itemStack;
    }
}

