/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.eplus.inventory;

import java.util.List;
import net.darkhax.bookshelf.handler.BookshelfHooks;
import net.darkhax.bookshelf.lib.util.EnchantmentUtils;
import net.epoxide.eplus.common.PlayerProperties;
import net.epoxide.eplus.handler.ConfigurationHandler;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class EnchantHelper {
    public static boolean isEnchantmentValid(Enchantment ench, EntityPlayer entityPlayer) {
        return ench != null && (!ConfigurationHandler.useQuestMode || PlayerProperties.getProperties((EntityPlayer)entityPlayer).unlockedEnchantments.contains(ench.field_77352_x) || entityPlayer.field_71075_bZ.field_75098_d);
    }

    public static boolean isNewItemEnchantable(Item item) {
        if (item.equals(Items.field_151134_bR)) {
            return EnchantmentUtils.isItemEnchantable((ItemStack)new ItemStack(Items.field_151122_aG));
        }
        return EnchantmentUtils.isItemEnchantable((ItemStack)new ItemStack(item));
    }

    public static ItemStack updateEnchantments(List<EnchantmentData> enchantmentData, ItemStack itemStack, EntityPlayer player, int cost) {
        if (EnchantHelper.hasRestriction(itemStack) && !EnchantHelper.isValidOwner(itemStack, player)) {
            return itemStack;
        }
        enchantmentData = BookshelfHooks.onItemEnchanted((EntityPlayer)player, (ItemStack)itemStack, (int)cost, enchantmentData);
        NBTTagList nbttaglist = new NBTTagList();
        for (EnchantmentData data : enchantmentData) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("id", data.field_76302_b.field_77352_x);
            nbttagcompound.func_74768_a("lvl", data.field_76303_c);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (itemStack.func_77973_b() == Items.field_151122_aG) {
            itemStack = new ItemStack((Item)Items.field_151134_bR);
        }
        if (itemStack.func_77973_b() == Items.field_151134_bR) {
            if (nbttaglist.func_74745_c() > 0) {
                itemStack.func_77983_a("StoredEnchantments", (NBTBase)nbttaglist);
            } else if (itemStack.func_77942_o()) {
                itemStack.func_77978_p().func_82580_o("StoredEnchantments");
                itemStack.func_77982_d(new NBTTagCompound());
                itemStack = new ItemStack(Items.field_151122_aG);
            }
        } else if (nbttaglist.func_74745_c() > 0) {
            itemStack.func_77983_a("ench", (NBTBase)nbttaglist);
        } else if (itemStack.func_77942_o()) {
            itemStack.func_77978_p().func_82580_o("ench");
            itemStack.func_77978_p().func_82580_o("enchantedOwnerUUID");
        }
        return itemStack;
    }

    public static boolean hasRestriction(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            String enchantedOwner = itemStack.func_77978_p().func_74779_i("enchantedOwnerUUID");
            return !enchantedOwner.equals("");
        }
        return false;
    }

    public static boolean isValidOwner(ItemStack itemStack, EntityPlayer player) {
        String enchantedOwner = itemStack.func_77978_p().func_74779_i("enchantedOwnerUUID");
        return player.func_110124_au().toString().equals(enchantedOwner);
    }

    public static int calculateEnchantmentCost(Enchantment enchant, int level, ItemStack stack) {
        int existingLevel = EnchantmentHelper.func_77506_a((int)enchant.field_77352_x, (ItemStack)stack);
        int enchantability = enchant.func_77317_b(level);
        if (existingLevel > 0 && existingLevel != level) {
            enchantability -= enchant.func_77317_b(existingLevel);
        }
        return (int)((float)((enchantability - stack.func_77973_b().getItemEnchantability(stack)) / 2) * ConfigurationHandler.costFactor);
    }
}

