/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.eplus.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.Utilities;
import net.epoxide.eplus.EnchantingPlus;
import net.epoxide.eplus.client.ProxyClient;
import net.epoxide.eplus.common.PlayerProperties;
import net.epoxide.eplus.handler.ContentHandler;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemEnchantedScroll
extends Item {
    public static IIcon[] textures = new IIcon[2];

    public ItemEnchantedScroll() {
        this.func_77655_b("eplus.scroll");
        this.func_77637_a((CreativeTabs)EnchantingPlus.tabEplus);
        this.func_77627_a(true);
    }

    public static ItemStack createScroll(Enchantment ench) {
        ItemStack stack = new ItemStack(ContentHandler.itemScroll);
        ItemStackUtils.prepareDataTag((ItemStack)stack);
        stack.func_77978_p().func_74768_a("ScrollEnchantment", ench.field_77352_x);
        return stack;
    }

    public static Enchantment readScroll(ItemStack stack) {
        return ItemEnchantedScroll.isValidScroll(stack) ? Utilities.getEnchantment((int)stack.func_77978_p().func_74762_e("ScrollEnchantment")) : null;
    }

    public static boolean isValidScroll(ItemStack stack) {
        ItemStackUtils.prepareDataTag((ItemStack)stack);
        return ItemStackUtils.isValidStack((ItemStack)stack) && stack.func_77973_b() instanceof ItemEnchantedScroll && stack.func_77978_p().func_74764_b("ScrollEnchantment") && Utilities.getEnchantment((int)stack.func_77978_p().func_74762_e("ScrollEnchantment")) != null;
    }

    public static ItemStack createRandomScroll() {
        ItemStack scroll = null;
        List enchants = Utilities.getAvailableEnchantments();
        while (scroll == null) {
            Enchantment currentEnchantment = (Enchantment)enchants.get(Constants.RANDOM.nextInt(enchants.size()));
            if (ContentHandler.isBlacklisted(currentEnchantment)) continue;
            scroll = ItemEnchantedScroll.createScroll(currentEnchantment);
        }
        return scroll;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        PlayerProperties props = PlayerProperties.getProperties(player);
        Enchantment ench = ItemEnchantedScroll.readScroll(stack);
        if (!world.field_72995_K) {
            props.unlockedEnchantments.add(ench.field_77352_x);
            props.sync();
            --stack.field_77994_a;
        } else {
            ProxyClient.notificationHandler.updateNotification(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"gui.notification.eplus.unlocked"), StatCollector.func_74838_a((String)ench.func_77320_a()));
            ProxyClient.notificationHandler.updateNotificationIcon(new ItemStack(ContentHandler.blockEnchantmentBook));
        }
        return stack;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (ItemEnchantedScroll.isValidScroll(stack)) {
            PlayerProperties props = PlayerProperties.getProperties(player);
            int enchantmentID = ItemEnchantedScroll.readScroll((ItemStack)stack).field_77352_x;
            if (!props.unlockedEnchantments.contains(enchantmentID)) {
                player.func_71008_a(stack, this.func_77626_a(stack));
            }
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 60;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count % 4 == 0) {
            float percent = 1.0f - (float)count / (float)this.func_77626_a(stack);
            Utilities.spawnParticleRing((World)player.field_70170_p, (String)"enchantmenttable", (float)percent, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)0.0, (double)0.0, (double)0.0, (double)0.15);
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer reader, List tip, boolean isDebug) {
        if (ItemEnchantedScroll.isValidScroll(stack)) {
            PlayerProperties props = PlayerProperties.getProperties(reader);
            int enchantmentID = ItemEnchantedScroll.readScroll((ItemStack)stack).field_77352_x;
            tip.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tooltip.eplus.enchantment") + ": " + EnumChatFormatting.RESET + StatCollector.func_74838_a((String)ItemEnchantedScroll.readScroll(stack).func_77320_a()));
            if (props.unlockedEnchantments.contains(enchantmentID)) {
                tip.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"tooltip.eplus.learned"));
            }
        } else {
            tip.add(StatCollector.func_74838_a((String)"tooltip.eplus.invalid"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        return pass == 0 ? textures[0] : textures[1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        ItemEnchantedScroll.textures[0] = ir.func_94245_a("eplus:scroll");
        ItemEnchantedScroll.textures[1] = ir.func_94245_a("eplus:scroll_overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        Enchantment enchant;
        if (ItemEnchantedScroll.isValidScroll(stack) && pass == 1 && (enchant = ItemEnchantedScroll.readScroll(stack)) != null && enchant.field_77351_y != null) {
            return ContentHandler.getEnchantmentColor(enchant.field_77351_y.name());
        }
        return super.func_82790_a(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        for (Enchantment enchantment : Utilities.getAvailableEnchantments()) {
            if (ContentHandler.isBlacklisted(enchantment)) continue;
            itemList.add(ItemEnchantedScroll.createScroll(enchantment));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }
}

