/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.eplus.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Random;
import net.darkhax.bookshelf.lib.util.EnchantmentUtils;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.MathsUtils;
import net.epoxide.eplus.EnchantingPlus;
import net.epoxide.eplus.common.network.PacketArcaneInscriber;
import net.epoxide.eplus.common.network.PacketArcaneInscriberEffects;
import net.epoxide.eplus.handler.ContentHandler;
import net.epoxide.eplus.item.ItemEnchantedScroll;
import net.epoxide.eplus.modifiers.ScrollModifier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityArcaneInscriber
extends TileEntity {
    private ItemStack enchantmentBook;
    private ScrollModifier[] modifiers = new ScrollModifier[2];
    private final float BASE_SPEED = 0.02f;
    private final float BASE_STABILITY = 0.5f;
    private float progression = 0.0f;
    private ItemStack output;
    public int tickCount;
    public float pageFlip;
    public float pageFlipPrev;
    public float pageFlipRandom;
    public float pageFlipTurn;
    public float foldAmount;
    public float prevFoldAmount;
    public float rotation;
    public float prevRotation;
    public float bookRotation;
    private static Random random = new Random();
    private int ticker = 0;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("enchantBook")) {
            this.enchantmentBook = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("enchantBook"));
        }
        if (nbt.func_74764_b("outputStack")) {
            this.output = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("outputStack"));
        }
        if (nbt.func_74764_b("modifier0")) {
            this.modifiers[0] = ContentHandler.findScrollModifier(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("modifier0").func_74775_l("stackTag")));
        }
        if (nbt.func_74764_b("modifier1")) {
            this.modifiers[1] = ContentHandler.findScrollModifier(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("modifier1").func_74775_l("stackTag")));
        }
        this.progression = nbt.func_74760_g("progression");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (ItemStackUtils.isValidStack((ItemStack)this.enchantmentBook)) {
            ItemStackUtils.writeStackToTag((ItemStack)this.enchantmentBook, (NBTTagCompound)nbt, (String)"enchantBook");
        }
        if (ItemStackUtils.isValidStack((ItemStack)this.output)) {
            ItemStackUtils.writeStackToTag((ItemStack)this.output, (NBTTagCompound)nbt, (String)"outputStack");
        }
        if (this.modifiers[0] != null) {
            this.modifiers[0].writeModiferToNBT(nbt, "modifier0");
        }
        if (this.modifiers[1] != null) {
            this.modifiers[1].writeModiferToNBT(nbt, "modifier1");
        }
        nbt.func_74776_a("progression", this.progression);
    }

    public void func_145845_h() {
        if (this.getEnchantmentBook() != null) {
            if (this.field_145850_b.field_72995_K) {
                this.updateBook();
            } else {
                ++this.ticker;
                this.progression += this.getSpeed();
                if (this.ticker >= 20) {
                    EnchantingPlus.network.sendToAllAround((IMessage)new PacketArcaneInscriberEffects(this, this.progression), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
                    this.ticker -= 20;
                }
                if (this.progression >= 1.0f) {
                    if (MathsUtils.tryPercentage((double)this.getStability())) {
                        Enchantment[] enchantments = EnchantmentUtils.getEnchantmentsFromStack((ItemStack)this.enchantmentBook, (boolean)true);
                        ItemStack itemStack = ItemEnchantedScroll.createScroll(enchantments[(int)(Math.random() * (double)enchantments.length)]);
                        if (this.getFirstModifier() != null) {
                            itemStack = this.modifiers[0].onInscription(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, itemStack, this.enchantmentBook, this.modifiers[0].stack, this.getSecondModifier() != null ? this.modifiers[1].stack : null);
                        }
                        if (this.getSecondModifier() != null) {
                            itemStack = this.modifiers[1].onInscription(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, itemStack, this.enchantmentBook, this.getFirstModifier() != null ? this.modifiers[0].stack : null, this.modifiers[1].stack);
                        }
                        this.setOutput(itemStack);
                    }
                    EnchantingPlus.network.sendToAllAround((IMessage)new PacketArcaneInscriber(this.output, this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
                    this.updateTileInfo();
                }
            }
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void updateTileInfo() {
        this.enchantmentBook = null;
        this.modifiers = new ScrollModifier[2];
        this.progression = 0.0f;
        this.tickCount = 0;
        this.pageFlip = 0.0f;
        this.pageFlipPrev = 0.0f;
        this.pageFlipRandom = 0.0f;
        this.pageFlipTurn = 0.0f;
        this.foldAmount = 0.0f;
        this.prevFoldAmount = 0.0f;
        this.rotation = 0.0f;
        this.prevRotation = 0.0f;
        this.bookRotation = 0.0f;
        this.func_70296_d();
    }

    private void updateBook() {
        float f2;
        this.prevFoldAmount = this.foldAmount;
        this.prevRotation = this.rotation;
        EntityPlayer entityplayer = this.field_145850_b.func_72977_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), 3.0);
        if (entityplayer != null) {
            double d0 = entityplayer.field_70165_t - (double)((float)this.field_145851_c + 0.5f);
            double d1 = entityplayer.field_70161_v - (double)((float)this.field_145849_e + 0.5f);
            this.bookRotation = (float)Math.atan2(d1, d0);
            this.foldAmount += 0.1f;
            if (this.foldAmount < 0.5f || random.nextInt(40) == 0) {
                float f1 = this.pageFlipRandom;
                do {
                    this.pageFlipRandom += (float)(random.nextInt(4) - random.nextInt(4));
                } while (f1 == this.pageFlipRandom);
            }
        } else {
            this.bookRotation += 0.02f;
            this.foldAmount -= 0.1f;
        }
        while (this.rotation >= (float)Math.PI) {
            this.rotation -= (float)Math.PI * 2;
        }
        while (this.rotation < (float)(-Math.PI)) {
            this.rotation += (float)Math.PI * 2;
        }
        while (this.bookRotation >= (float)Math.PI) {
            this.bookRotation -= (float)Math.PI * 2;
        }
        while (this.bookRotation < (float)(-Math.PI)) {
            this.bookRotation += (float)Math.PI * 2;
        }
        for (f2 = this.bookRotation - this.rotation; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.rotation += f2 * 0.4f;
        if (this.foldAmount < 0.0f) {
            this.foldAmount = 0.0f;
        }
        if (this.foldAmount > 1.0f) {
            this.foldAmount = 1.0f;
        }
        ++this.tickCount;
        this.pageFlipPrev = this.pageFlip;
        float f = (this.pageFlipRandom - this.pageFlip) * 0.4f;
        float f3 = 0.2f;
        if (f < -f3) {
            f = -f3;
        }
        if (f > f3) {
            f = f3;
        }
        this.pageFlipTurn += (f - this.pageFlipTurn) * 0.9f;
        this.pageFlip += this.pageFlipTurn;
    }

    public ItemStack getEnchantmentBook() {
        return this.enchantmentBook;
    }

    public boolean setEnchantmentBook(ItemStack stack) {
        if (ItemStackUtils.isValidStack((ItemStack)stack) || stack == null) {
            this.enchantmentBook = stack;
            return true;
        }
        return false;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean setOutput(ItemStack output) {
        if (ItemStackUtils.isValidStack((ItemStack)output) || output == null) {
            this.output = output;
            return true;
        }
        return false;
    }

    public ScrollModifier[] getModifiers() {
        return this.modifiers;
    }

    public ScrollModifier getFirstModifier() {
        return this.modifiers[0];
    }

    public void setFirstModifier(ScrollModifier modifier) {
        this.modifiers[0] = modifier;
    }

    public ScrollModifier getSecondModifier() {
        return this.modifiers[1];
    }

    public void setSecondModifier(ScrollModifier modifier) {
        this.modifiers[1] = modifier;
    }

    public float getProgression() {
        return this.progression > 1.0f ? 1.0f : (this.progression < 0.0f ? 0.0f : this.progression);
    }

    public void setProgression(float time) {
        this.progression = time > 1.0f ? 1.0f : (time < 0.0f ? 0.0f : time);
    }

    public float getSpeed() {
        float speed = (0.02f + (this.getFirstModifier() != null ? this.modifiers[0].speed : 0.0f) + (this.getSecondModifier() != null ? this.modifiers[1].speed : 0.0f)) / 20.0f;
        return speed <= 1.0E-4f ? 1.0E-4f : speed;
    }

    public float getStability() {
        return 0.5f + (this.getFirstModifier() != null ? this.modifiers[0].stability : 0.0f) + (this.getSecondModifier() != null ? this.modifiers[1].stability : 0.0f);
    }

    public boolean addModifiers(ScrollModifier scrollModifier) {
        if (this.getFirstModifier() == null) {
            this.setFirstModifier(scrollModifier);
            return true;
        }
        if (this.getSecondModifier() == null) {
            this.setSecondModifier(scrollModifier);
            return true;
        }
        return false;
    }
}

