/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import mekanism.api.gas.GasRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class Gas {
    private String name;
    private String unlocalizedName;
    private Fluid fluid;
    private IIcon icon;
    private boolean visible = true;
    private boolean from_fluid = false;

    public Gas(String s) {
        this.unlocalizedName = this.name = s;
    }

    public Gas(Fluid f) {
        this.unlocalizedName = this.name = f.getName();
        this.icon = f.getStillIcon();
        this.fluid = f;
        this.from_fluid = true;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Gas setVisible(boolean v) {
        this.visible = v;
        return this;
    }

    public String getUnlocalizedName() {
        return "gas." + this.unlocalizedName;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.getUnlocalizedName());
    }

    public Gas setUnlocalizedName(String s) {
        this.unlocalizedName = s;
        return this;
    }

    public IIcon getIcon() {
        if (this.from_fluid) {
            return this.getFluid().getIcon();
        }
        return this.icon;
    }

    public Gas setIcon(IIcon i) {
        this.icon = i;
        if (this.hasFluid()) {
            this.fluid.setIcons(this.getIcon());
        }
        this.from_fluid = false;
        return this;
    }

    public int getID() {
        return GasRegistry.getGasID(this);
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        nbtTags.func_74778_a("gasName", this.getName());
        return nbtTags;
    }

    public static Gas readFromNBT(NBTTagCompound nbtTags) {
        if (nbtTags == null || nbtTags.func_82582_d()) {
            return null;
        }
        return GasRegistry.getGas(nbtTags.func_74779_i("gasName"));
    }

    public boolean hasFluid() {
        return this.fluid != null;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public Gas registerFluid() {
        if (this.fluid == null) {
            if (FluidRegistry.getFluid((String)this.getName()) == null) {
                this.fluid = new Fluid(this.getName()).setGaseous(true);
                FluidRegistry.registerFluid((Fluid)this.fluid);
            } else {
                this.fluid = FluidRegistry.getFluid((String)this.getName());
            }
        }
        return this;
    }

    public String toString() {
        return this.name;
    }
}

