/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiPRC;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiGasGauge;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.outputs.PressurizedOutput;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class PRCRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    public GuiFluidGauge fluidInput;
    public GuiGasGauge gasInput;
    public GuiGasGauge gasOutput;
    public static int xOffset = 5;
    public static int yOffset = 11;

    @Override
    public void addGuiElements() {
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 53, 34));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 140, 18).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 115, 34));
        this.fluidInput = GuiFluidGauge.getDummy(GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiPRC.png"), 5, 10);
        this.guiElements.add(this.fluidInput);
        this.gasInput = GuiGasGauge.getDummy(GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiPRC.png"), 28, 10);
        this.guiElements.add(this.gasInput);
        this.gasOutput = GuiGasGauge.getDummy(GuiGauge.Type.SMALL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiPRC.png"), 140, 40);
        this.guiElements.add(this.gasOutput);
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return PRCRecipeHandler.this.ticksPassed <= 20 ? (double)((float)PRCRecipeHandler.this.ticksPassed / 20.0f) : 1.0;
            }
        }, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 164, 15));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return PRCRecipeHandler.this.ticksPassed >= 20 ? (double)((float)((PRCRecipeHandler.this.ticksPassed - 20) % 20) / 20.0f) : 0.0;
            }
        }, this.getProgressType(), this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 75, 37));
    }

    public GuiProgress.ProgressBar getProgressType() {
        return GuiProgress.ProgressBar.MEDIUM;
    }

    public Set<Map.Entry<PressurizedInput, PressurizedRecipe>> getRecipes() {
        return RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get().entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)yOffset, (int)170, (int)68);
        for (GuiElement e : this.guiElements) {
            e.renderBackground(0, 0, -xOffset, -yOffset);
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75 - xOffset, 37 - yOffset, 36, 10), this.getRecipeId(), new Object[0]));
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public String getRecipeName() {
        return LangUtils.localize("tile.MachineBlock2.PressurizedReactionChamber.short.name");
    }

    public Class getGuiClass() {
        return GuiPRC.class;
    }

    public String getOverlayIdentifier() {
        return "prc";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public String getRecipeId() {
        return "mekanism.prc";
    }

    public String getGuiTexture() {
        return "mekanism:gui/nei/GuiPRC.png";
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        if (((PressurizedInput)recipe.pressurizedRecipe.getInput()).getFluid() != null) {
            this.fluidInput.setDummyType(((PressurizedInput)recipe.pressurizedRecipe.getInput()).getFluid().getFluid());
            this.fluidInput.renderScale(0, 0, -xOffset, -yOffset);
        }
        if (((PressurizedInput)recipe.pressurizedRecipe.getInput()).getGas() != null) {
            this.gasInput.setDummyType(((PressurizedInput)recipe.pressurizedRecipe.getInput()).getGas().getGas());
            this.gasInput.renderScale(0, 0, -xOffset, -yOffset);
        }
        if (((PressurizedOutput)recipe.pressurizedRecipe.getOutput()).getGasOutput() != null) {
            this.gasOutput.setDummyType(((PressurizedOutput)recipe.pressurizedRecipe.getOutput()).getGasOutput().getGas());
            this.gasOutput.renderScale(0, 0, -xOffset, -yOffset);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<PressurizedInput, PressurizedRecipe> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else if (outputId.equals("gas") && results.length == 1 && results[0] instanceof GasStack) {
            for (Map.Entry<PressurizedInput, PressurizedRecipe> irecipe : this.getRecipes()) {
                if (!((PressurizedOutput)irecipe.getValue().getOutput()).getGasOutput().isGasEqual((GasStack)results[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<PressurizedInput, PressurizedRecipe> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((PressurizedOutput)irecipe.getValue().getOutput()).getItemOutput(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("gas") && ingredients.length == 1 && ingredients[0] instanceof GasStack) {
            for (Map.Entry<PressurizedInput, PressurizedRecipe> irecipe : this.getRecipes()) {
                if (!irecipe.getKey().containsType((GasStack)ingredients[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else if (inputId.equals("fluid") && ingredients.length == 1 && ingredients[0] instanceof FluidStack) {
            for (Map.Entry<PressurizedInput, PressurizedRecipe> irecipe : this.getRecipes()) {
                if (!irecipe.getKey().containsType((FluidStack)ingredients[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<PressurizedInput, PressurizedRecipe> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getKey().getSolid(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe));
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft) - offset.x;
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop) - offset.y;
        if (xAxis >= 1 && xAxis <= 17 && yAxis >= 1 && yAxis <= 59) {
            currenttip.add(LangUtils.localizeFluidStack(((PressurizedInput)((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).pressurizedRecipe.getInput()).getFluid()));
        } else if (xAxis >= 24 && xAxis <= 40 && yAxis >= 1 && yAxis <= 59) {
            currenttip.add(LangUtils.localizeGasStack(((PressurizedInput)((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).pressurizedRecipe.getInput()).getGas()));
        } else if (xAxis >= 136 && xAxis <= 152 && yAxis >= 31 && yAxis <= 59) {
            currenttip.add(LangUtils.localizeGasStack(((PressurizedOutput)((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).pressurizedRecipe.getOutput()).getGasOutput()));
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft) - offset.x;
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop) - offset.y;
        GasStack gas = null;
        FluidStack fluid = null;
        if (xAxis >= 1 && xAxis <= 17 && yAxis >= 1 && yAxis <= 59) {
            fluid = ((PressurizedInput)((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).pressurizedRecipe.getInput()).getFluid();
        } else if (xAxis >= 24 && xAxis <= 40 && yAxis >= 1 && yAxis <= 59) {
            gas = ((PressurizedInput)((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).pressurizedRecipe.getInput()).getGas();
        } else if (xAxis >= 136 && xAxis <= 152 && yAxis >= 31 && yAxis <= 59) {
            gas = ((PressurizedOutput)((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).pressurizedRecipe.getOutput()).getGasOutput();
        }
        if (gas != null ? (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doGasLookup(gas, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doGasLookup(gas, true)) : fluid != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doFluidLookup(fluid, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doFluidLookup(fluid, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft) - offset.x;
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop) - offset.y;
        GasStack gas = null;
        FluidStack fluid = null;
        if (xAxis >= 1 && xAxis <= 17 && yAxis >= 1 && yAxis <= 59) {
            fluid = ((PressurizedInput)((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).pressurizedRecipe.getInput()).getFluid();
        } else if (xAxis >= 24 && xAxis <= 40 && yAxis >= 1 && yAxis <= 59) {
            gas = ((PressurizedInput)((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).pressurizedRecipe.getInput()).getGas();
        } else if (xAxis >= 136 && xAxis <= 152 && yAxis >= 31 && yAxis <= 59) {
            gas = ((PressurizedOutput)((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).pressurizedRecipe.getOutput()).getGasOutput();
        }
        if (gas != null ? (button == 0 ? this.doGasLookup(gas, false) : button == 1 && this.doGasLookup(gas, true)) : fluid != null && (button == 0 ? this.doFluidLookup(fluid, false) : button == 1 && this.doFluidLookup(fluid, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PressurizedRecipe pressurizedRecipe;
        public PositionedStack input;
        public PositionedStack output;

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedIORecipe(PressurizedRecipe recipe) {
            super((TemplateRecipeHandler)PRCRecipeHandler.this);
            this.pressurizedRecipe = recipe;
            this.input = new PositionedStack((Object)((PressurizedInput)recipe.getInput()).getSolid(), 54 - xOffset, 35 - yOffset);
            this.output = new PositionedStack((Object)((PressurizedOutput)recipe.getOutput()).getItemOutput(), 116 - xOffset, 35 - yOffset);
        }

        public CachedIORecipe(Map.Entry recipe) {
            this((PressurizedRecipe)recipe.getValue());
        }
    }
}

