/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.OreGas;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.client.render.tileentity.RenderConfigurableMachine;
import mekanism.client.render.tileentity.RenderDynamicTank;
import mekanism.client.render.tileentity.RenderFluidTank;
import mekanism.client.render.tileentity.RenderThermalEvaporationController;
import mekanism.client.render.tileentity.RenderThermoelectricBoiler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.base.ISpecialBounds;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Timer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MekanismRenderer {
    private static RenderBlocks renderBlocks = new RenderBlocks();
    public static IIcon[] colors = new IIcon[256];
    public static IIcon energyIcon;
    public static IIcon heatIcon;
    public static float GAS_RENDER_BASE;
    public static Map<TransmissionType, IIcon> overlays;
    private static float lightmapLastX;
    private static float lightmapLastY;
    private static boolean optifineBreak;
    public static int[] directionMap;
    public static RenderConfigurableMachine machineRenderer;
    private static String[] simpleSides;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new MekanismRenderer());
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            for (EnumColor enumColor : EnumColor.values()) {
                MekanismRenderer.colors[enumColor.ordinal()] = event.map.func_94245_a("mekanism:overlay/overlay_" + enumColor.unlocalizedName);
            }
            for (Enum enum_ : TransmissionType.values()) {
                overlays.put((TransmissionType)enum_, event.map.func_94245_a("mekanism:overlay/" + ((TransmissionType)enum_).getTransmission() + "Overlay"));
            }
            energyIcon = event.map.func_94245_a("mekanism:liquid/LiquidEnergy");
            heatIcon = event.map.func_94245_a("mekanism:liquid/LiquidHeat");
            GasRegistry.getGas("hydrogen").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidHydrogen"));
            GasRegistry.getGas("oxygen").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidOxygen"));
            GasRegistry.getGas("water").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidSteam"));
            GasRegistry.getGas("chlorine").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidChlorine"));
            GasRegistry.getGas("sulfurDioxideGas").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidSulfurDioxide"));
            GasRegistry.getGas("sulfurTrioxideGas").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidSulfurTrioxide"));
            GasRegistry.getGas("sulfuricAcid").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidSulfuricAcid"));
            GasRegistry.getGas("hydrogenChloride").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidHydrogenChloride"));
            GasRegistry.getGas("liquidOsmium").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidOsmium"));
            GasRegistry.getGas("liquidStone").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidStone"));
            GasRegistry.getGas("ethene").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidEthene"));
            GasRegistry.getGas("brine").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidBrine"));
            GasRegistry.getGas("sodium").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidSodium"));
            GasRegistry.getGas("deuterium").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidDeuterium"));
            GasRegistry.getGas("tritium").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidTritium"));
            GasRegistry.getGas("fusionFuelDT").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidDT"));
            GasRegistry.getGas("lithium").setIcon(event.map.func_94245_a("mekanism:liquid/LiquidLithium"));
            for (Gas gas : GasRegistry.getRegisteredGasses()) {
                if (!(gas instanceof OreGas)) continue;
                if (gas.getUnlocalizedName().contains("clean")) {
                    gas.setIcon(event.map.func_94245_a("mekanism:liquid/LiquidCleanOre"));
                    continue;
                }
                gas.setIcon(event.map.func_94245_a("mekanism:liquid/LiquidOre"));
            }
            FluidRegistry.getFluid((String)"brine").setIcons(event.map.func_94245_a("mekanism:liquid/LiquidBrine"));
            FluidRegistry.getFluid((String)"heavywater").setIcons(event.map.func_94245_a("mekanism:liquid/LiquidHeavyWater"));
            FluidRegistry.getFluid((String)"steam").setIcons(event.map.func_94245_a("mekanism:liquid/LiquidSteam"));
            for (InfuseType type : InfuseRegistry.getInfuseMap().values()) {
                type.setIcon(event.map.func_94245_a(type.textureLocation));
            }
            if (RenderPartTransmitter.getInstance() != null) {
                RenderPartTransmitter.getInstance().resetDisplayInts();
            }
            RenderDynamicTank.resetDisplayInts();
            RenderThermalEvaporationController.resetDisplayInts();
            RenderFluidTank.resetDisplayInts();
            RenderThermoelectricBoiler.resetDisplayInts();
        }
    }

    public static boolean blockIconExists(String texture) {
        String[] split = texture.split(":");
        texture = split[0] + ":textures/blocks/" + split[1] + ".png";
        try {
            Minecraft.func_71410_x().func_110442_L().func_135056_b(new ResourceLocation(texture));
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void loadDynamicTextures(IIconRegister register, String name, IIcon[] textures, DefIcon ... defaults) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            String tex = "mekanism:" + name + simpleSides[side.ordinal()];
            String texOn = tex + "On";
            if (MekanismRenderer.blockIconExists(tex)) {
                textures[side.ordinal()] = register.func_94245_a(tex);
                if (MekanismRenderer.blockIconExists(texOn)) {
                    textures[side.ordinal() + 6] = register.func_94245_a(texOn);
                    continue;
                }
                boolean found = false;
                DefIcon[] defIconArray = defaults;
                int n = defIconArray.length;
                for (int i = 0; i < n; ++i) {
                    DefIcon def = defIconArray[i];
                    if (!def.icons.contains(side.ordinal() + 6) || !def.overridesInactive) continue;
                    textures[side.ordinal() + 6] = def.defIcon;
                    found = true;
                }
                if (found) continue;
                textures[side.ordinal() + 6] = register.func_94245_a(tex);
                continue;
            }
            for (DefIcon def : defaults) {
                if (def.icons.contains(side.ordinal())) {
                    textures[side.ordinal()] = def.defIcon;
                }
                if (!def.icons.contains(side.ordinal() + 6)) continue;
                textures[side.ordinal() + 6] = def.defIcon;
            }
        }
    }

    public static void renderObject(Model3D object) {
        if (object == null) {
            return;
        }
        MekanismRenderer.renderBlocks.field_147861_i = object.maxX;
        MekanismRenderer.renderBlocks.field_147859_h = object.minX;
        MekanismRenderer.renderBlocks.field_147857_k = object.maxY;
        MekanismRenderer.renderBlocks.field_147855_j = object.minY;
        MekanismRenderer.renderBlocks.field_147853_m = object.maxZ;
        MekanismRenderer.renderBlocks.field_147851_l = object.minZ;
        MekanismRenderer.renderBlocks.field_147863_w = false;
        Tessellator.field_78398_a.func_78382_b();
        if (object.shouldSideRender(ForgeDirection.DOWN)) {
            renderBlocks.func_147768_a(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(0));
        }
        if (object.shouldSideRender(ForgeDirection.UP)) {
            renderBlocks.func_147806_b(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(1));
        }
        if (object.shouldSideRender(ForgeDirection.NORTH)) {
            renderBlocks.func_147761_c(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(2));
        }
        if (object.shouldSideRender(ForgeDirection.SOUTH)) {
            renderBlocks.func_147734_d(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(3));
        }
        if (object.shouldSideRender(ForgeDirection.WEST)) {
            renderBlocks.func_147798_e(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(4));
        }
        if (object.shouldSideRender(ForgeDirection.EAST)) {
            renderBlocks.func_147764_f(null, 0.0, 0.0, 0.0, object.getBlockTextureFromSide(5));
        }
        Tessellator.field_78398_a.func_78381_a();
    }

    public static void color(EnumColor color) {
        MekanismRenderer.color(color, 1.0f);
    }

    public static void color(EnumColor color, float alpha) {
        MekanismRenderer.color(color, alpha, 1.0f);
    }

    public static void color(EnumColor color, float alpha, float multiplier) {
        GL11.glColor4f((float)(color.getColor(0) * multiplier), (float)(color.getColor(1) * multiplier), (float)(color.getColor(2) * multiplier), (float)alpha);
    }

    public static void resetColor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static IIcon getColorIcon(EnumColor color) {
        return colors[color.ordinal()];
    }

    public static void glowOn() {
        MekanismRenderer.glowOn(15);
    }

    public static void glowOn(int glow) {
        GL11.glPushAttrib((int)64);
        try {
            lightmapLastX = OpenGlHelper.lastBrightnessX;
            lightmapLastY = OpenGlHelper.lastBrightnessY;
        }
        catch (NoSuchFieldError e) {
            optifineBreak = true;
        }
        RenderHelper.func_74518_a();
        float glowRatioX = Math.min((float)glow / 15.0f * 240.0f + lightmapLastX, 240.0f);
        float glowRatioY = Math.min((float)glow / 15.0f * 240.0f + lightmapLastY, 240.0f);
        if (!optifineBreak) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)glowRatioX, (float)glowRatioY);
        }
    }

    public static void glowOff() {
        if (!optifineBreak) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapLastX, (float)lightmapLastY);
        }
        GL11.glPopAttrib();
    }

    public static void blendOn() {
        GL11.glPushAttrib((int)16448);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void blendOff() {
        GL11.glPopAttrib();
    }

    public static void cullFrontFace() {
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)1028);
    }

    public static void disableCullFace() {
        GL11.glCullFace((int)1029);
        GL11.glDisable((int)2884);
    }

    public static void renderItem(ItemStack item) {
        IIcon icon = item.func_77973_b().func_77650_f(item);
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        if (icon == null) {
            GL11.glPopMatrix();
            return;
        }
        texturemanager.func_110577_a(texturemanager.func_130087_a(item.func_94608_d()));
        Tessellator tessellator = Tessellator.field_78398_a;
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)0.0f, (float)-0.3f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
        ItemRenderer cfr_ignored_0 = RenderManager.field_78727_a.field_78721_f;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        GL11.glDisable((int)32826);
    }

    public static void prepareItemRender(RenderBlocks renderer, int metadata, Block block) {
        if (!(block instanceof ISpecialBounds) || ((ISpecialBounds)block).doDefaultBoundSetting(metadata)) {
            block.func_149683_g();
        }
        if (block instanceof ISpecialBounds) {
            ((ISpecialBounds)block).setRenderBounds(block, metadata);
        }
        if (!(block instanceof ISpecialBounds) || ((ISpecialBounds)block).doDefaultBoundSetting(metadata)) {
            renderer.func_147775_a(block);
        } else {
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        if (renderer.field_147844_c) {
            int renderColor = block.func_149741_i(metadata);
            float red = (float)(renderColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(renderColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(renderColor & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        }
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    public static void renderCustomItem(RenderBlocks renderer, ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block instanceof ICustomBlockIcon) {
            ICustomBlockIcon custom = (ICustomBlockIcon)block;
            MekanismRenderer.prepareItemRender(renderer, stack.func_77960_j(), Block.func_149634_a((Item)stack.func_77973_b()));
            try {
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                renderer.func_147768_a(block, 0.0, 0.0, 0.0, custom.getIcon(stack, 0));
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                renderer.func_147806_b(block, 0.0, 0.0, 0.0, custom.getIcon(stack, 1));
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                renderer.func_147761_c(block, 0.0, 0.0, 0.0, custom.getIcon(stack, 3));
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                renderer.func_147734_d(block, 0.0, 0.0, 0.0, custom.getIcon(stack, 2));
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                renderer.func_147798_e(block, 0.0, 0.0, 0.0, custom.getIcon(stack, 4));
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                renderer.func_147764_f(block, 0.0, 0.0, 0.0, custom.getIcon(stack, 5));
                tessellator.func_78381_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    public static void renderItem(RenderBlocks renderer, int metadata, Block block) {
        MekanismRenderer.prepareItemRender(renderer, metadata, block);
        try {
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_147768_a(block, 0.0, 0.0, 0.0, block.func_149691_a(0, metadata));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderer.func_147806_b(block, 0.0, 0.0, 0.0, block.func_149691_a(1, metadata));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_147761_c(block, 0.0, 0.0, 0.0, block.func_149691_a(3, metadata));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_147734_d(block, 0.0, 0.0, 0.0, block.func_149691_a(2, metadata));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_147798_e(block, 0.0, 0.0, 0.0, block.func_149691_a(4, metadata));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_147764_f(block, 0.0, 0.0, 0.0, block.func_149691_a(5, metadata));
            tessellator.func_78381_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void colorFluid(Fluid fluid) {
        int color = fluid.getColor();
        float cR = (float)(color >> 16 & 0xFF) / 255.0f;
        float cG = (float)(color >> 8 & 0xFF) / 255.0f;
        float cB = (float)(color & 0xFF) / 255.0f;
        GL11.glColor3f((float)cR, (float)cG, (float)cB);
    }

    public static TextureMap getTextureMap(int type) {
        try {
            List l = (List)MekanismUtils.getPrivateValue(Minecraft.func_71410_x().field_71446_o, TextureManager.class, ObfuscatedNames.TextureManager_listTickables);
            for (Object obj : l) {
                if (!(obj instanceof TextureMap) || ((TextureMap)obj).func_130086_a() != type) continue;
                return (TextureMap)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static float getPartialTick() {
        try {
            Timer t = (Timer)MekanismUtils.getPrivateValue(Minecraft.func_71410_x(), Minecraft.class, ObfuscatedNames.Minecraft_timer);
            return t.field_74281_c;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        boolean zLevel = false;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par6), (double)zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), (double)zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0), (double)zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78381_a();
    }

    public static ResourceLocation getBlocksTexture() {
        return TextureMap.field_110575_b;
    }

    public static ResourceLocation getItemsTexture() {
        return TextureMap.field_110576_c;
    }

    static {
        GAS_RENDER_BASE = 0.2f;
        overlays = new HashMap<TransmissionType, IIcon>();
        optifineBreak = false;
        directionMap = new int[]{3, 0, 1, 2};
        machineRenderer = new RenderConfigurableMachine();
        simpleSides = new String[]{"Bottom", "Top", "Front", "Back", "Left", "Right"};
    }

    public static interface ICustomBlockIcon {
        public IIcon getIcon(ItemStack var1, int var2);
    }

    public static class DisplayInteger {
        public int display;

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.display;
            return code;
        }

        public boolean equals(Object obj) {
            return obj instanceof DisplayInteger && ((DisplayInteger)obj).display == this.display;
        }

        public static DisplayInteger createAndStart() {
            DisplayInteger newInteger = new DisplayInteger();
            newInteger.display = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)newInteger.display, (int)4864);
            return newInteger;
        }

        public static void endList() {
            GL11.glEndList();
        }

        public void render() {
            GL11.glCallList((int)this.display);
        }
    }

    public static class Model3D {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;
        public IIcon[] textures = new IIcon[6];
        public boolean[] renderSides = new boolean[]{true, true, true, true, true, true, false};
        public Block baseBlock = Blocks.field_150354_m;

        public final void setBlockBounds(double xNeg, double yNeg, double zNeg, double xPos, double yPos, double zPos) {
            this.minX = xNeg;
            this.minY = yNeg;
            this.minZ = zNeg;
            this.maxX = xPos;
            this.maxY = yPos;
            this.maxZ = zPos;
        }

        public void setSideRender(ForgeDirection side, boolean value) {
            this.renderSides[side.ordinal()] = value;
        }

        public boolean shouldSideRender(ForgeDirection side) {
            return this.renderSides[side.ordinal()];
        }

        public IIcon getBlockTextureFromSide(int i) {
            return this.textures[i];
        }

        public void setTexture(IIcon tex) {
            Arrays.fill(this.textures, tex);
        }

        public void setTextures(IIcon down, IIcon up, IIcon north, IIcon south, IIcon west, IIcon east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
        }
    }

    public static class DefIcon {
        public IIcon defIcon;
        public List<Integer> icons = new ArrayList<Integer>();
        public boolean overridesInactive = true;

        public DefIcon(IIcon icon, int ... is) {
            this.defIcon = icon;
            for (int i : is) {
                this.icons.add(i);
            }
        }

        public DefIcon setOverrides(boolean b) {
            this.overridesInactive = b;
            return this;
        }

        public static DefIcon getAll(IIcon icon) {
            return new DefIcon(icon, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
        }

        public static DefIcon getActivePair(IIcon icon, int ... is) {
            DefIcon ret = new DefIcon(icon, is);
            for (int i : is) {
                ret.icons.add(i + 6);
            }
            return ret;
        }
    }
}

