/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.client.model.ModelFluidTank;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Tier;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderFluidTank
extends TileEntitySpecialRenderer {
    private static Map<Fluid, MekanismRenderer.DisplayInteger[]> cachedCenterFluids = new HashMap<Fluid, MekanismRenderer.DisplayInteger[]>();
    private static Map<Fluid, MekanismRenderer.DisplayInteger[]> cachedValveFluids = new HashMap<Fluid, MekanismRenderer.DisplayInteger[]>();
    private static int stages = 1400;
    private ModelFluidTank model = new ModelFluidTank();

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityFluidTank)tileEntity, x, y, z, partialTick);
    }

    private void renderAModelAt(TileEntityFluidTank tileEntity, double x, double y, double z, float partialTick) {
        Fluid fluid = tileEntity.fluidTank.getFluid() != null ? tileEntity.fluidTank.getFluid().getFluid() : null;
        this.render(tileEntity.tier, fluid, tileEntity.prevScale, tileEntity.isActive, tileEntity.valve > 0 ? tileEntity.valveFluid : null, x, y, z);
    }

    public void render(Tier.FluidTankTier tier, Fluid fluid, float fluidScale, boolean active, Fluid valveFluid, double x, double y, double z) {
        if (fluid != null && fluidScale > 0.0f) {
            this.push();
            this.func_147499_a(MekanismRenderer.getBlocksTexture());
            GL11.glTranslated((double)x, (double)y, (double)z);
            MekanismRenderer.glowOn(fluid.getLuminosity());
            MekanismRenderer.colorFluid(fluid);
            MekanismRenderer.DisplayInteger[] displayList = this.getListAndRender(fluid);
            if (fluid.isGaseous()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, fluidScale + MekanismRenderer.GAS_RENDER_BASE));
                displayList[stages - 1].render();
            } else {
                displayList[Math.min(stages - 1, (int)(fluidScale * ((float)stages - 1.0f)))].render();
            }
            MekanismRenderer.glowOff();
            MekanismRenderer.resetColor();
            this.pop();
        }
        if (valveFluid != null && !valveFluid.isGaseous()) {
            this.push();
            this.func_147499_a(MekanismRenderer.getBlocksTexture());
            GL11.glTranslated((double)x, (double)y, (double)z);
            MekanismRenderer.glowOn(valveFluid.getLuminosity());
            MekanismRenderer.colorFluid(valveFluid);
            MekanismRenderer.DisplayInteger[] valveList = this.getValveRender(valveFluid);
            valveList[Math.min(stages - 1, (int)(fluidScale * ((float)stages - 1.0f)))].render();
            MekanismRenderer.glowOff();
            MekanismRenderer.resetColor();
            this.pop();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "FluidTank" + (active ? "On" : "") + ".png"));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.render(0.0625f, tier);
        GL11.glPopMatrix();
    }

    private void pop() {
        GL11.glPopAttrib();
        MekanismRenderer.blendOff();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        MekanismRenderer.blendOn();
    }

    private MekanismRenderer.DisplayInteger[] getValveRender(Fluid fluid) {
        if (cachedValveFluids.containsKey(fluid)) {
            return cachedValveFluids.get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(fluid.getFlowingIcon());
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[stages];
        cachedValveFluids.put(fluid, displays);
        for (int i = 0; i < stages; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getIcon() != null) {
                toReturn.minX = 0.3225;
                toReturn.minY = 0.0625 + (double)((float)i / (float)stages) * 0.875;
                toReturn.minZ = 0.3225;
                toReturn.maxX = 0.6775;
                toReturn.maxY = 0.9275;
                toReturn.maxZ = 0.6775;
                MekanismRenderer.renderObject(toReturn);
            }
            GL11.glEndList();
        }
        return displays;
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(Fluid fluid) {
        if (cachedCenterFluids.containsKey(fluid)) {
            return cachedCenterFluids.get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(fluid.getIcon());
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[stages];
        cachedCenterFluids.put(fluid, displays);
        for (int i = 0; i < stages; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getIcon() != null) {
                toReturn.minX = 0.135;
                toReturn.minY = 0.0725;
                toReturn.minZ = 0.135;
                toReturn.maxX = 0.865;
                toReturn.maxY = 0.0625 + (double)((float)i / (float)stages) * 0.875 - 0.01;
                toReturn.maxZ = 0.865;
                MekanismRenderer.renderObject(toReturn);
            }
            GL11.glEndList();
        }
        return displays;
    }

    public static void resetDisplayInts() {
        cachedCenterFluids.clear();
        cachedValveFluids.clear();
    }
}

