/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mekanism.common.block.BlockBasic;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityBoundingBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockBounding
extends Block {
    public BlockBounding() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a(BlockBasic.ICON_BASE);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int facing, float playerX, float playerY, float playerZ) {
        try {
            TileEntityBoundingBlock tileEntity = (TileEntityBoundingBlock)world.func_147438_o(x, y, z);
            return this.getMainBlock(tileEntity, world).func_149727_a(world, tileEntity.mainX, tileEntity.mainY, tileEntity.mainZ, entityplayer, facing, playerX, playerY, playerZ);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        world.func_147475_p(x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        try {
            TileEntityBoundingBlock tileEntity = (TileEntityBoundingBlock)world.func_147438_o(x, y, z);
            return this.getMainBlock(tileEntity, world).getPickBlock(target, world, tileEntity.mainX, tileEntity.mainY, tileEntity.mainZ, player);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        try {
            TileEntityBoundingBlock tileEntity = (TileEntityBoundingBlock)world.func_147438_o(x, y, z);
            return this.getMainBlock(tileEntity, world).removedByPlayer(world, player, tileEntity.mainX, tileEntity.mainY, tileEntity.mainZ, willHarvest);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        try {
            TileEntityBoundingBlock tileEntity = (TileEntityBoundingBlock)world.func_147438_o(x, y, z);
            tileEntity.onNeighborChange(block);
            this.getMainBlock(tileEntity, world).func_149695_a(world, tileEntity.mainX, tileEntity.mainY, tileEntity.mainZ, (Block)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        try {
            TileEntityBoundingBlock tileEntity = (TileEntityBoundingBlock)world.func_147438_o(x, y, z);
            return this.getMainBlock(tileEntity, world).func_149737_a(player, world, tileEntity.mainX, tileEntity.mainY, tileEntity.mainZ);
        }
        catch (Exception e) {
            return super.func_149737_a(player, world, x, y, z);
        }
    }

    private Block getMainBlock(TileEntityBoundingBlock mainTile, World world) {
        Block block = world.func_147439_a(mainTile.mainX, mainTile.mainY, mainTile.mainZ);
        if (block instanceof BlockBounding) {
            return null;
        }
        return block;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_149650_a(int i, Random random, int j) {
        return null;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 0) {
            return new TileEntityBoundingBlock();
        }
        if (metadata == 1) {
            return new TileEntityAdvancedBoundingBlock();
        }
        return null;
    }
}

